#pragma once

class Procedure{
public:
	// 
	enum Kind{
		Sub,
		Function,
	};

private:
	const string name;

	Kind kind;

	bool isCdecl;
	bool isUsing;

protected:

	// p[^
	Parameters params;

	// ߂ľ^
	Type returnType;

	// \[XR[ḧʒu
	int codePos;

public:
	Procedure( const string &name, Kind kind, bool isCdecl ):
	  name( name ),
	  kind( kind ),
	  isCdecl( isCdecl ),
	  isUsing( false ),
	  codePos( -1 )
	{}
	~Procedure(){
		foreach( Parameter *pParam, params ){
			delete pParam;
		}
	}

	const string &GetName() const
	{
		return name;
	}

	bool IsSub() const
	{
		return ( kind == Sub );
	}
	bool IsFunction() const
	{
		return ( kind == Function );
	}

	bool IsCdecl() const
	{
		return isCdecl;
	}
	void Using(){
		isUsing = true;
	}
	bool IsUsing() const
	{
		return isUsing;
	}

	int GetCodePos() const
	{
		return codePos;
	}

	const Parameters &Params() const
	{
		return params;
	}
	const Type &ReturnType() const
	{
		return returnType;
	}
};

class UserProc : public Procedure
{
#ifdef _DEBUG
public:
	string _paramStr;
#endif

private:
	bool isMacro;

	// p[^̒ǉ
	int secondParmNum;
	Parameters realParams;
	int realSecondParmNum;

	// eNXƑΉ郁\bh
	CClass *pParentClass;
	CMethod *pMethod;

	// etO
	bool isExport;
	bool isSystem;
	bool isAutoGeneration;
	bool isCompiled;

public:
	// nbVXgp
	UserProc *pNextData;

	UserProc( const string &name, Kind kind, bool isMacro, bool isCdecl, bool isExport ):
	  Procedure( name, kind, isCdecl ),
	  isMacro( isMacro ),
	  pParentClass( NULL ),
	  pMethod( NULL ),
	  isExport( isExport ),
	  isSystem( false ),
	  isAutoGeneration( false ),
	  isCompiled( false ),
	  pNextData( NULL ),
	  beginOpAddress( 0 ),
	  endOpAddress( 0 )
	{
	}
	~UserProc(){
		foreach( Parameter *pParam, realParams ){
			delete pParam;
		}
	}

	string GetFullName() const
	{
		if( HasParentClass() ){
			return (string)GetParentClass().name + "." + GetName();
		}

		return GetName();
	}

	bool IsMacro() const
	{
		return isMacro;
	}

	virtual bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine, bool isStatic );

	int GetSecondParmNum() const
	{
		return secondParmNum;
	}
	const Parameters &RealParams() const
	{
		return realParams;
	}
	int GetRealSecondParmNum() const
	{
		return realSecondParmNum;
	}

	void SetParentClass( CClass *pParentClass ){
		this->pParentClass = pParentClass;
	}
	CClass *GetParentClassPtr()
	{
		return pParentClass;
	}
	const CClass &GetParentClass() const
	{
		return *pParentClass;
	}
	bool HasParentClass() const
	{
		return ( pParentClass != NULL );
	}
	void SetMethod( CMethod *pMethod ){
		this->pMethod = pMethod;
	}

	void ExportOff(){
		isExport = false;
	}
	bool IsExport() const
	{
		return isExport;
	}
	void ThisIsSystemProc(){
		isSystem = true;
	}
	bool IsSystem() const
	{
		return isSystem;
	}
	void ThisIsAutoGenerationProc(){
		isAutoGeneration = true;
	}
	bool IsAutoGeneration(){
		return isAutoGeneration;
	}
	void CompleteCompile(){
		isCompiled = true;
	}
	void KillCompileStatus(){
		isCompiled = false;
	}
	bool IsCompiled() const
	{
		return isCompiled;
	}
	bool IsDestructor() const
	{
		return ( GetName()[0] == '~' );
	}
	bool IsVirtual() const
	{
		if( pMethod == NULL ){
			return false;
		}
		return ( pMethod->bVirtual != 0 );
	}


	// oCiR[ḧʒu
	DWORD beginOpAddress;
	DWORD endOpAddress;
	int GetCodeSize() const
	{
		return endOpAddress - beginOpAddress;
	}

	// [Jϐ
	Variables localVars;

	// TODO: K؂ȃR[h֒
	long id;


	/////////////////////////////////////////////////////////////////
	// RpC̊֐Ǘ
	/////////////////////////////////////////////////////////////////
private:
	static UserProc *pCompilingUserProc;
public:
	static void CompileStartForGlobalArea(){
		pCompilingUserProc = NULL;
	}
	static void CompileStartForUserProc( UserProc *pUserProc ){
		pCompilingUserProc = pUserProc;
	}
	static bool IsGlobalAreaCompiling(){
		return ( pCompilingUserProc == NULL );
	}
	static bool IsLocalAreaCompiling(){
		return ( pCompilingUserProc != NULL );
	}
	static UserProc &CompilingUserProc(){
		return *pCompilingUserProc;
	}
};

class DllProc : public Procedure
{
	const string dllFileName;
	const string alias;
	int lookupAddress;

public:
	// nbVXgp
	DllProc *pNextData;

	DllProc( const string &name, Kind kind, bool isCdecl, const string &dllFileName, const string &alias ):
	  Procedure( name, kind, isCdecl ),
	  dllFileName( dllFileName ),
	  alias( alias ),
	  lookupAddress( 0 ),
	  pNextData( NULL )
	{
	}
	~DllProc(){}

	virtual bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine );

	const string &GetDllFileName() const
	{
		return dllFileName;
	}
	const string &GetAlias() const
	{
		return alias;
	}

	void SetLookupAddress( int lookupAddress ){
		this->lookupAddress = lookupAddress;
	}
	int GetLookupAddress() const
	{
		return lookupAddress;
	}

};

class ProcPointer : public Procedure
{
public:
	ProcPointer( Kind kind ):
	  Procedure( "", kind, false )
	{
	}
	~ProcPointer(){}

	virtual bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine );
};
