#include "common.h"


TypeDef::TypeDef( const string &newName, const string &baseName ):
	newName( newName ),
	baseName( baseName )
{
	if( !Type::StringToType( baseName, baseType ) ){
		SetError(3, baseName, cp );
		return;
	}
}
TypeDef::~TypeDef(){
}


TypeDefCollection::TypeDefCollection(){
}
TypeDefCollection::~TypeDefCollection(){
}
void TypeDefCollection::Add( const string &newName, const string &baseName ){
	TypeDef typeDef( newName, baseName );
	this->push_back( typeDef );
}
int TypeDefCollection::GetIndex( const string &typeName ) const{
	int max = (int)(*this).size();
	for( int i=0; i<max; i++ ){
		if( (*this)[i].newName == typeName ){
			return i;
		}
	}
	return -1;
}

void TypeDefCollection::Add( const string &expression, int nowLine ){
	int i;
	char temporary[VN_SIZE];

	for(i=0;;i++){
		if(expression[i]=='='||expression[i]=='\0'){
			temporary[i]=0;
			break;
		}
		temporary[i]=expression[i];
	}

	if(expression[i]!='='){
		SetError(10,"TypeDef",nowLine);
		return;
	}

	const char *pTemp=expression.c_str()+i+1;

	//ʕ̃G[`FbNiV^j
	i=0;
	for(;;i++){
		if(temporary[i]=='\0') break;
		if(!IsVariableChar(temporary[i])){
			SetError(10,"TypeDef",nowLine);
			return;
		}
	}

	//ʕ̃G[`FbNiRs[̌^j
	if(pTemp[0]=='*'&&pTemp[1]==1&&(pTemp[2]==ESC_FUNCTION||pTemp[2]==ESC_SUB)){
		//֐|C^
		if(pTemp[3]!='('){
			SetError(10,"TypeDef",nowLine);
			return;
		}
	}
	else{
		i=0;
		while(pTemp[i]=='*') i++;
		for(;;i++){
			if(pTemp[i]=='\0') break;
			if(!IsVariableChar(pTemp[i])){
				SetError(10,"TypeDef",nowLine);
				return;
			}
		}
	}

	//ʎqdĂꍇ̓G[ɂ
	if(lstrcmp(temporary,pTemp)==0){
		SetError(1,NULL,nowLine);
		return;
	}



	//////////////////////////
	// TypeDefǉ
	//////////////////////////

	//G[p
	extern int cp;
	cp = nowLine;

	Smoothie::Meta::typeDefs.Add(temporary,pTemp);
}

void TypeDefCollection::Init(){
	// 
	clear();

	int i=-1;
	while(1){
		i++;

		extern char *basbuf;
		if( basbuf[i]==1 ){
			char temporary[VN_SIZE];
			if(basbuf[i+1]==ESC_TYPEDEF){
				int i2 = 0;
				for(i+=2;;i2++,i++){
					if(basbuf[i]=='\n'){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
					if(basbuf[i]=='\0') break;
				}
				Add(temporary,i);

				continue;
			}
			else if( basbuf[i+1] == ESC_CONST && basbuf[i+2] == 1 && basbuf[i+3] == ESC_ENUM ){
				int i2 = 0;
				for(i+=4;;i2++,i++){
					if(!IsVariableChar(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
					if(basbuf[i]=='\0') break;
				}
				Smoothie::Meta::typeDefs.Add(temporary,"Long");
			}
		}

		//̍s
		for(;;i++){
			if(IsCommandDelimitation(basbuf[i])) break;
		}
		if(basbuf[i]=='\0') break;
	}
}
