#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif


void Diagnose(){
	char temporary[8192];

	// O[o / [J R[ḧ̃TCY𒲂ׂ
	extern int obp;
	extern int GlobalOpBufferSize;
	sprintf(temporary, "%d", GlobalOpBufferSize/1024 );
	Smoothie::Logger::Put( (string)"O[ö̃R[hTCY: " + temporary + "KB" );
	sprintf(temporary, "%d", (obp-GlobalOpBufferSize)/1024 );
	Smoothie::Logger::Put( (string)"[J̈̃R[hTCY: " + temporary + "KB" );

	{
		// O[o֐ANX\bh̃TCY𒲂ׂ
		int codeSizeOfGlobalProc = 0;
		int codeSizeOfClassMethod = 0;
		for(int i2=0;i2<MAX_HASH;i2++){
			extern UserProc **ppSubHash;
			UserProc *pUserProc = ppSubHash[i2];
			while(pUserProc){
				if( pUserProc->IsCompiled() ){
					if( pUserProc->HasParentClass() ){
						codeSizeOfClassMethod += pUserProc->GetCodeSize();
					}
					else{
						codeSizeOfGlobalProc += pUserProc->GetCodeSize();
					}
				}

				pUserProc=pUserProc->pNextData;
			}
		}

		sprintf(temporary, "%d", codeSizeOfGlobalProc/1024 );
		Smoothie::Logger::Put( (string)"O[o֐̃R[hTCY: " + temporary + "KB" );
		sprintf(temporary, "%d", codeSizeOfClassMethod/1024 );
		Smoothie::Logger::Put( (string)"NX\bh̃R[hTCY: " + temporary + "KB" );

		Smoothie::Logger::Put( "\n\n" );
	}

	{
		// NX̃TCY𒲂ׂ

		// Ce[^Zbg
		extern CDBClass *pobj_DBClass;
		pobj_DBClass->Iterator_Reset();

		while( pobj_DBClass->Iterator_HasNext() ){
			int codeSizeOfClass = 0;

			CClass &objClass = *pobj_DBClass->Iterator_GetNext();

			// I\bh
			foreach( const CMethod &method, objClass.GetMethods() ){
				if( method.pUserProc->IsCompiled() ){
					codeSizeOfClass += method.pUserProc->GetCodeSize();
				}
			}

			// ÓI\bh
			foreach( const CMethod &method, objClass.GetStaticMethods() ){
					codeSizeOfClass += method.pUserProc->GetCodeSize();
			}

			if( codeSizeOfClass ){
				temporary[0]=0;
				lstrcat( temporary, "------------------------------------------------------------------\n" );
				sprintf( temporary + lstrlen(temporary), "y %s NX̃R[hz\n", objClass.name );
				sprintf( temporary + lstrlen(temporary), "class code size: %d bytes\n", codeSizeOfClass );
				lstrcat( temporary, "------------------------------------------------------------------\n" );
				lstrcat( temporary, "\n" );
				Smoothie::Logger::Put( temporary );
			}
		}

	}
}
