#pragma once

#include <vector>
#include <string>

#include <windows.h>
#include <stdlib.h>

using namespace std;

class Text{
protected:
	char *buffer;
	int length;

public:

	enum ReturnLineChar{
		CR,
		LF,
		CRLF,
	};

	Text(){
		buffer = (char *)calloc( 1, 1 );
		length = 0;
	}
	~Text(){
		free( buffer );
	}

	bool ReadFile( const string &filePath );

	void ChangeReturnLineChar();

	char *Buffer(){
		return buffer;
	}
	int Length(){
		return length;
	}
};

class BasicSource : public Text
{
public:
	BasicSource(){}
	~BasicSource(){}

	void RemoveComments();

	void DirectiveIfdef();
	void DirectiveIncludeOrRequire();

	void RemoveReturnLineUnderbar();

	void FormatDefStatement();
	void FormatIfStatement();

	bool Generate( const string &genName, const char *buffer );
};
