#pragma once

namespace ActiveBasic{ namespace IDE{ namespace WindowComponents{ namespace CodeEditor{


struct ReservedKeywordWithQuickHelp
{
	std::string keyword;
	std::string quickHelp;
};
typedef std::vector<ReservedKeywordWithQuickHelp> ReservedKeywordsWithQuickHelp;
struct Syntax
{
	std::string commentSingle;
	std::string commentMultiBegin;
	std::string commentMultiEnd;
	Jenga::Common::Strings quoteMarks;
	Jenga::Common::Strings reservedSimpleKeywords;
	ReservedKeywordsWithQuickHelp reservedKeywordsWithQuickHelp;
};
class Language
{
	std::string name;
	Syntax syntax;
public:
	const std::string &GetName() const
	{
		return name;
	}
	const Syntax &GetSyntax() const
	{
		return syntax;
	}

	void Load( const TiXmlDocument &doc );
	bool IsExistKeyword( const std::string &keyword ) const;
	bool IsExistReservedKeywordWithQuickHelp( const std::string &keyword ) const;
	const std::string &GetReservedKeywordWithQuickHelp( const std::string &keyword ) const;
	bool IsQuoteMark( char c ) const;
};
class Languages
	: public std::map<std::string, Language>
{
	void Add( const std::string &xmlPath );
public:
	void LoadFiles( const std::string &dirPath );
};


}}}}
