#pragma once
#include <algorithm>

namespace ActiveBasic{ namespace Common{ namespace Lexical{


class NamespaceScopes : public std::vector<std::string>
{
	typedef std::vector<std::string> Base;
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & boost::serialization::make_nvp("vector_string", boost::serialization::base_object<std::vector<std::string>>(*this));
	}


public:
	NamespaceScopes() {}
	NamespaceScopes(NamespaceScopes const& y)
		: Base(y)
	{
	}
	NamespaceScopes(NamespaceScopes&& y)
		: Base(std::move(y))
	{
	}
	NamespaceScopes( const std::string &namespaceStr );
	NamespaceScopes( NamespaceScopes::const_iterator first, NamespaceScopes::const_iterator last )
		: Base(first, last)
	{
	}
	~NamespaceScopes(){}

	void append( const NamespaceScopes &namespaceScopes )
	{
		insert( end(), namespaceScopes.begin(), namespaceScopes.end() );
	}

	NamespaceScopes& operator +=(const NamespaceScopes &namespaceScopes)
	{
		append(namespaceScopes);
		return *this;
	}

	std::string ToString() const
	{
		std::string namespaceStr;
		const std::vector<std::string> &me = *this;

		bool isFirst = true;
		foreach( const std::string &itemStr, me ){
			if( isFirst ){
				isFirst = false;
			}
			else{
				namespaceStr += '.';
			}

			namespaceStr += itemStr;
		}
		return namespaceStr;
	}

	// `FbN
	bool IsEqual( const std::string &name ) const
	{
		if( ToString() == name ){
			return true;
		}
		return false;
	}

	// `FbN
	bool IsEqual( const NamespaceScopes &namespaceScopes ) const;

	// Ă邩`FbN
	// :
	// baseNamespaceScopes =  "Discoversoft"
	// entryNamespaceScopes = "Discoversoft.ActiveBasic"
	// ̏ꍇAentryNamespaceScopes  baseNamespaceScopes ɏĂB
	static bool IsBelong( const NamespaceScopes &baseNamespaceScopes, const NamespaceScopes &entryNamespaceScopes )
	{
		if( baseNamespaceScopes.size() > entryNamespaceScopes.size() ){
			return false;
		}
		return std::equal( baseNamespaceScopes.begin(), baseNamespaceScopes.end(), entryNamespaceScopes.begin() );
	}
};

NamespaceScopes operator +(const NamespaceScopes &lhs, const NamespaceScopes &rhs);

inline bool operator ==( const NamespaceScopes &lhs, const NamespaceScopes &rhs )
{
	return lhs.IsEqual( rhs );
}

class NamespaceScopesCollection : public std::vector<NamespaceScopes>
{
	typedef std::vector<NamespaceScopes> Base;
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & boost::serialization::make_nvp("vector_NamespaceScopes", boost::serialization::base_object<vector<NamespaceScopes>>(*this));
	}

public:
	NamespaceScopesCollection() : Base() {}
	NamespaceScopesCollection(NamespaceScopesCollection&& y) : Base(std::move(y)) {}
	NamespaceScopesCollection(NamespaceScopesCollection const& y) : Base(y) {}
	NamespaceScopesCollection& operator =(NamespaceScopesCollection&& y)
	{
		Base::operator =(std::move(y));
		return *this;
	}
	NamespaceScopesCollection& operator =(NamespaceScopesCollection const& y)
	{
		return operator =(NamespaceScopesCollection(y));
	}
	bool IsExist( const NamespaceScopes &namespaceScopes ) const
	{
		return std::find( this->begin(), this->end(), namespaceScopes ) != this->end();
	}
	bool IsExist( const std::string &namespaceStr ) const
	{
		return IsExist( NamespaceScopes( namespaceStr ) );
	}

	bool IsImported( const NamespaceScopes &namespaceScopes ) const
	{
		return IsExist( namespaceScopes );
	}

	void SplitNamespace( const char *fullName, char *namespaceStr, char *simpleName ) const;
};


}}}
