#include "stdafx.h"

using namespace ActiveBasic::PM::FM;

File::File( const std::string &relationalPath, HTREEITEM hTreeItem )
	: ItemBase( hTreeItem )
	, relationalPath( relationalPath )
{
}

const std::string File::GetFullPath() const
{
	return projectInfo.GetWorkDir().GetFullPath( relationalPath );
}

bool ActiveBasic::PM::FM::Folder::IsEmpty() const
{
	BOOST_FOREACH( const ActiveBasic::PM::FM::Folder &folder, folders )
	{
		if( !folder.IsEmpty() )
		{
			return false;
		}
	}

	return files.empty();
}

void ActiveBasic::PM::FM::Folder::Clear()
{
	files.clear();
	folders.clear();
}

File &ActiveBasic::PM::FM::Folder::FindFile( HTREEITEM hTreeItem )
{
	BOOST_FOREACH( ActiveBasic::PM::FM::Folder &folder, folders )
	{
		if( folder.IsExistFile( hTreeItem ) )
		{
			return folder.FindFile( hTreeItem );
		}
	}

	BOOST_FOREACH( File &file, files )
	{
		if( file.GetTreeItemHandle() == hTreeItem )
		{
			return file;
		}
	}
	throw;
}

File &ActiveBasic::PM::FM::Folder::FindFile( const std::string &path )
{
	BOOST_FOREACH( ActiveBasic::PM::FM::Folder &folder, folders )
	{
		if( folder.IsExistFile( path ) )
		{
			return folder.FindFile( path );
		}
	}

	BOOST_FOREACH( File &file, files )
	{
		if( file.GetRelationalPath() == path || file.GetFullPath() == path )
		{
			return file;
		}
	}
	throw;
}

bool ActiveBasic::PM::FM::Folder::IsExistFile( const std::string &path ) const
{
	BOOST_FOREACH( const ActiveBasic::PM::FM::Folder &folder, folders )
	{
		if( folder.IsExistFile( path ) )
		{
			return true;
		}
	}

	BOOST_FOREACH( const File &file, files )
	{
		if( file.GetRelationalPath() == path || file.GetFullPath() == path )
		{
			return true;
		}
	}
	return false;
}

bool ActiveBasic::PM::FM::Folder::IsExistFile( HTREEITEM hTreeItem ) const
{
	BOOST_FOREACH( const ActiveBasic::PM::FM::Folder &folder, folders )
	{
		if( folder.IsExistFile( hTreeItem ) )
		{
			return true;
		}
	}

	BOOST_FOREACH( const File &file, files )
	{
		if( file.GetTreeItemHandle() == hTreeItem )
		{
			return true;
		}
	}
	return false;
}

void ActiveBasic::PM::FM::Folder::Remove( HTREEITEM hTreeItem )
{
	BOOST_FOREACH( ActiveBasic::PM::FM::Folder &folder, folders )
	{
		if( folder.IsExistFile( hTreeItem ) )
		{
			folder.Remove( hTreeItem );
			return;
		}
	}

	for( int i=0; i<static_cast<int>(files.size()); i++ )
	{
		if( files[i].GetTreeItemHandle() == hTreeItem )
		{
			Jenga::Common::EraseVectorItem<Files>( files, i );
			return;
		}
	}
	throw;
}
