#pragma once


namespace ActiveBasic{ namespace PM{


struct ImageReferenceType
{
	enum EnumType
	{
		File = 0,
		Resource,
	};
};

class ImageControlInfo
{
public:
	ImageReferenceType::EnumType type;
	std::string path;

	bool IsFile() const
	{
		return ( type == ImageReferenceType::File );
	}
	bool IsResource() const
	{
		return ( type == ImageReferenceType::Resource );
	}
};

class WindowInfoBase
{
public:
	const std::string &GetName() const
	{
		return name;
	}
	void SetName( const std::string &name )
	{
		this->name = name;
	}

	const std::string &GetCaption() const
	{
		return caption;
	}
	void SetCaption( const std::string &caption )
	{
		this->caption = caption;
	}

	DWORD GetStyle() const
	{
		return style;
	}
	void SetStyle( DWORD style )
	{
		this->style = style;
	}
	void AddStyle( DWORD style )
	{
		this->style |= style;
	}
	void AndStyle( DWORD style )
	{
		this->style &= style;
	}
	void DeleteStyle( DWORD style )
	{
		this->style &= ~style;
	}

	DWORD GetExStyle() const
	{
		return exstyle;
	}
	void SetExStyle( DWORD exstyle )
	{
		this->exstyle = exstyle;
	}
	void AddExStyle( DWORD exstyle )
	{
		this->exstyle |= exstyle;
	}

private:
	std::string name;
	std::string caption;
	DWORD style;
	DWORD exstyle;

public:
	POINT pos;
	SIZE size;
};

class ChildWindowInfo
	: public WindowInfoBase
{
public:
	int Control;

	ImageControlInfo image;
};
typedef std::vector<ChildWindowInfo *> ChildWindowInfos;

struct WindowType
{
	enum EnumType
	{
		Default = 0,
		ModalDlg = 1,
		ModelessDlg = 3,
	};
};

class WindowInfo
	: public WindowInfoBase
{
public:

	const std::string GetSourceFileName() const
	{
		return this->GetName() + ".ab";
	}

	const std::string GetSourceFileNameForOldVer( const std::string &baseDir ) const
	{
		if( Jenga::Common::Path( baseDir + this->GetName() + ".ab" ).IsExistFile() )
		{
			return this->GetName() + ".ab";
		}
		if( Jenga::Common::Path( baseDir + this->GetName() + ".abp" ).IsExistFile() )
		{
			return this->GetName() + ".abp";
		}
		if( Jenga::Common::Path( baseDir + this->GetName() + ".sbp" ).IsExistFile() )
		{
			return this->GetName() + ".sbp";
		}
		return this->GetName() + ".ab";
	}

	const std::string &GetClassName() const
	{
		return className;
	}
	void SetClassName( const std::string &className )
	{
		this->className = className;
	}

	const std::string GetHandleName() const
	{
		return "h" + this->GetName();
	}

	const std::string GetCallbackName() const
	{
		return this->GetName() + "Proc";
	}

	const std::string &GetMenuIdName() const
	{
		return menuIdName;
	}
	void SetMenuIdName( const std::string &menuIdName )
	{
		this->menuIdName = menuIdName;
	}
	bool HasMenu() const
	{
		return !menuIdName.empty();
	}

	int GetBackgroundColor() const
	{
		return backgroundColor;
	}
	void SetBackgroundColor( int backgroundColor )
	{
		this->backgroundColor = backgroundColor;
	}

	const std::string &GetIconResourceName() const
	{
		return iconResourceName;
	}
	void SetIconResourceName( const std::string &iconResourceName )
	{
		this->iconResourceName = iconResourceName;
	}
	bool HasIcon() const
	{
		return !iconResourceName.empty();
	}

	WindowType::EnumType GetType() const
	{
		return type;
	}
	void SetType( WindowType::EnumType type )
	{
		this->type = type;
	}
	bool IsDefaultWindow() const
	{
		return ( type == WindowType::Default );
	}
	bool IsModalDlg() const
	{
		return ( type == WindowType::ModalDlg );
	}
	bool IsModelessDlg() const
	{
		return ( type == WindowType::ModelessDlg );
	}

	//EBhEf[^
	LOGFONT LogFont;

	//qEBhEǗ
	ChildWindowInfos childWindowInfos;

	//c[
	HTREEITEM hTreeItem;

private:
	std::string className;
	std::string handleName;
	std::string menuIdName;
	int backgroundColor;
	std::string iconResourceName;
	WindowType::EnumType type;
};

class WindowInfos
	: public std::vector<WindowInfo *>
{
public:
	WindowInfos()
	{
	}
	~WindowInfos()
	{
	}

	void Clear()
	{
		WindowInfos &windowInfos = *this;
		BOOST_FOREACH( WindowInfo *pWindowInfo, windowInfos )
		{
			delete pWindowInfo;
		}
		this->clear();
	}
	void Erase( int index )
	{
		WindowInfos::iterator it = this->begin();
		int i = 0;
		while( i < index )
		{
			i ++;
			it ++;
		}
		this->erase( it );
	}
};


}}
