#include "stdafx.h"

void Meta::Clear()
{
	// O
	namespaceScopesCollection.clear();

	// ֐E\bh
	userProcs.Clear();

	// DLL֐
	dllProcs.Clear();

	// NX
	classesImpl.Clear();

	// O[oϐ
	globalVars.Clear();

	// O[o萔
	globalConsts.Clear();

	// O[o萔}N
	globalConstMacros.Clear();

	// blittable^
	blittableTypes.clear();

	// TypeDef
	typeDefs.clear();

	// ֐|C^
	procPointers.Clear();
}

void Meta::StaticLink( Meta &meta, long dataSectionBaseOffset, const std::vector<int> &relationTable )
{
	// O
	foreach (NamespaceScopes const &namespaceScopes, meta.namespaceScopesCollection)
	{
		if( !this->namespaceScopesCollection.IsExist( namespaceScopes ) )
		{
			this->namespaceScopesCollection.push_back( namespaceScopes );
		}
	}

	// ֐E\bh
	foreach (auto pUserProc, meta.GetUserProcs())
	{
		if( pUserProc->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pUserProc->ResetRelationalObjectModuleIndex( relationTable );

		pUserProc->GetNativeCode().ResetDataSectionBaseOffset( dataSectionBaseOffset );

		this->userProcs.Put( pUserProc );
	}
	meta.GetUserProcs().PullOutAll();

	// DLL֐
	foreach (auto pDllProc, meta.GetDllProcs())
	{
		if( pDllProc->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pDllProc->ResetRelationalObjectModuleIndex( relationTable );
		this->dllProcs.Put( pDllProc );
	}
	meta.GetDllProcs().PullOutAll();

	// NX
	foreach (auto pClass, meta.GetClasses())
	{
		if( pClass->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pClass->ResetRelationalObjectModuleIndex( relationTable );
		pClass->Readed();
		this->GetClasses().Put( pClass );
	}
	meta.GetClasses().PullOutAll();

	// O[oϐ
	long initAreaBaseOffset = this->globalVars.initAreaBuffer.GetSize();
	foreach( Variable *pVar, meta.globalVars )
	{
		if( pVar->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		// XR[vx̃O[oϐ̐lIɂ
		if( pVar->GetScopeLevel() == 0 )
		{
			pVar->isLiving = true;
		}

		bool isResetOffsetAddress = true;
		if( pVar->HasInitData() )
		{
			// obt@Ƃ̓f[^e[uItZbgKp
			pVar->SetOffsetAddress( pVar->GetOffsetAddress() + initAreaBaseOffset );

			isResetOffsetAddress = false;
		}

		pVar->ResetRelationalObjectModuleIndex( relationTable );
		this->globalVars.Add( pVar, isResetOffsetAddress );
	}
	meta.globalVars.PullOutAll();
	this->globalVars.initAreaBuffer.Put(
		meta.globalVars.initAreaBuffer.GetBuffer(),
		meta.globalVars.initAreaBuffer.GetSize()
	);

	// O[o萔
	foreach (auto pConst, meta.GetGlobalConsts())
	{
		if( pConst->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pConst->ResetRelationalObjectModuleIndex( relationTable );
		this->GetGlobalConsts().Put( pConst );
	}
	meta.GetGlobalConsts().PullOutAll();

	// O[o萔}N
	foreach (auto pConstMacro, meta.GetGlobalConstMacros())
	{
		if( pConstMacro->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pConstMacro->ResetRelationalObjectModuleIndex( relationTable );
		this->GetGlobalConstMacros().Put( pConstMacro );
	}
	meta.GetGlobalConstMacros().PullOutAll();

	// blittable^
	BOOST_FOREACH( BlittableType &blittableType, meta.blittableTypes )
	{
		// TODO: coreW[ȊOłBlittable^p̃NXW[`ł悤ɂׂ
		this->blittableTypes.push_back( blittableType );
	}
	meta.blittableTypes.clear();

	// TypeDef
	BOOST_FOREACH( TypeDef &typeDef, meta.typeDefs )
	{
		if( typeDef.IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		typeDef.ResetRelationalObjectModuleIndex( relationTable );
		this->typeDefs.push_back( typeDef );
	}
	meta.typeDefs.clear();

	// ֐|C^
	foreach( ProcPointer *pProcPointer, meta.procPointers )
	{
		if( pProcPointer->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pProcPointer->ResetRelationalObjectModuleIndex( relationTable );
		this->procPointers.push_back( pProcPointer );
	}
	meta.procPointers.PullOutAll();

	// fQ[g
	foreach (auto pDelegate, meta.GetDelegates())
	{
		if( pDelegate->IsExternal() )
		{
			// OQƂ̏ꍇ͎荞܂Ȃ
			continue;
		}

		pDelegate->ResetRelationalObjectModuleIndex( relationTable );
		this->GetDelegates().Put( pDelegate );
	}
	meta.GetDelegates().PullOutAll();
}

const ::Delegate &Meta::ToDelegate( const CClass &_class )
{
	auto dg = this->GetDelegates().GetHashArrayElement(_class.GetName());
	foreach (auto t, dg)
	{
		if( t->IsEqualSymbol( _class.GetNamespaceScopes(), _class.GetName() ) ){
			//OԂƃNXv
			return *t;
		}
	}

	throw std::runtime_error("Meta::ToDelegate");
}

const CClass *Meta::FindClassSupportedTypeDef( const Symbol &symbol )
{
	const CClass *pClass = this->GetClasses().FindEx( symbol );
	if( pClass )
	{
		return pClass;
	}

	// TypeDef
	const TypeDef *pTypeDef = this->GetTypeDefs().Find( symbol );
	if( pTypeDef )
	{
		Type type = pTypeDef->GetBaseType();
		if( type.IsObject() )
		{
			return &type.GetClass();
		}
	}

	return NULL;
}

void Meta::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	// ֐E\bh
	foreach (auto pUserProc, this->GetUserProcs())
	{
		pUserProc->Resolve( resolver, resolveErrors );
	}

	// DLL֐
	foreach (auto pDllProc, this->GetDllProcs())
	{
		pDllProc->Resolve( resolver, resolveErrors );
	}

	// NX
	foreach (auto pClass, this->GetClasses())
	{
		pClass->Resolve( resolver, resolveErrors );
	}

	// O[oϐ
	foreach( Variable *pVar, globalVars )
	{
		pVar->Resolve( resolver, resolveErrors );
	}

	// O[o萔
	foreach (auto pConst, this->GetGlobalConsts())
	{
		pConst->Resolve( resolver, resolveErrors );
	}

	// O[o萔}N
	foreach (auto pConstMacro, this->GetGlobalConstMacros())
	{
		pConstMacro->Resolve( resolver, resolveErrors );
	}

	// blittable^
	BOOST_FOREACH( BlittableType &blittableType, blittableTypes )
	{
		blittableType.Resolve( resolver, resolveErrors );
	}

	// TypeDef
	BOOST_FOREACH( TypeDef &typeDef, typeDefs )
	{
		typeDef.Resolve( resolver, resolveErrors );
	}

	// ֐|C^
	foreach( ProcPointer *pProcPointer, procPointers )
	{
		pProcPointer->Resolve( resolver, resolveErrors );
	}

	// fQ[g
	foreach (auto pDelegate, this->GetDelegates())
	{
		pDelegate->Resolve( resolver, resolveErrors );
	}
}
