#include "stdafx.h"
#include <abdev/ab_common/include/ab_common.h>
#include "LexicalAnalyzer.h"
#include "Compiler.h"
#include "StrOperation.h"
#include <boost/algorithm/string/predicate.hpp>

using namespace ActiveBasic::Compiler;

void LexicalAnalyzer::AddTypeDef( TypeDefCollection &typeDefs, const NamespaceScopes &namespaceScopes, const boost::iterator_range<char const*> &expression, int nowLine )
{
	auto name = boost::find<boost::return_begin_found>(expression, '=');

	if (boost::end(name) == boost::end(expression))
	{
		compiler.errorMessenger.Output(10, "TypeDef", nowLine);
		return;
	}

	const char *pTemp = expression.begin() + boost::size(name) + 1;

	//ʕ̃G[`FbNiV^j
	if (!boost::algorithm::all(name, [](char c) {return IsVariableChar(c, true);}))
	{
		compiler.errorMessenger.Output(10, "TypeDef", nowLine);
		return;
	}

	//ʕ̃G[`FbNiRs[̌^j
	if(pTemp[0]=='*'&&pTemp[1]==1&&(pTemp[2]==ESC_FUNCTION||pTemp[2]==ESC_SUB)){
		//֐|C^
		if(pTemp[3]!='('){
			compiler.errorMessenger.Output(10,"TypeDef",nowLine);
			return;
		}
	}
	else
	{
		int i=0;
		while(pTemp[i]=='*') i++;
		if (!boost::algorithm::all(name, [](char c) {return IsVariableChar(c, true);}))
		{
			compiler.errorMessenger.Output(10,"TypeDef",nowLine);
			return;
		}
	}

	std::string baseName(pTemp, expression.end());

	//ʎqdĂꍇ̓G[ɂ
	if (boost::algorithm::equals(name, baseName))
	{
		compiler.errorMessenger.Output(1,NULL,nowLine);
		return;
	}



	//////////////////////////
	// TypeDefǉ
	//////////////////////////

	Type baseType;
	if( !compiler.StringToType( baseName, baseType ) )
	{
		compiler.errorMessenger.Output(3, baseName, nowLine );
		return;
	}

	typeDefs.push_back(
		TypeDef(
			Symbol(namespaceScopes, boost::copy_range<std::string>(name)),
			baseName,
			baseType
		)
	);
}
void LexicalAnalyzer::CollectTypeDefs( const char *source, TypeDefCollection &typeDefs )
{
	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// Imports̃NA
	compiler.GetNamespaceSupporter().ClearImportedNamespaces();

	for (int i = 0; ; ++i)
	{
		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			i+=2;
			char const* p = &source[i];
			while (!IsCommandDelimitation(source[i]))
			{
				++i;
			}
			namespaceScopes.push_back(std::string(p, &source[i]));

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				compiler.errorMessenger.Output(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_IMPORTS ){
			i+=2;
			char const* p = &source[i];
			while (!IsCommandDelimitation(source[i]))
			{
				++i;
			}
			std::string s(p, &source[i]);
			if (!compiler.GetNamespaceSupporter().ImportsNamespace(s))
			{
				compiler.errorMessenger.Output(64, s.c_str(), i);
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_CLEARNAMESPACEIMPORTED )
		{
			// Imports̃NA
			compiler.GetNamespaceSupporter().ClearImportedNamespaces();
			continue;
		}

		if( source[i]==1 ){
			char temporary[VN_SIZE];
			if(source[i+1]==ESC_TYPEDEF){
				i+=2;
				char const* p = &source[i];
				while (!IsCommandDelimitation(source[i]))
				{
					++i;
				}
				AddTypeDef(typeDefs, namespaceScopes, boost::make_iterator_range(p, &source[i]), i);
				continue;
			}
			else if( source[i+1] == ESC_CONST && source[i+2] == 1 && source[i+3] == ESC_ENUM ){
				int i2 = 0;
				for(i+=4;;i2++,i++){
					if(!IsVariableChar(source[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=source[i];
					if(source[i]=='\0') break;
				}

				typeDefs.push_back(
					TypeDef(
						Symbol( namespaceScopes, temporary ),
						"Long",
						Type(DEF_LONG)
					)
				);
			}
		}

		//̍s
		for(;;i++){
			if(IsCommandDelimitation(source[i])) break;
		}
		if(source[i]=='\0') break;
	}
}
