#include "stdafx.h"

#ifndef THETEXT

#include "common.h"
#include <abdev/ab_common/include/Path.h>
#include <abdev/ab_common/include/ProcessAndModule.h>
#include <psapi.h>
#include <tlhelp32.h>

#pragma comment(lib, "psapi.lib")

using namespace ActiveBasic::IDE;

HRESULT ApplyDialogTexture( HWND );


int GetSelectingProcessId(HWND hListView,DWORD *lpdwPlatform){
	int nCount;
	nCount=ListView_GetItemCount(hListView);

	char temporary[255];
	DWORD dwProcessId;
	int i;
	for(i=0;i<nCount;i++){
		if(ListView_GetItemState(hListView,i,LVIS_SELECTED)){
			ListView_GetItemText(hListView,i,1,temporary,255);
			dwProcessId=atoi(temporary);

			ListView_GetItemText(hListView,i,2,temporary,255);
			if(lstrcmpi(temporary,"Win32")==0) *lpdwPlatform=IMAGE_FILE_MACHINE_I386;
			else if(lstrcmpi(temporary,"Win64")==0) *lpdwPlatform=IMAGE_FILE_MACHINE_AMD64;
			break;
		}
	}
	if(i==nCount) return 0;

	return dwProcessId;
}

void InsertProcess_ToListView(HWND hListView,char const* lpszAppPath,int id,char const* lpszPlatform,char const * lpszTitle){
	char szAppName[MAX_PATH],temp2[MAX_PATH];
	_splitpath(lpszAppPath,NULL,NULL,szAppName,temp2);
	lstrcat(szAppName,temp2);

	//C[WXg擾
	HIMAGELIST hImageList;
	hImageList=ListView_GetImageList(hListView,LVSIL_SMALL );

	//ACR擾
	int iImage;
	SHFILEINFO shfi;
	SHGetFileInfo(lpszAppPath, FILE_ATTRIBUTE_ARCHIVE, &shfi, sizeof(SHFILEINFO), SHGFI_ICON | SHGFI_SMALLICON );
	if(shfi.hIcon){
		iImage=ImageList_AddIcon(hImageList,shfi.hIcon);
		DestroyIcon(shfi.hIcon);
	}
	else iImage=-1;

	char szId[255];
	sprintf(szId,"%d",id);

	//Xgr[ɒǉ
	LV_ITEM item;
	if(iImage==-1) item.mask=LVIF_TEXT;
	else item.mask=LVIF_TEXT|LVIF_IMAGE;
	item.iItem=0;

	item.pszText=szAppName;
	item.iSubItem=0;
	item.iImage=iImage;
	ListView_InsertItem(hListView,&item);

	item.mask=LVIF_TEXT ;
	item.pszText=szId;
	item.iSubItem++;
	ListView_SetItem(hListView,&item);

	item.pszText=const_cast<LPSTR>(lpszPlatform);
	item.iSubItem++;
	ListView_SetItem(hListView,&item);

	item.pszText=const_cast<LPSTR>(lpszTitle);
	item.iSubItem++;
	ListView_SetItem(hListView,&item);
}

void ListupProcesses64(HWND hListView)
{
	ListView_DeleteAllItems(hListView);


	/////////////////////////////////////////////////////
	// 64rbgŃvZX񋓃W[Ăяo
	/////////////////////////////////////////////////////

	std::string enumProcess64ExePath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\enum_process64\\enum_process64.exe";

	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	memset(&si,0,sizeof(STARTUPINFO));
	si.cb=sizeof(STARTUPINFO);
	CreateProcess(NULL,const_cast<char *>(enumProcess64ExePath.c_str()),NULL,NULL,0,NORMAL_PRIORITY_CLASS,NULL,NULL,&si,&pi);

	WaitForSingleObject(pi.hProcess,INFINITE);


	//////////////////////////////////
	// ꂽt@C̓ǂݍ
	//////////////////////////////////

	std::string listPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\enum_process64\\list.dat";

	char *buffer;
	buffer=ReadBuffer_NonErrMsg( listPath );
	if(!buffer) return;

	int i=0;
	char temporary[MAX_PATH];
	while(1){
		//t@CpX
		char szAppPath[MAX_PATH];
		i=GetOneParameter(buffer,i,szAppPath);
		if(szAppPath[0]=='\0') break;
		RemoveStringQuotes(szAppPath);

		//vZXID
		DWORD dwProcessId;
		i=GetOneParameter(buffer,i,temporary);
		if(temporary[0]=='\0') break;
		dwProcessId=(DWORD)atoi(temporary);

		//vbgtH[
		char szPlatform[255];
		i=GetOneParameter(buffer,i,szPlatform);
		if(temporary[0]=='\0') break;

		//^Cg
		char szTitle[255];
		int i2;
		for(i2=0;;i++,i2++){
			if(IS_RETURN(buffer,i)||buffer[i]=='\0'){
				szTitle[i2]=0;
				break;
			}
			szTitle[i2]=buffer[i];
		}


		//Xgr[֒ǉ
		InsertProcess_ToListView(hListView,szAppPath,dwProcessId,szPlatform,szTitle);

		if(buffer[i]=='\r'&&buffer[i+1]=='\n') i+=2;
		if(buffer[i]=='\0') break;
	}

	HeapDefaultFree(buffer);
}

// EnumWindowsProcR[obN֐
BOOL CALLBACK FindWindowProc(HWND hwnd, LPARAM lParam)
{
	auto pProcessIdAndHWnd = reinterpret_cast<std::pair<DWORD, HWND>*>(lParam);
	DWORD processId = 0;
	::GetWindowThreadProcessId(hwnd, &processId);
	if (processId == pProcessIdAndHWnd->first)
	{
		pProcessIdAndHWnd->second = hwnd;
		return FALSE;
	}
	else
	{
		return TRUE;
	}
}
void ListupProcesses(HWND hListView){
	ListView_DeleteAllItems(hListView);

	//vZX
	auto processIds = ActiveBasic::Common::GetProcesses();

	char szMyAppPath[MAX_PATH] = {};
	GetModuleFileName(nullptr, szMyAppPath, MAX_PATH);

	BOOST_FOREACH(DWORD processId, processIds)
	{
		//̃vZXɂsW[̃CX^Xnh擾
		auto executablePath = ActiveBasic::Common::GetExecutableModulePath(processId);

		//////////////////////////////
		// EBhE^Cg擾
		//////////////////////////////

		std::pair<DWORD, HWND> processIdAndHWnd(processId, nullptr);
		EnumWindows(FindWindowProc, reinterpret_cast<LPARAM>(&processIdAndHWnd));
		HWND hwnd = processIdAndHWnd.second;

		TCHAR szWndTitle[1024] = {};
		if(hwnd) GetWindowText(hwnd, szWndTitle, 1024);

		if (ActiveBasic::Common::IsPathEqual(Jenga::Common::ToWString(szMyAppPath).c_str(), executablePath.wstring().c_str()))
		{
			//giProjectEditor.exej͖
			continue;
		}

		//Xgr[֒ǉ
		InsertProcess_ToListView(hListView,executablePath.string().c_str(),processId,"Win32",szWndTitle);
	}
}

INT_PTR CALLBACK DlgAttach(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	static HWND hListView;
	static HIMAGELIST hImageList;
	static DWORD *lpdwPlatform;
	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);

			lpdwPlatform=(DWORD *)lParam;

			hListView=GetDlgItem(hwnd,IDC_PROCESSLIST);

			//gX^C
			DWORD dwStyle;
			dwStyle=ListView_GetExtendedListViewStyle(hListView);
			dwStyle|=LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES;
			ListView_SetExtendedListViewStyle(hListView,dwStyle);


			//C[WXg̐Ɛݒ
			hImageList=ImageList_Create(16,16,ILC_COLOR24|ILC_MASK,0,0);
			ListView_SetImageList(hListView,hImageList,LVSIL_SMALL );


			///////////////////////////
			// JZbg
			///////////////////////////

			LV_COLUMN ListView_Column;
			ListView_Column.mask=LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
			ListView_Column.fmt=LVCFMT_LEFT;

			ListView_Column.cx=150;
			ListView_Column.pszText="vZX";
			ListView_Column.iSubItem=0;
			ListView_InsertColumn(hListView,ListView_Column.iSubItem,&ListView_Column);

			ListView_Column.cx=70;
			ListView_Column.pszText="ID";
			ListView_Column.iSubItem++;
			ListView_InsertColumn(hListView,ListView_Column.iSubItem,&ListView_Column);

			ListView_Column.cx=50;
			ListView_Column.pszText="";
			ListView_Column.iSubItem++;
			ListView_InsertColumn(hListView,ListView_Column.iSubItem,&ListView_Column);

			ListView_Column.cx=200;
			ListView_Column.pszText="^Cg";
			ListView_Column.iSubItem++;
			ListView_InsertColumn(hListView,ListView_Column.iSubItem,&ListView_Column);


			//Xr[XV
			if(IsWow64()) ListupProcesses64(hListView);
			else ListupProcesses(hListView);

			ApplyDialogTexture(hwnd);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					EndDialog(hwnd,GetSelectingProcessId(hListView,lpdwPlatform));
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			return 0;

		case WM_NOTIFY:
			NMLISTVIEW *nmListView;
			nmListView=(NMLISTVIEW *)lParam;
			if(nmListView->hdr.hwndFrom==hListView){
				if(nmListView->hdr.code==NM_DBLCLK){
					if(nmListView->iItem==-1) return 1;
					SendMessage(hwnd,WM_COMMAND,IDOK,0);
					return 1;
				}
			}
			break;

		case WM_DESTROY:
			ImageList_Destroy(hImageList);
			return 1;
	}
	return 0;
}


#endif //THETEXT
