#pragma once

class Parameter : public Type
{
	std::string varName;
	bool isRef;
	bool isArray;
	Subscripts subscripts;

	std::string initValue;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Parameter" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Type );
		ar & BOOST_SERIALIZATION_NVP( varName );
		ar & BOOST_SERIALIZATION_NVP( isRef );
		ar & BOOST_SERIALIZATION_NVP( isArray );
		ar & BOOST_SERIALIZATION_NVP( subscripts );
		ar & BOOST_SERIALIZATION_NVP( initValue );
	}

public:
	Parameter( const std::string &varName, const Type &type, bool isRef = false, const std::string initValue = "" );
	Parameter( const Parameter &param, const Type &type );
	Parameter( const Parameter &param );
	Parameter(Parameter&& param)
		: varName(std::move(param.varName))
		, isRef(std::move(param.isRef))
		, isArray(std::move(param.isArray))
		, subscripts(std::move(param.subscripts))
		, initValue(std::move(param.initValue)) {}
	Parameter();
	~Parameter();

	Parameter& operator =(Parameter&& y)
	{
		varName = std::move(y.varName);
		isRef = std::move(y.isRef);
		isArray = std::move(y.isArray);
		subscripts = std::move(y.subscripts);
		initValue = std::move(y.initValue);
		return *this;
	}

	Parameter& operator =(Parameter const& y)
	{
		return *this = std::move(Parameter(y));
	}
	
	void SetArray( const Subscripts &subscripts ){
		isArray = true;
		this->subscripts = subscripts;
	}

	const std::string &GetVarName() const
	{
		return varName;
	}

	bool IsRef() const
	{
		return isRef;
	}
	bool IsArray() const
	{
		return isArray;
	}
	const Subscripts &GetSubscripts() const
	{
		return subscripts;
	}

	const std::string &GetInitValue() const
	{
		return initValue;
	}

	bool Equals( const Parameter &param, bool isContravariant ) const;
	bool Equals( const Types &actualTypeParametersForThisProc, const Parameter &param, bool isContravariant ) const;
};

class Parameters : public std::vector<Parameter *>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Parameters" );

		ar & boost::serialization::make_nvp("vector_Parameter", boost::serialization::base_object<std::vector<Parameter *>>(*this));
	}

public:
	Parameters() : std::vector<Parameter *>() {}
	Parameters(Parameters&& y) : std::vector<Parameter *>(std::move(y)) {}
	Parameters(Parameters const& y) : std::vector<Parameter *>(y) {}

	Parameters& operator =(Parameters&& y)
	{
		std::vector<Parameter *>::operator =(std::move(y));
		return *this;
	}

	Parameters& operator =(Parameters const& y)
	{
		return *this = std::move(Parameters(y));
	}

	bool Equals( const Parameters &params, bool isContravariant = false ) const;
	bool Equals( const Types &actualTypeParametersForThisProc, const Parameters &params, bool isContravariant = false ) const;

	int GetMemorySize() const
	{
		return (int)this->size() * PTR_SIZE;
	}
};
