#pragma once

class Configuration
	: public Jenga::Common::BoostSerializationSupport<Configuration>
{
	std::string abdevRootRelativePath;

public:
	Configuration()
	{
	}

	const std::string &GetAbdevRootRelativePath() const
	{
		return abdevRootRelativePath;
	}

	// XMLVACYp
private:
	virtual const char *RootTagName() const
	{
		return "configuration";
	}
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_NVP( abdevRootRelativePath );
	}

	Configuration(Configuration const&);
	Configuration& operator =(Configuration const&);
};
