#include "stdafx.h"

#ifdef _AMD64_
#include "../compiler_x64/opcode.h"
#else
#include "../compiler_x86/opcode.h"
#endif

#define OVERLOAD_MIN_LEVEL 0
#define OVERLOAD_MAX_LEVEL 6
#define OVERLOAD_LEVEL0 0		// ^ȂBɓ
#define OVERLOAD_LEVEL1 1		// ^ȂBx1ȏ̓IuWFNg̏ꍇ͔h֌Wl
#define OVERLOAD_LEVEL2 2		// ^ȂB^/^xł̓ꐫ`FbNiTCYƍj
#define OVERLOAD_LEVEL3 3		// ^ȂB^/^xł̓ꐫ`FbN
#define OVERLOAD_LEVEL4 4		// ^Bɓ
#define OVERLOAD_LEVEL5 5		// ^B^/^xł̓ꐫ`FbN
#define OVERLOAD_LEVEL6 6		// ^Bl^/NX^xł̓ꐫ`FbN

ParamImpl::ParamImpl(const char *buffer):
	returnType()
{
	///////////////////////////
	// p[^𐮗
	///////////////////////////

	extern HANDLE hHeap;
	int i,i2,i3;
	char temporary[VN_SIZE];

	i=0;
	ParmsNum=0;
	while(1){
		if(buffer[i]=='\0') break;

		for(i2=0;;i2++,i++){
			if(buffer[i]=='\"'){
				temporary[i2]=buffer[i];
				for(i++,i2++;;i++,i2++){
					temporary[i2]=buffer[i];
					if( buffer[i] == '\0' )
					{
						compiler.errorMessenger.OutputFatalError();
						break;
					}
					if(buffer[i]=='\"') break;
				}
				continue;
			}

			if(buffer[i]=='('){
				i3=GetStringInPare(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(buffer[i]=='['){
				i3=GetStringInBracket(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}

			if(buffer[i]==','||buffer[i]=='\0'){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}

		Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
		lstrcpy(Parms[ParmsNum],temporary);
		ParmsNum++;

		types.push_back( Type() );

		if(buffer[i]==',') i++;
	}
}
ParamImpl::ParamImpl(const Parameters &params):
	returnType()
{
	ParmsNum = 0;
	foreach( Parameter *pParam, params ){
		Parms[ParmsNum]=0;
		ParmsNum++;

		types.push_back( *pParam );
	}
}
ParamImpl::~ParamImpl(){
	int i2;

	//p[^
	for(i2=0;i2<ParmsNum;i2++){
		if(Parms[i2]==(char *)-1) continue;

		if(Parms[i2]) HeapDefaultFree(Parms[i2]);
	}
}

void ParamImpl::SetReturnType( const Type &returnType ){
	this->returnType = returnType;
}

bool ParamImpl::EvaluateOverloadScore( int level, const Parameters &targetParms, const Type &targetResultType, const Type &leftType, const UserProc &userProc, bool &isErrored ){
	//p[^ʂăI[o[[h

	isErrored = false;

	//p[^̌sv̏ꍇ
	int max = (int)targetParms.size();

	if( ParmsNum > max ){
		// 葽Ƃ
		// ŕsv
		return false;
	}

	Type argType;
	for(int i=0;i<max;i++){
		Parameter &param = *targetParms[i];

		Type paramType( param );
		ResolveFormalGenericTypeParameter( paramType, leftType, &userProc );

		if( i >= ParmsNum ){
			// Ƃ
			if( param.GetInitValue().size() > 0 ){
				// lw肳Ăp[^l
				return true;
			}
			else{
				return false;
			}
		}

		if(Parms[i]){
			Type nullParam( DEF_NON );

			if( !NumOpe_GetType(Parms[i],
				( level <= OVERLOAD_LEVEL3 )? nullParam : paramType,
				argType) )
			{
				isErrored = true;
				return false;
			}
		}
		else{
			argType = types[i];
		}

		if( ( argType.IsObject() && paramType.IsObject() ) || argType.GetBasicType() == paramType.GetBasicType() )
		{
			if( argType.IsStruct() ){
				if(argType.GetIndex()!=paramType.GetIndex()){
					return false;
				}
			}
			else if( argType.IsObject() ){
				if( level == OVERLOAD_LEVEL0 ){
					if( !paramType.GetClass().IsEquals( &argType.GetClass() ) ){
						return false;
					}
				}
				else{
					if( !paramType.GetClass().IsEqualsOrSubClass( &argType.GetClass() ) ){
						return false;
					}
				}
			}
		}
		else
		{
			if( level == OVERLOAD_LEVEL0 || level == OVERLOAD_LEVEL1 || level==OVERLOAD_LEVEL4 ){
				return false;
			}
			else if( level == OVERLOAD_LEVEL2 ){
				if( !(argType.IsWhole() && paramType.IsWhole() && argType.GetBasicSize() == paramType.GetBasicSize() ) ){
					// TCYႢ
					return false;
				}
			}
			else if( level == OVERLOAD_LEVEL3 || level==OVERLOAD_LEVEL5){
				if(!(
					argType.IsWhole()&&paramType.IsWhole()||
					argType.IsReal()&&paramType.IsReal()
					)){
						return false;
				}
				if( argType.IsPointer() || paramType.IsPointer() )
				{
					// |C^^̕s͔F߂Ȃ
					return false;
				}
			}
			else if(level==OVERLOAD_LEVEL6){
				if(argType.IsObject()||paramType.IsObject()) return false;
			}
		}
	}

	if( !targetResultType.IsNull() ){
		//߂lrΏۂɂ

		Type temp( targetResultType );
		ResolveFormalGenericTypeParameter( temp, leftType, &userProc );

		if( !returnType.Equals( temp ) ){
			return false;
		}
	}

	return true;
}

const UserProc *ParamImpl::_OverloadSolution( const char *name, std::vector<const UserProc *> &subs, const Type &leftType, bool isEnabledReturnType ){
	const UserProc *pUserProc = NULL;

	for( int level=OVERLOAD_MIN_LEVEL; level<=OVERLOAD_MAX_LEVEL; level++ )
	{
		foreach( const UserProc *pTempUserProc, subs )
		{
			bool isErrored = false;
			bool isHit = false;
			isHit = EvaluateOverloadScore( level, pTempUserProc->Params(), isEnabledReturnType?pTempUserProc->ReturnType():Type(), leftType, *pTempUserProc, isErrored );
			if( isErrored )
			{
				// ƍɃG[Nꍇ
				return NULL;
			}

			if( isHit )
			{
				trace_for_overload( "x" << level << " K..." << pTempUserProc->_paramStr );

				if( pUserProc ){
					if( isEnabledReturnType ){
						compiler.errorMessenger.Output(52,name,cp);
						return NULL;
					}
					else{
						// ߂lr郂[hɂčĂуI[o[[h݂

						trace_for_overload( "߂lr郂[hɐ؂ւăI[o[[h݂" );

						return OverloadSolution( name, subs, leftType, true);
					}
				}

				pUserProc = pTempUserProc;
			}
			else
			{
				trace_for_overload( "x" << level << " ~sK..." << pTempUserProc->_paramStr );
			}
		}

		if( pUserProc ) break;
	}

	if( !pUserProc ){
		foreach( const UserProc *pTempUserProc, subs )
		{
			//G[`FbN
			if(pTempUserProc->Params().size()==this->ParmsNum)
			{
				if( pUserProc )
				{
					compiler.errorMessenger.Output(52,name,cp);
					return NULL;
				}

				pUserProc=pTempUserProc;
			}
		}
	}

	if( !pUserProc )
	{
		compiler.errorMessenger.OutputFatalError();
	}

	return pUserProc;
}
const UserProc *ParamImpl::OverloadSolution( const char *name, std::vector<const UserProc *> &subs, const Type &leftType, bool isEnabledReturnType ){
	trace_for_overload( "" );
	trace_for_overload( "" );
	trace_for_overload( " I[o[[h(" << name << ")" );

	const UserProc *result = _OverloadSolution( name, subs, leftType, isEnabledReturnType );

	trace_for_overload( " ܂" );
	trace_for_overload( "" );
	trace_for_overload( "" );

	return result;
}

void ParamImpl::ApplyDefaultParameters( const Parameters &params ){
	if( ParmsNum == (int)params.size() ){
		// ftHg̓KpsKvȂƂ
		return;
	}

	while( ParmsNum < (int)params.size() ){
		Parameter &param = *params[ParmsNum];

		Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,param.GetInitValue().size() + 1 );
		lstrcpy(Parms[ParmsNum],param.GetInitValue().c_str() );
		ParmsNum++;

		types.push_back( Type() );
	}
}

bool ParamImpl::ErrorCheck( const std::string &procName, const Parameters &params, int SecondParmNum ){
	if( SecondParmNum == -1 ) SecondParmNum = (int)params.size();

	if(ParmsNum>(int)params.size()){
		if( params.size() == 0 || params[params.size()-1]->GetBasicType()!=DEF_ELLIPSE ){
			//p[^Ƃ
			compiler.errorMessenger.Output(10,procName,cp);
			return false;
		}
	}
	else if(ParmsNum<(int)params.size()){
		if(ParmsNum<SecondParmNum){
			if(params[ParmsNum]->GetBasicType()==DEF_ELLIPSE){
				return true;
			}

			//p[^ȂƂ
			compiler.errorMessenger.Output(10,procName,cp);
			return false;
		}

		//ȗp[^ "0" w肷
		while( ParmsNum < (int)params.size() )
		{
			extern HANDLE hHeap;
			char temporary[64];
			if(params[ParmsNum]->IsRef() == false) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[ParmsNum],temporary);

			ParmsNum++;

			types.push_back( Type() );
		}
	}

	return true;
}

void ParamImpl::MacroParameterSupport( const Parameters &params ){
	for(int i=0;i<ParmsNum;i++){
		if(Parms[i][0]=='\0'){
			extern HANDLE hHeap;
			char temporary[64];
			if( params[i]->IsRef() == false ) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			HeapDefaultFree(Parms[i]);
			Parms[i]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[i],temporary);
		}
	}
}
