#include "stdafx.h"

#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../compiler_x64/opcode.h"
#else
#include "../compiler_x86/opcode.h"
#endif


void Diagnose(){
	char temporary[8192];

	{
		///////////////////////////////////////////////////////////////////
		// O[o / [J R[ḧ̃TCY𒲂ׂ
		///////////////////////////////////////////////////////////////////

		extern int GlobalOpBufferSize;
		sprintf(temporary, "%d", GlobalOpBufferSize/1024 );
		trace_for_size( (std::string)"O[ö̃R[hTCY: " + temporary + "KB" );
		//sprintf(temporary, "%d", (obp-GlobalOpBufferSize)/1024 );
		//trace_for_size( (std::string)"[J̈̃R[hTCY: " + temporary + "KB" );
		//sprintf(temporary, "%d", obp/1024 );
		//trace_for_size( (std::string)"R[hTCY: " + temporary + "KB" );
	}

	{
		///////////////////////////////////////////////////////////////////
		// O[o֐ANX\bh̃TCY𒲂ׂ
		///////////////////////////////////////////////////////////////////

		int codeSizeOfGlobalProc = 0;
		int codeSizeOfClassMethod = 0;
		foreach (auto pUserProc, compiler.GetObjectModule().meta.GetUserProcs())
		{
			if( pUserProc->IsCompiled() ){
				if( pUserProc->HasParentClass() ){
					codeSizeOfClassMethod += pUserProc->GetCodeSize();
				}
				else{
					codeSizeOfGlobalProc += pUserProc->GetCodeSize();
				}
			}
		}

		sprintf(temporary, "%d", codeSizeOfGlobalProc/1024 );
		trace_for_size( (std::string)"O[o֐̃R[hTCY: " + temporary + "KB" );
		sprintf(temporary, "%d", codeSizeOfClassMethod/1024 );
		trace_for_size( (std::string)"NX\bh̃R[hTCY: " + temporary + "KB" );
	}

	{
		///////////////////////////////////////////////////////////////////
		// EnumɕKvȂ̃R[hTCY𒲂ׂ
		///////////////////////////////////////////////////////////////////
		int codeSizeOfEnum = 0;

		foreach (auto pClass, compiler.GetObjectModule().meta.GetClasses())
		{
			int codeSizeOfClass = 0;

			CClass &objClass = *pClass;

			if( !objClass.IsEnum() ){
				// 񋓌^ȊO͖
				continue;
			}

			// I\bh
			foreach( const CMethod *pMethod, objClass.GetDynamicMethods() ){
				if( pMethod->GetUserProc().IsCompiled() ){
					codeSizeOfClass += pMethod->GetUserProc().GetCodeSize();
				}
			}

			// ÓI\bh
			foreach( const CMethod *pMethod, objClass.GetStaticMethods() ){
				codeSizeOfClass += pMethod->GetUserProc().GetCodeSize();
			}

			codeSizeOfEnum += codeSizeOfClass;
		}

		sprintf(temporary, "%d", codeSizeOfEnum/1024 );
		trace_for_size( (std::string)"Enum̃R[hTCY: " + temporary + "KB" );
	}

	trace_for_size( "\n\n" );

	{
		///////////////////////////////////////////////////////////////////
		// NX̃TCY𒲂ׂ
		///////////////////////////////////////////////////////////////////

		foreach (auto pClass, compiler.GetObjectModule().meta.GetClasses())
		{
			int codeSizeOfClass = 0;

			CClass &objClass = *pClass;

			// I\bh
			foreach( const CMethod *pMethod, objClass.GetDynamicMethods() ){
				if( pMethod->GetUserProc().IsCompiled() ){
					codeSizeOfClass += pMethod->GetUserProc().GetCodeSize();
				}
			}

			// ÓI\bh
			foreach( const CMethod *pMethod, objClass.GetStaticMethods() ){
				codeSizeOfClass += pMethod->GetUserProc().GetCodeSize();
			}

			if( codeSizeOfClass )
			{
				sprintf(temporary,
					"------------------------------------------------------------------\n"
					"y %s NX̃R[hz\n"
					"class code size: %d bytes\n"
					"------------------------------------------------------------------\n"
					"\n",
					objClass.GetName().c_str(), codeSizeOfClass);
				trace_for_size( temporary );
			}
		}
	}
}
