#include "stdafx.h"

#include "Common.h"

struct ItemInfo
{
	HWND hwndChild;
	COLORREF Color;

	ItemInfo( HWND hChild, COLORREF color) :
		hwndChild( hChild ),
		Color( color )
	{
	}
};

ItemInfo* GetItemInfo( HWND hTab, int i )
{
	TC_ITEM tcItem;
	tcItem.mask=TCIF_PARAM;
	TabCtrl_GetItem( hTab, i, &tcItem );
	return reinterpret_cast<ItemInfo*>( tcItem.lParam );
}

void SetTabOrder( HWND hTab, ItemInfo* itemInfo, int pos )
{
	HWND next =
		pos + 1 < TabCtrl_GetItemCount( hTab )
		? GetItemInfo( hTab, pos + 1 )->hwndChild
		: 0
		;
	ActiveBasic::IDE::Program::mainFrame.SetTabOrder( itemInfo->hwndChild, next );
}

CMainTab *pobj_MainTab=0;
WNDPROC OldMainTabWndProc;


LRESULT CALLBACK MainTabWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	static BOOL indexDrag=-1;
	TCHITTESTINFO tcHitTest;
	int iNewPos;
	char temporary[MAX_PATH];
	switch(message){
		case WM_LBUTTONDOWN:
			//NbNꂽACeCfbNX擾
			GetCursorPos(&tcHitTest.pt);
			ScreenToClient(pobj_MainTab->hTab,&tcHitTest.pt);
			indexDrag=TabCtrl_HitTest(pobj_MainTab->hTab,&tcHitTest);
			if(indexDrag==-1) break;

			SetCapture(hwnd);
			break;
		case WM_LBUTTONUP:
			indexDrag=-1;
			ReleaseCapture();
			break;
		case WM_MOUSEMOVE:
			if(indexDrag!=-1){
				GetCursorPos(&tcHitTest.pt);
				ScreenToClient(pobj_MainTab->hTab,&tcHitTest.pt);
				iNewPos=TabCtrl_HitTest(pobj_MainTab->hTab,&tcHitTest);
				if(iNewPos==-1) break;
				if(indexDrag!=iNewPos){
					LockWindowUpdate(hOwner);

					TC_ITEM tcItem;
					tcItem.mask=TCIF_TEXT|TCIF_PARAM;
					tcItem.pszText=temporary;
					tcItem.cchTextMax=MAX_PATH;
					TabCtrl_GetItem(pobj_MainTab->hTab,indexDrag,&tcItem);

					TabCtrl_DeleteItem(pobj_MainTab->hTab,indexDrag);

					TabCtrl_InsertItem(pobj_MainTab->hTab,iNewPos,&tcItem);

					int iTemp;
					iTemp=TabCtrl_HitTest(pobj_MainTab->hTab,&tcHitTest);
					if(iTemp!=iNewPos){
						TabCtrl_DeleteItem(pobj_MainTab->hTab,iNewPos);
						TabCtrl_InsertItem(pobj_MainTab->hTab,indexDrag,&tcItem);

						LockWindowUpdate(0);
						break;
					}

					indexDrag=iNewPos;
					SetTabOrder( hwnd, GetItemInfo( hwnd, iNewPos ), iNewPos );

					LockWindowUpdate(0);
				}
			}
			return 0;
		case WM_PAINT:
			HDC hdc;
			PAINTSTRUCT ps;
			hdc=BeginPaint(hwnd,&ps);
			if(pobj_MainTab)
				pobj_MainTab->draw(hdc);
			EndPaint(hwnd,&ps);
			return 0;
	}
	return CallWindowProc(OldMainTabWndProc,hwnd,message,wParam,lParam);
}


int CMainTab::SearchItemIndex( const char *lpszText ){
	int i2,i3;
	char temporary[MAX_PATH];

	i3=TabCtrl_GetItemCount(hTab);

	TC_ITEM tcItem;
	tcItem.mask=TCIF_TEXT;
	tcItem.pszText=temporary;
	tcItem.cchTextMax=MAX_PATH;

	for(i2=0;i2<i3;i2++){
		TabCtrl_GetItem(hTab,i2,&tcItem);

		//AX^XN菜ĕ]
		if( tcItem.pszText[ lstrlen( tcItem.pszText ) -1 ] == '*' ){
			tcItem.pszText[ lstrlen( tcItem.pszText ) -1 ] = 0;
		}

		if(lstrcmpi(lpszText,tcItem.pszText)==0) break;
	}
	if(i2==i3) return -1;

	return i2;
}
void CMainTab::SetItemText( int index, const char *ItemText ){
	TC_ITEM tcItem;
	tcItem.mask=TCIF_TEXT;
	tcItem.pszText=(LPSTR)ItemText;
	tcItem.cchTextMax=MAX_PATH;

	TabCtrl_SetItem(hTab,index,&tcItem);
}
void CMainTab::GetItemText( int index, char *ItemText ){
	TC_ITEM tcItem;
	tcItem.mask = TCIF_TEXT;
	tcItem.pszText = ItemText;
	tcItem.cchTextMax = MAX_PATH;
	TabCtrl_GetItem( hTab, index, &tcItem );
}
bool CMainTab::IsModified( int index ){
	//AX^XN\ǂ𔻒f

	//ACe擾
	char ItemText[MAX_PATH];
	GetItemText( index, ItemText );

	if( ItemText[ lstrlen( ItemText ) -1 ] == '*' ){
		//AX^XNƂ
		return true;
	}

	//̑
	return false;
}


CMainTab::CMainTab(HWND hParent){
	extern HFONT hStatusFont;
	hTab=CreateWindowEx(0,WC_TABCONTROL,NULL,
		WS_CHILD|WS_CLIPCHILDREN|WS_CLIPSIBLINGS|WS_VISIBLE|TCS_OWNERDRAWFIXED,
		0,0,0,0,
		hParent,0,hInst,0);

	TabCtrl_SetPadding(hTab,5,4);

	DWORD dwStyle;
    dwStyle = TabCtrl_GetExtendedStyle(hTab);
    dwStyle &= ~TCS_EX_FLATSEPARATORS;
    TabCtrl_SetExtendedStyle(hTab, dwStyle);


	//TuNX
	OldMainTabWndProc = (WNDPROC)SetWindowLongPtr(hTab,GWLP_WNDPROC,(LONG_PTR)MainTabWndProc);

	//{[h̃tHg𐶐
	LOGFONT lf;
	GetObject(hStatusFont,sizeof(LOGFONT),&lf);
	lf.lfWeight=FW_BOLD;
	hBoldFont=CreateFontIndirect(&lf);

	SetWindowFont(hTab,hBoldFont,FALSE);
}

CMainTab::~CMainTab(){
	DeleteObject(hBoldFont);
}

void CMainTab::InsertItem( HWND hwnd, const char *lpszText, bool isResize, COLORREF color ){
	int sw=0;
	if(TabCtrl_GetItemCount(hTab)==0) sw=1;
OutputDebugString("CMainTab::InsertItem--------------------------------------------------------\r\n");
	if(color==-1) color=RGB(230,230,230);

	ItemInfo* itemInfo = new ItemInfo( hwnd, color );

	TC_ITEM tcItem;
	tcItem.mask=TCIF_TEXT|TCIF_PARAM;
	tcItem.pszText=(LPSTR)lpszText;
	tcItem.lParam=reinterpret_cast<LPARAM>( itemInfo );
	TabCtrl_InsertItem(hTab,0,&tcItem);
	TabCtrl_SetCurSel(hTab,0);
	ActiveBasic::IDE::Program::mainFrame.AddChildWindow( hwnd );
	SetTabOrder( hTab, itemInfo, 0 );

	if(isResize){
		if(sw) ActiveBasic::IDE::Program::mainFrame.Resized();
	}
}

void CMainTab::DeleteItem( const char *lpszText, bool isResize ){
	int i2;
	i2=SearchItemIndex(lpszText);
	if(i2==-1) return;
OutputDebugString("CMainTab::DeleteItem--------------------------------------------------------\r\n");
	ItemInfo* p = GetItemInfo( hTab, i2 );
	ActiveBasic::IDE::Program::mainFrame.DeleteChildWindow( p->hwndChild );
	delete p;
	TabCtrl_DeleteItem(hTab,i2);

	if(isResize){
		if(TabCtrl_GetItemCount(hTab)==0) ActiveBasic::IDE::Program::mainFrame.Resized();
	}
}

void CMainTab::RenameItem( const char *lpszOldText, const char *lpszNewText ){
	int i2=SearchItemIndex(lpszOldText);
	if(i2==-1) return;

	SetItemText( i2, lpszNewText );
}

void CMainTab::NofityModifyDocument( const char *ItemText ){
	//hLgύXꂽƂAAX^XNtĕ\

	//CfbNX擾
	int index = SearchItemIndex( ItemText );
	if( index == -1 ) return;

	//ɃAX^XN\Ăꍇ͔
	if( IsModified( index ) ) return;

	//AX^XNt
	char temporary[MAX_PATH];
	lstrcpy( temporary, ItemText );
	lstrcat( temporary, "*" );

	//^uACeXV
	SetItemText( index, temporary );
}
void CMainTab::NofityUnModifyDocument( const char *ItemText ){
	//hLgۑꂽƂAAX^XN\ɂ

	//CfbNX擾
	int index = SearchItemIndex( ItemText );
	if( index == -1 ) return;

	//ɃAX^XN\̏ꍇ͔
	if( ! IsModified( index ) ) return;

	//^uACeXV
	SetItemText( index, ItemText );
}

COLORREF CMainTab::GetItemColor( char const *ItemText ){
	//CfbNX擾
	int index = SearchItemIndex( ItemText );
	if( index == -1 ) return static_cast<COLORREF>(-1);

	TC_ITEM tcItem;
	tcItem.mask = TCIF_PARAM;
	TabCtrl_GetItem( hTab, index, &tcItem );
	return reinterpret_cast<ItemInfo*>( tcItem.lParam )->Color;
}

void CMainTab::SelChangeEvent(){
	int i;
	i=TabCtrl_GetCurSel(hTab);

	char ItemText[MAX_PATH];
	TC_ITEM tcItem;
	tcItem.mask=TCIF_TEXT;
	tcItem.pszText=ItemText;
	tcItem.cchTextMax=MAX_PATH;
	TabCtrl_GetItem(hTab,i,&tcItem);

	if( ItemText[ lstrlen( ItemText ) -1 ] == '*' ){
		//AX^XNƂ͎菜
		ItemText[ lstrlen( ItemText ) -1 ] = 0;
	}

	for(i=0;i<MdiInfo.size();i++){
		if(lstrcmpi(ItemText,MdiInfo[i]->title.c_str())==0) break;
	}
	BringWindowToTop(MdiInfo[i]->hwnd);
}
void CMainTab::MdiActiveEvent(const char *lpszText){
	int i2;
	i2=SearchItemIndex(lpszText);
	if(i2==-1) return;

	TabCtrl_SetCurSel(hTab,i2);
//	ActiveBasic::IDE::Program::mainFrame.ActivateChildWindow( *GetItemInfo( hTab, i2 )->TaskbarButtonWindow );
}

void CMainTab::draw(HDC hdc){
	COLORREF colorGray;
	HBRUSH hGrayBrush;

	int nMaxPage;
	nMaxPage=TabCtrl_GetItemCount(hTab);

	//y𐶐
	HPEN hPen,hOldPen;
	COLORREF colorPen;
	colorPen=RGB(127,140,155);
	hPen=CreatePen(PS_SOLID,0,colorPen);
	hOldPen=(HPEN)SelectObject(hdc,hPen);

	//`̈hԂ
	RECT rc;
	GetClientRect(hTab,&rc);
	FillRect(hdc,&rc,GetSysColorBrush(COLOR_3DFACE));

	//[W𐶐
	HRGN hDefaultRgn;
	hDefaultRgn=CreateRectRgnIndirect(&rc);

	int i;
	char temporary[MAX_PATH];
	HFONT hOldFont;
	TCITEM item;
	memset(&item,0,sizeof(TCITEM));
	item.mask=TCIF_TEXT|TCIF_PARAM;
	item.pszText=temporary;
	item.cchTextMax=MAX_PATH;
	for(i=nMaxPage-1;i>=0;i--){
		if(i==TabCtrl_GetCurSel(hTab)){
			//tH[JX^u͍Ōɕ`悷邽߁Aщz
			continue;
		}

		TabCtrl_GetItem(hTab,i,&item);

		//W擾
		TabCtrl_GetItemRect(hTab,i,&rc);



		////////////////////////////
		// ^ug`
		////////////////////////////
		colorGray=item.lParam ? reinterpret_cast<ItemInfo*>( item.lParam )->Color : RGB(0xcc, 0xcc, 0xcc);

		//uV𐶐
		hGrayBrush=CreateSolidBrush(colorGray);

		SetBkColor(hdc,colorGray);

		HBRUSH hOldBrush;
		hOldBrush=(HBRUSH)SelectObject(hdc,hGrayBrush);

		HRGN hRgn1,hRgn2;
		hRgn1=CreateRectRgn(rc.left,rc.top,rc.right-20,rc.bottom);
		hRgn2=CreateRectRgn(rc.right-20,rc.top,rc.right+2,rc.bottom);

		SelectObject(hdc,hRgn1);
		RoundRect(hdc,rc.left,rc.top,rc.right+2,rc.bottom+20,20,15);
		SelectObject(hdc,hRgn2);
		RoundRect(hdc,rc.left,rc.top,rc.right+2,rc.bottom+20,3,3);
		SelectObject(hdc,hDefaultRgn);

		DeleteObject(hRgn1);
		DeleteObject(hRgn2);

		SelectObject(hdc,hOldBrush);
		DeleteObject(hGrayBrush);


		extern HFONT hStatusFont;
		hOldFont=(HFONT)SelectObject(hdc,hStatusFont);



		//`
		DrawText(hdc,item.pszText,-1,&rc,DT_CENTER|DT_VCENTER|DT_SINGLELINE);


		SelectObject(hdc,hOldFont);
	}


	/////////////////////////////////
	// tH[JX^u`
	/////////////////////////////////
	i=TabCtrl_GetCurSel(hTab);

	TabCtrl_GetItem(hTab,i,&item);

	//W擾
	TabCtrl_GetItemRect(hTab,i,&rc);

	{
		rc.top-=2;
		////////////////////////////
		// ^ug`
		////////////////////////////
		colorGray=item.lParam ? reinterpret_cast<ItemInfo*>( item.lParam )->Color : RGB(0xcc, 0xcc, 0xcc);

		//uV𐶐
		hGrayBrush=CreateSolidBrush(colorGray);

		SetBkColor(hdc,colorGray);

		HBRUSH hOldBrush;
		hOldBrush=(HBRUSH)SelectObject(hdc,hGrayBrush);

		HRGN hRgn1,hRgn2;
		hRgn1=CreateRectRgn(rc.left,rc.top,rc.right-20,rc.bottom);
		hRgn2=CreateRectRgn(rc.right-20,rc.top,rc.right+2,rc.bottom);

		SelectObject(hdc,hRgn1);
		RoundRect(hdc,rc.left,rc.top,rc.right+2,rc.bottom+20,20,15);
		SelectObject(hdc,hRgn2);
		RoundRect(hdc,rc.left,rc.top,rc.right+2,rc.bottom+20,3,3);
		SelectObject(hdc,hDefaultRgn);

		DeleteObject(hRgn1);
		DeleteObject(hRgn2);

		SelectObject(hdc,hOldBrush);
		DeleteObject(hGrayBrush);

		rc.top+=2;
	}

	hOldFont=(HFONT)SelectObject(hdc,hBoldFont);

	//`
	DrawText(hdc,item.pszText,-1,&rc,DT_CENTER|DT_VCENTER|DT_SINGLELINE);

	SelectObject(hdc,hOldFont);



	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);

	DeleteObject(hDefaultRgn);
}
