#include "stdafx.h"
#include <boost/range/algorithm.hpp>
#include <string.h>
#include "OSVersion.h"

namespace ActiveBasic { namespace Common {

bool IsPathEqual(LPCWSTR lhs, LPCWSTR rhs)
{
	std::vector<WCHAR> l(lhs, lhs + std::wcslen(lhs) + 1);
	std::vector<WCHAR> r(rhs, rhs + std::wcslen(rhs) + 1);
	if (Is9x())
	{
		auto const& ct = std::use_facet<std::ctype<wchar_t>>(std::locale::classic());
		ct.toupper(l.data(), l.data() + l.size());
		ct.toupper(r.data(), r.data() + r.size());
	}
	else
	{
		::CharUpperW(l.data());
		::CharUpperW(l.data());
	}
	return boost::equal(l, r);
}

}}
