#include "stdafx.h"

using namespace ActiveBasic::Compiler;

using boost::numeric_cast;

bool LexicalAnalyzer::CollectNamespaces(char const* source, NamespaceScopesCollection &namespaceScopesCollection)
{
	bool isSuccessful = true;

	// OԊǗ
	NamespaceScopes namespaceScopes;

	for (int i = 0; ; i++)
	{
		if(source[i]=='\0') break;

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			i+=2;
			char const* p = &source[i];
			while (!IsCommandDelimitation(source[i]))
			{
				++i;
			}
			namespaceScopes.push_back(std::string(p, &source[i]));

			if( !namespaceScopesCollection.IsExist( namespaceScopes ) ){
				namespaceScopesCollection.push_back( namespaceScopes );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				compiler.errorMessenger.Output( 12, "End Namespace", i );
				isSuccessful = false;
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
	}

	if( !namespaceScopes.empty() ){
		compiler.errorMessenger.Output( 63, NULL, cp );
		isSuccessful = false;
	}

	return isSuccessful;
}

Symbol LexicalAnalyzer::FullNameToSymbol( const char *fullName )
{
	char areaName[VN_SIZE] = "";		//IuWFNgϐ
	char nestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName, areaName, nestName );

	return Symbol( NamespaceScopes( areaName ), nestName );
}

Symbol LexicalAnalyzer::FullNameToSymbol( const std::string &fullName )
{
	return FullNameToSymbol( fullName.c_str() );
}
