

class BreakPointsPerFile
{
public:
	std::string filename;
	std::vector<int> lines;

	BreakPointsPerFile(const char *lpszFileName,int iLineNum);

	BreakPointsPerFile(BreakPointsPerFile&& y)
		: filename(std::move(y.filename))
		, lines(std::move(y.lines))
	{
	}

	BreakPointsPerFile(BreakPointsPerFile const& y)
		: filename(y.filename)
		, lines(y.lines)
	{
	}

	BreakPointsPerFile& operator =(BreakPointsPerFile&& y)
	{
		filename = std::move(y.filename);
		lines = std::move(y.lines);
		return *this;
	}

	BreakPointsPerFile& operator =(BreakPointsPerFile const& y)
	{
		return *this = std::move(BreakPointsPerFile(y));
	}

	void add(int iLineNum);
	void remove(int iLineNum);

	void update( char *nativeCodeBuffer, const SourceLines &sourceLines );

};
typedef std::vector<BreakPointsPerFile> BreakPointsPerFiles;

class BreakPointManager
{
	BreakPointsPerFiles breakpointsPerFiles;

public:
	BreakPointManager();

	void insert(const char *lpszFileName,int iLineNum);
	void remove(const char *lpszFileName,int iLineNum);

	char *update( char *nativeCodeBuffer, int SizeOf_CodeSection, const SourceLines &sourceLines );

private:
	BreakPointManager(BreakPointManager const&);
	BreakPointManager& operator =(BreakPointManager const&);
};


extern BreakPointManager *pobj_DBBreakPoint;
