
class CDebugger{
	BOOL bDebugging;
public:
	HWND hwnd;

	CDebugger::CDebugger();
	CDebugger::~CDebugger();

	BOOL IsDebugging(void);
	BOOL IsDebuggerView(void);

	void resize(int x,int y,int cx,int cy);

	void ResetCommandEnabled(void);

	void SaftyCheck(void);

	void begin(void);
	void end(void);
	void watch_start(HWND hDebuggerView);
	void watch_quit(void);


	/////////////////////////////////
	// CxgɂAvԒʐM
	/////////////////////////////////

	void DebugContinue(void);
	void StepIn(void);
	void StepOver(void);
	void StepToCursor(void);

	void DebugStop(void);
	void DebugPause(void);
};

extern CDebugger *pobj_Debugger;





/////////////////////////////////
// u[N|Cg
/////////////////////////////////

class BreakPointsPerFile{
public:
	char *lpszFileName;

	int *piLine;
	int num;

	BreakPointsPerFile(const char *lpszFileName,int iLineNum);
	~BreakPointsPerFile();

	void add(int iLineNum);
	void remove(int iLineNum);

	BOOL check(int iLineNum);

	void replace(LPSTR lpszBuffer,CHARRANGE *pDelRange,CHARRANGE *pRange,LPSTR lpszNewStr);
};

class CDBBreakPoint{
	BreakPointsPerFile **ppItem;
	int num;

public:
	CDBBreakPoint();
	~CDBBreakPoint();

	void insert( const char *lpszFileName,int iLineNum);
	void remove( const char *lpszFileName,int iLineNum);

	void Event_BreakPoint(void);
	void SaveToTempFile(void);

	BreakPointsPerFile *EnumLines(const char *lpszFilePath);

	void replace(const char *lpszFilePath,LPSTR lpszBuffer,CHARRANGE *pDelRange,CHARRANGE *pRange,LPSTR lpszNewStr);
};
