#include "stdafx.h"
#include <jenga/include/jenga.h>
#include <abdev/ab_common/include/ab_common.h>

Interface::Interface( const CClass *pInterfaceClass, const Types &actualTypeParameters )
	: DynamicMethodsPrototype()
	, pInterfaceClass( pInterfaceClass )
	, vtblOffset( -1 )
	, actualTypeParameters( actualTypeParameters )
{
	//\bhRs[
	foreach( const CMethod *pBaseMethod, pInterfaceClass->GetDynamicMethods() )
	{
		CMethod *pMethod = new DynamicMethod( *pBaseMethod );

		// ANZVreB
		if(pBaseMethod->GetAccessibility() == Prototype::Private){
			pMethod->SetAccessibility( Prototype::None );
		}
		else{
			pMethod->SetAccessibility( pBaseMethod->GetAccessibility() );
		}

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(pBaseMethod->GetInheritsClassPtr()==0){
			pMethod->SetInheritsClassPtr( pInterfaceClass );
		}
		else{
			pMethod->SetInheritsClassPtr( pBaseMethod->GetInheritsClassPtr() );
		}

		AddDynamicMethods( pMethod );
	}
}

bool Interface::Equals( const Interface *pInterface ) const
{
	// |C^ǂĂ݂
	if( this == pInterface )
	{
		return true;
	}
	else if( this->pInterfaceClass->IsNeedResolve() || pInterface->pInterfaceClass->IsNeedResolve() )
	{
		// ˑ֌WȌԂł΁ApXǂĂ݂
		if( this-pInterfaceClass->IsDuplication( pInterface->pInterfaceClass ) )
		{
			return true;
		}
	}
	return false;
}

std::string Interface::GetFullNameWithActualGenericTypeParameters() const
{
	std::string interfaceName = this->GetClass().GetFullName();
	if( actualTypeParameters.size() )
	{
		std::string actualGenericTypesName;
		foreach( const Type &typeParameter, actualTypeParameters )
		{
			if( actualGenericTypesName.size() )
			{
				actualGenericTypesName += ",";
			}
			actualGenericTypesName += typeParameter.ToString();
		}

		interfaceName += "<" + actualGenericTypesName + ">";
	}
	return interfaceName;
}

bool Interface::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	// I\bh
	foreach( CMethod *pMethod, GetDynamicMethods() )
	{
		pMethod->Resolve( resolver, resolveErrors );
	}

	// NX
	if( this->pInterfaceClass )
	{
		if( this->pInterfaceClass->IsNeedResolve() )
		{
			const CClass *pTempClass = resolver.meta.GetClasses().FindLike( this->pInterfaceClass );
			if( pTempClass )
			{
				this->pInterfaceClass = pTempClass;
			}
			else
			{
				resolveErrors.Add( ResolveError( this->pInterfaceClass->GetRelationalObjectModuleIndex(), this->pInterfaceClass->GetFullName() ) );
			}
		}
	}

	BOOST_FOREACH( Type &actualTypeParameter, actualTypeParameters )
	{
		actualTypeParameter.Resolve( resolver, resolveErrors );
	}

	return true;
}
