#pragma once

namespace ActiveBasic{ namespace Common{


struct ResourceItem
{
	std::string idName;
	std::string filepath;

	// IDÊ݂Ŏg
	HTREEITEM hTreeItem;

	ResourceItem()
		: idName()
		, filepath()
		, hTreeItem() {}

	ResourceItem(ResourceItem&& y)
		: idName(std::move(y.idName))
		, filepath(std::move(y.filepath))
		, hTreeItem(std::move(y.hTreeItem)) {}

	ResourceItem(ResourceItem const& y)
		: idName(y.idName)
		, filepath(y.filepath)
		, hTreeItem(y.hTreeItem) {}

	ResourceItem& operator =(ResourceItem&& y)
	{
		idName = std::move(y.idName);
		filepath= std::move(y.filepath);
		hTreeItem = std::move(y.hTreeItem);
		return *this;
	}

	ResourceItem& operator =(ResourceItem const& y)
	{
		return *this = std::move(ResourceItem(y));
	}
};

typedef std::vector<ResourceItem> ResourceItems;


class ResourceManager
{
public:
	ResourceManager() {}

	void Clear();
	bool Load( const std::string &resourceFilePath );
	bool Save( const std::string &resourceFilePath );

	bool HasManifest() const;

	ResourceItems cursorResources;
	ResourceItems bitmapResources;
	ResourceItems iconResources;
	std::string manifestFilePath;

private:
	ResourceManager(ResourceManager const&);
	ResourceManager operator =(ResourceManager const&);
};


}}
