#pragma once

class CClass;

namespace ActiveBasic{ namespace Common{ namespace Lexical{


class ExpandedTemplateClass
{
	CClass *pClass;
	Types actualTypes;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_NVP( pClass );
		ar & BOOST_SERIALIZATION_NVP( actualTypes );
	}


public:
	ExpandedTemplateClass( CClass *pClass, const Types &actualTypes )
		: pClass( pClass )
		, actualTypes( actualTypes )
	{
	}
	ExpandedTemplateClass()
		: pClass( NULL )
	{
	}
	~ExpandedTemplateClass();

	const CClass &GetClass() const
	{
		return *pClass;
	}
	CClass &GetClass()
	{
		return *pClass;
	}

	const Types &GetActualTypes() const
	{
		return actualTypes;
	}

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );

private:
	ExpandedTemplateClass(ExpandedTemplateClass const&);
	ExpandedTemplateClass& operator =(ExpandedTemplateClass const&);
};

typedef std::vector<ExpandedTemplateClass *> ExpandedTemplateClasses;


}}}
