#include "stdafx.h"
#include <jenga/include/jenga.h>
#include <abdev/ab_common/include/ab_common.h>

using namespace ActiveBasic::Common::Lexical;

bool NamespaceSupporter::ImportsNamespace( const NamespaceScopes &namespaceScopes )
{
	_ASSERT( allNamespaceScopesCollection );
	if( !allNamespaceScopesCollection->IsExist( namespaceScopes ) ){
		return false;
	}

	this->importedNamespaces.push_back( namespaceScopes );

	return true;
}

bool NamespaceSupporter::ImportsNamespace( const std::string &namespaceStr )
{
	NamespaceScopes namespaceScopes( namespaceStr );

	return ImportsNamespace( namespaceScopes );
}

bool NamespaceSupporter::IsCoverd( const NamespaceScopes &base, const NamespaceScopes &entry ) const
{
	// ܂͂̂܂܂Ń}b`O݂
	if( base.IsEqual( entry ) )
	{
		return true;
	}

	// ݂̖OԂƂ̃}b`O݂
	typedef NamespaceScopes::const_iterator cnsit_t;
	cnsit_t first = livingNamespaceScopes.begin();
	cnsit_t last = livingNamespaceScopes.end();
	NamespaceScopes temp;
	while( first != last )
	{
		temp.assign( first, last );
		temp.append( entry );
		if( base.IsEqual( temp ) )
		{
			return true;
		}
		--last;
	}

	// ImportsĂ閼OԂƂ̃}b`O݂
	foreach( const NamespaceScopes &importedNamespaceScopes, GetImportedNamespaces() )
	{
		if( base.IsEqual( importedNamespaceScopes + entry ) )
		{
			return true;
		}
	}

	return false;
}

bool NamespaceSupporter::IsSameAreaNamespace( const NamespaceScopes &baseNamespaceScopes, const NamespaceScopes &entryNamespaceScopes ) const
{
	if( entryNamespaceScopes.size() )
	{
		if( IsCoverd( baseNamespaceScopes, entryNamespaceScopes ) )
		{
			// ĂƂ͓ƌȂ
			return true;
		}
	}
	else{
		if( baseNamespaceScopes.size() )
		{
			// OԂ̔fKvȂƂ
			if( this->importedNamespaces.IsImported( baseNamespaceScopes )
				|| IsLiving( baseNamespaceScopes ) )
			{
				// Usingw肪Ƃ
				// ܂
				// w肳ꂽOԂ݂̖OԃXR[vƓ̂Ƃ
				return true;
			}
		}
		else{
			return true;
		}
	}

	return false;
}
