#include "stdafx.h"
#include <jenga/include/jenga.h>
#include <abdev/ab_common/include/ab_common.h>
#include "Lexical/Type.h"

const int Type::basicTypeList[] = {
	DEF_BYTE,
	DEF_SBYTE,
	DEF_WORD,
	DEF_INTEGER,
	DEF_DWORD,
	DEF_LONG,
	DEF_QWORD,
	DEF_INT64,

	DEF_SINGLE,
	DEF_DOUBLE,

	DEF_BOOLEAN,

	DEF_PTR_VOID,

	DEF_ANY,

	DEF_NON
};

const std::string Type::basicTypeNameList[] = {
	"Byte",
	"SByte",
	"Word",
	"Integer",
	"DWord",
	"Long",
	"QWord",
	"Int64",

	"Single",
	"Double",

	"Boolean",

	"VoidPtr",

	"Any",

	""
};

Type::~Type()
{
}

bool Type::StringToBasicType( const std::string &typeName, int &basicType ){
	for( int i=0; ; i++ ){
		if( basicTypeList[i] == DEF_NON ){
			break;
		}
		if( basicTypeNameList[i] == typeName ){
			basicType = basicTypeList[i];
			return true;
		}
	}
	return false;
}
const char *Type::BasicTypeToCharPtr( const Type &type )
{
	for( int i=0; ; i++ ){
		if( basicTypeList[i] == DEF_NON ){
			break;
		}
		if( basicTypeList[i] == type.GetBasicType() ){
			return basicTypeNameList[i].c_str();
		}
	}
	return NULL;
}

int Type::GetBasicSize( int basicType )
{

	// {^
	switch( basicType ){
		case DEF_SBYTE:
		case DEF_BYTE:
		case DEF_BOOLEAN:
			return sizeof(BYTE);

		case DEF_INTEGER:
		case DEF_WORD:
			return sizeof(WORD);

		case DEF_LONG:
		case DEF_DWORD:
			return sizeof(DWORD);

		case DEF_INT64:
		case DEF_QWORD:
			return sizeof(_int64);

		case DEF_DOUBLE:
			return sizeof(double);
		case DEF_SINGLE:
			return sizeof(float);
	}

	// |C^
	if(IsPointer( basicType )){
		return PTR_SIZE;
	}

	// IuWFNg
	if(basicType==DEF_OBJECT){
		return PTR_SIZE;
	}

	throw;

	return 0;
}

const CClass &Type::GetClass() const
{
	if( !HasMember() )
	{
		Jenga::Throw( "NX܂͍\̂łȂ^ɑ΂GetClassĂяo" );
	}

	return *pClass;
}

bool Type::Equals( const Type &type ) const
{
	if( basicType == type.basicType )
	{
		if( NATURAL_TYPE( basicType ) == DEF_OBJECT || NATURAL_TYPE( basicType ) == DEF_STRUCT )
		{
			// |C^ǂĂ݂
			if( this->pClass == type.pClass )
			{
				return true;
			}
			else if( this->pClass->IsNeedResolve() || type.pClass->IsNeedResolve() )
			{
				// ˑ֌WȌԂł΁ApXǂĂ݂
				if( this->pClass->IsDuplication( type.pClass ) )
				{
					return true;
				}
			}
		}
		else
		{
			return true;
		}
	}
	return false;
}

bool Type::IsCovariant( const Type &type ) const
{
	if( !this->IsObject() || !type.IsObject() )
	{
		// ϐ̔ʂ̓NX^̂
		return false;
	}

	return this->GetClass().IsSubClass( &type.GetClass() );
}
bool Type::IsContravariant( const Type &type ) const
{
	if( !this->IsObject() || !type.IsObject() )
	{
		// ϐ̔ʂ̓NX^̂
		return false;
	}

	return type.GetClass().IsSubClass( &this->GetClass() );
}

int Type::GetBasicSize() const
{
	return GetBasicSize( basicType );
}
int Type::GetSize() const
{

	// {^
	switch( basicType ){
		case DEF_LONG:
			if(index==LITERAL_NULL||index==LITERAL_M128_0||index==LITERAL_0_255){
				return sizeof(BYTE);
			}
			else if(index==LITERAL_M32768_0||index==LITERAL_0_65535){
				return sizeof(WORD);
			}
			return sizeof(DWORD);

		case DEF_SBYTE:
		case DEF_BYTE:
		case DEF_BOOLEAN:
			return sizeof(BYTE);

		case DEF_INTEGER:
		case DEF_WORD:
			return sizeof(WORD);

		case DEF_DWORD:
			return sizeof(DWORD);

		case DEF_INT64:
		case DEF_QWORD:
			return sizeof(_int64);

		case DEF_DOUBLE:
			return sizeof(double);
		case DEF_SINGLE:
			return sizeof(float);
	}

	// |C^
	if(IsPointer()){
		return PTR_SIZE;
	}

	// \
	if( IsStruct() )
	{
		if( !pClass ){
			throw;
		}

		return pClass->GetSize();
	}

	// IuWFNg
	if( IsObject() )
	{
		return PTR_SIZE;
	}

	throw;
}

bool Type::IsNull() const{
  if( basicType == DEF_NON ){
	  return true;
  }
  return false;
}

bool Type::IsByte() const{
  if( basicType == DEF_BYTE ){
	  return true;
  }
  return false;
}
bool Type::IsSByte() const{
  if( basicType == DEF_SBYTE ){
	  return true;
  }
  return false;
}
bool Type::IsWord() const{
  if( basicType == DEF_WORD ){
	  return true;
  }
  return false;
}
bool Type::IsInteger() const{
  if( basicType == DEF_INTEGER ){
	  return true;
  }
  return false;
}
bool Type::IsDWord() const{
  if( basicType == DEF_DWORD ){
	  return true;
  }
  return false;
}
bool Type::IsLong() const{
  if( basicType == DEF_LONG ){
	  return true;
  }
  return false;
}
bool Type::IsQWord() const{
  if( basicType == DEF_QWORD ){
	  return true;
  }
  return false;
}
bool Type::IsInt64() const{
  if( basicType == DEF_INT64 ){
	  return true;
  }
  return false;
}
bool Type::IsSingle() const{
  if( basicType == DEF_SINGLE ){
	  return true;
  }
  return false;
}
bool Type::IsDouble() const{
  if( basicType == DEF_DOUBLE ){
	  return true;
  }
  return false;
}
bool Type::IsBoolean() const{
  if( basicType == DEF_BOOLEAN ){
	  return true;
  }
  return false;
}

bool Type::IsPointer( int basicType )
{
	if( basicType == DEF_NON )
	{
		return false;
	}

	if(PTR_LEVEL( basicType )|| basicType == DEF_PTR_VOID || basicType == DEF_PTR_PROC
		|| ( basicType & FLAG_PTR ) ){
			return true;
	}

	return false;
}
bool Type::IsPointer() const
{
	return IsPointer( basicType );
}
bool Type::IsSigned() const
{
	switch( basicType ){
		case DEF_SBYTE:
		case DEF_INTEGER:
		case DEF_LONG:
		case DEF_INT64:
		case DEF_SINGLE:
		case DEF_DOUBLE:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::IsNaturalWhole() const
{
	switch( basicType ){
		case DEF_SBYTE:
		case DEF_BYTE:
		case DEF_INTEGER:
		case DEF_WORD:
		case DEF_LONG:
		case DEF_DWORD:
		case DEF_INT64:
		case DEF_QWORD:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::IsWhole() const
{
	return (
		IsNaturalWhole()
		|| IsPointer( basicType )
		|| basicType == DEF_BOOLEAN
		);
}
bool Type::IsReal() const
{
	switch( basicType ){
		case DEF_SINGLE:
		case DEF_DOUBLE:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::Is64() const
{
	switch( basicType ){
		case DEF_QWORD:
		case DEF_INT64:
			return true;
		default:
			break;
	}
	return false;
}

bool Type::IsValueType() const
{
	return ( IsWhole() || IsReal() );
}

bool Type::IsProcPtr() const
{
	if( basicType == DEF_PTR_PROC ){
		return true;
	}
	return false;
}
bool Type::IsStruct() const
{
	if( basicType == DEF_STRUCT ){
		return true;
	}
	return false;
}
bool Type::IsStructPtr() const
{
	if( basicType == DEF_PTR_STRUCT ){
		return true;
	}
	return false;
}
bool Type::IsObject() const
{
	return (
		basicType == DEF_OBJECT
		|| basicType == DEF_TYPE_PARAMETER
	);
}
bool Type::IsObjectPtr() const
{
	if( basicType == DEF_PTR_OBJECT ){
		return true;
	}
	return false;
}
bool Type::IsTypeParameter() const
{
	return ( NATURAL_TYPE(basicType) == DEF_TYPE_PARAMETER );
}
bool Type::IsObjectClass() const
{
	if( basicType == DEF_OBJECT ){
		if( pClass->GetName() == "Object" ){
			return true;
		}
	}
	return false;
}
bool Type::IsStringClass() const
{
	if( basicType == DEF_OBJECT ){
		if( pClass->GetName() == "String" ){
			return true;
		}
	}
	return false;
}
bool Type::IsVoidPtr() const
{
	if( basicType == DEF_PTR_VOID ){
		return true;
	}
	return false;
}

bool Type::IsAny() const
{
	if( basicType == DEF_ANY ){
		return true;
	}
	return false;
}

bool Type::IsDelegate() const
{
	return ( IsObject() && GetClass().IsDelegate() );
}
bool Type::IsInterface() const
{
	return ( IsObject() && GetClass().IsInterface() );
}
bool Type::IsComInterface() const
{
	return ( IsObject() && GetClass().IsComInterface() );
}


bool Type::HasMember() const
{
	if( NATURAL_TYPE( basicType ) == DEF_OBJECT
		|| NATURAL_TYPE( basicType ) == DEF_STRUCT
		|| NATURAL_TYPE( basicType ) == DEF_TYPE_PARAMETER
	){
		return true;
	}
	return false;
}

const Type &Type::GetActualGenericType( int index ) const
{
	return actualGenericTypes[index].GetType();
}
bool Type::HasActualGenericType() const
{
	return ( actualGenericTypes.size() > 0 );
}

std::string Type::ToString() const
{
	const char *basicTypeName = BasicTypeToCharPtr( *this );
	if( basicTypeName )
	{
		return basicTypeName;
	}

	if( IsTypeParameter() )
	{
		return GetFormalTypeName();
	}

	std::string typeName = GetClass().GetFullName();
	if( HasActualGenericType() )
	{
		std::string actualGenericTypesName;
		foreach( const GenericType &actualGenericType, actualGenericTypes )
		{
			if( actualGenericTypesName.size() )
			{
				actualGenericTypesName += ",";
			}
			actualGenericTypesName += actualGenericType.GetName();
		}

		typeName += "<" + actualGenericTypesName + ">";
	}
	return typeName;
}

int Type::GetBasicTypeFromSimpleName( const char *variable ){
	assert(variable != nullptr);
	auto length = std::strlen(variable);
	assert(length > 0);

	int i;
	char name[VN_SIZE];

	//\̃ȍꍇl
	for(i=length;i>0;i--){
		if(variable[i]=='.'){
			i++;
			break;
		}
	}

	for(;;i++){
		if(variable[i]=='('||variable[i]=='\0'){
			name[i]=0;
			break;
		}
		name[i]=variable[i];
	}
	//ϐI
	i--;
	if(name[i]=='#') return DEF_DOUBLE;
	if(name[i]=='!') return DEF_SINGLE;
	if(name[i]=='%') return DEF_INTEGER;
	return DEF_DOUBLE;
}

bool Type::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	if( this->HasMember() )
	{
		if( this->pClass->IsNeedResolve() )
		{
			const CClass *pTempClass = resolver.meta.GetClasses().FindLike( this->pClass );
			if( pTempClass )
			{
				this->pClass = pTempClass;
			}
			else
			{
				resolveErrors.Add( ResolveError( this->pClass->GetRelationalObjectModuleIndex(), this->pClass->GetFullName() ) );
			}
		}

		BOOST_FOREACH( GenericType &actualGenericType, actualGenericTypes )
		{
			actualGenericType.GetType().Resolve( resolver, resolveErrors );
		}
	}
	return true;
}

bool Types::IsEquals( const Types &types ) const
{
	if( this->size() != types.size() )
	{
		// ACeႤ
		return false;
	}

	const Types &thisTypes = *this;
	for( int i=0; i<static_cast<int>(this->size()); i++ )
	{
		if( !thisTypes[i].Equals( types[i] ) )
		{
			return false;
		}
	}

	return true;
}

void ResolveFormalGenericTypeParameter( Type &typeParameter, const Type &classType, const UserProc *pUserProc )
{
	if( !typeParameter.IsTypeParameter() )
	{
		// WFlbNȌ^ł͂ȂƂ
		return;
	}

	/////////////////////////////////////////////////////////
	//  WFlNXT|[g 

	// |C^x𒊏o
	int ptrLevel = PTR_LEVEL( typeParameter.GetBasicType() );

	if( pUserProc )
	{
		if( classType.IsObject() )
		{
			// NXł̎ȉ
			const CClass *pClass = &classType.GetClass();
			while( pClass->HasSuperClass() )
			{
				if( pUserProc->GetParentClassPtr() == &pClass->GetSuperClass() )
				{
					if( pClass->GetSuperClassActualTypeParameters().size() )
					{
						// TODO: K؂Ȍ`ɎibIɃgbv̌^ĂĂj
						typeParameter = pClass->GetSuperClassActualTypeParameters()[0];
					}
				}
				pClass = &pClass->GetSuperClass();
			}
		}
	}

	if( typeParameter.IsTypeParameter() )
	{
		if( classType.HasActualGenericType() )
		{
			typeParameter = classType.GetActualGenericType( typeParameter.GetFormalTypeIndex() );
		}
		else
		{
			// NXiw肳ĂȂƂObjectNXjɃZbg
			typeParameter.SetBasicType( DEF_OBJECT );
		}
	}

	for( int i=0; i<ptrLevel; i++ )
	{
		typeParameter.PtrLevelUp();
	}

	//
	/////////////////////////////////////////////////////////
}


const std::string BlittableType::GetCreateStaticMethodFullName() const
{
	return pClass->GetNamespaceScopes().ToString() + "." + pClass->GetName() + "._Create";
}

bool BlittableType::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	basicType.Resolve( resolver, resolveErrors );

	if( this->pClass->IsNeedResolve() )
	{
		const CClass *pTempClass = resolver.meta.GetClasses().FindLike( this->pClass );
		if( pTempClass )
		{
			this->pClass = pTempClass;
		}
		else
		{
			resolveErrors.Add( ResolveError( this->pClass->GetRelationalObjectModuleIndex(), this->pClass->GetFullName() ) );
		}
	}

	return true;
}
