#pragma once

class TypeDefCollection;

class TypeDef
	: public RelationalObjectModuleItem
{
	friend TypeDefCollection;

	std::string baseName;
	Type baseType;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - TypeDef" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( RelationalObjectModuleItem );

		if( ActiveBasic::Common::Environment::IsRemoveExternal() )
		{
			if( this->IsExternal() )
			{
				this->NeedResolve();
				return;
			}
		}

		ar & BOOST_SERIALIZATION_NVP( baseName );
		ar & BOOST_SERIALIZATION_NVP( baseType );
	}

public:
	TypeDef( const Symbol &symbol, const std::string &baseName, const Type &baseType );
	TypeDef()
	{
	}
	~TypeDef()
	{
	}

	TypeDef(TypeDef&& y)
		: RelationalObjectModuleItem(std::move(y))
		, baseName(std::move(y.baseName))
		, baseType(std::move(y.baseType))
	{
	}

	TypeDef(TypeDef const& y)
		: RelationalObjectModuleItem(y)
		, baseName(y.baseName)
		, baseType(y.baseType)
	{
	}

	TypeDef& operator =(TypeDef&& y)
	{
		RelationalObjectModuleItem::operator =(std::move(y));
		baseName = std::move(y.baseName);
		baseType = std::move(y.baseType);
		return *this;
	}

	TypeDef& operator =(TypeDef const& y)
	{
		return *this = std::move(TypeDef(y));
	}

	const std::string &GetBaseName() const
	{
		return baseName;
	}
	const Type &GetBaseType() const
	{
		return baseType;
	}

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};

class TypeDefCollection : public std::vector<TypeDef>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - TypeDefCollection" );

		ar & boost::serialization::make_nvp("vector_TypeDef",
			boost::serialization::base_object<std::vector<TypeDef>>(*this));
	}

public:
	TypeDefCollection();
	TypeDefCollection(TypeDefCollection&& y) : std::vector<TypeDef>(std::move(y)) {}
	TypeDefCollection(TypeDefCollection const& y) : std::vector<TypeDef>(y) {}
	TypeDefCollection& operator =(TypeDefCollection&& y)
	{
		std::vector<TypeDef>::operator =(std::move(y));
		return *this;
	}
	TypeDefCollection& operator =(TypeDefCollection const& y)
	{
		return *this = std::move(TypeDefCollection(y));
	}
	~TypeDefCollection();

	void Add( const Symbol &symbol, const std::string &baseName, int nowLine );
	const TypeDef *Find( const Symbol &symbol ) const;
};
