#include "stdafx.h"
#include <jenga/include/jenga.h>
#include <abdev/ab_common/include/ab_common.h>

ExpandedTemplateClass::~ExpandedTemplateClass()
{
	if( pClass )
	{
		delete pClass;
	}
}

bool ExpandedTemplateClass::Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors )
{
	if( pClass->IsNeedResolve() )
	{
		CClass *pTempClass = const_cast<CClass *>(resolver.meta.GetClasses().FindLike( pClass ));
		if( pTempClass )
		{
			this->pClass = pTempClass;
		}
		else
		{
			resolveErrors.Add( ResolveError( this->pClass->GetRelationalObjectModuleIndex(), this->pClass->GetFullName() ) );
		}
	}

	BOOST_FOREACH( Type &actualType, actualTypes )
	{
		actualType.Resolve( resolver, resolveErrors );
	}

	return true;
}
