#pragma once

class CClass;

class DynamicMethodsPrototype
{
	// I\bh
	Methods dynamicMethods;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_NVP( dynamicMethods );
	}

public:
	DynamicMethodsPrototype() {}
	DynamicMethodsPrototype(DynamicMethodsPrototype&& dynamicMethodsPrototype)
		: dynamicMethods(std::move(dynamicMethodsPrototype.dynamicMethods))
	{
	}
	DynamicMethodsPrototype(const DynamicMethodsPrototype &dynamicMethodsPrototype)
		: dynamicMethods(dynamicMethodsPrototype.dynamicMethods)
	{
	}

	DynamicMethodsPrototype& operator =(DynamicMethodsPrototype&& y)
	{
		dynamicMethods = std::move(y.dynamicMethods);
		return *this;
	}

	DynamicMethodsPrototype& operator =(DynamicMethodsPrototype const& y)
	{
		return *this = std::move(DynamicMethodsPrototype(y));
	}

	~DynamicMethodsPrototype(){}

	const Methods &GetDynamicMethods() const
	{
		return dynamicMethods;
	}
	Methods &GetDynamicMethods()
	{
		return dynamicMethods;
	}

	void AddDynamicMethods( CMethod *pMethod )
	{
		dynamicMethods.push_back( pMethod );
	}
};

class Interface : public DynamicMethodsPrototype
{
	const CClass *pInterfaceClass;
	mutable int vtblOffset;

	// ^p[^ip[^j
	Types actualTypeParameters;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Interface" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( DynamicMethodsPrototype );
		ar & boost::serialization::make_nvp("pInterfaceClass", const_cast<CClass *&>(pInterfaceClass) );
		ar & BOOST_SERIALIZATION_NVP( vtblOffset );
		ar & BOOST_SERIALIZATION_NVP( actualTypeParameters );
	}

public:
	Interface( const CClass *pInterfaceClass, const Types &actualTypeParameters );
	Interface(Interface&& objInterface)
		: DynamicMethodsPrototype(std::move(objInterface))
		, pInterfaceClass(std::move(objInterface.pInterfaceClass))
		, vtblOffset(std::move(objInterface.vtblOffset))
	{
	}
	Interface( const Interface &objInterface )
		: DynamicMethodsPrototype( objInterface )
		, pInterfaceClass( objInterface.pInterfaceClass )
		, vtblOffset( objInterface.vtblOffset )
	{
	}
	Interface()
		: pInterfaceClass( NULL )
		, vtblOffset( NULL )
	{
	}

	Interface& operator =(Interface&& y)
	{
		DynamicMethodsPrototype::operator =(std::move(y));
		pInterfaceClass = std::move(y.pInterfaceClass);
		vtblOffset = std::move(y.vtblOffset);
		return *this;
	}

	Interface& operator =(Interface const& y)
	{
		return *this = std::move(Interface(y));
	}

	const CClass &GetClass() const
	{
		return *pInterfaceClass;
	}
	int GetVtblOffset() const
	{
		return vtblOffset;
	}
	void SetVtblOffset( int vtblOffset ) const
	{
		this->vtblOffset = vtblOffset;
	}

	const Types &GetActualTypeParameters() const
	{
		return actualTypeParameters;
	}

	bool Equals( const Interface *pInterface ) const;

	std::string GetFullNameWithActualGenericTypeParameters() const;

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};
typedef std::vector<Interface *> Interfaces;
