#include <iosfwd>
#include <string>

#pragma once

namespace Jenga{
namespace Common{

template<class T_xml_schema> class BoostSerializationSupport{
	virtual const char *RootTagName() const = 0;

	void echo( const char *msg ) const;

public:
	bool ReadXml( std::istream& ifs, bool isShowExceptionMessage = true );
	bool WriteXml( std::ostream& ofs, bool isShowExceptionMessage = true ) const;
	bool ReadXml( const std::string &xmlFilePath, bool isShowExceptionMessage = true );
	bool WriteXml( const std::string &xmlFilePath, bool isShowExceptionMessage = true ) const;
	bool ReadXmlString( const std::string &xmlString );
	bool WriteXmlString( std::string &xmlString ) const;

	bool ReadBinaryFile( const std::string &filePath, bool isShowExceptionMessage = true );
	bool WriteBinaryFile( const std::string &filePath, bool isShowExceptionMessage = true ) const;
	bool ReadBinaryString( const std::string &binaryString );
	bool WriteBinaryString( std::string &binaryString ) const;

/*
rhɎԂ̂ŊOĂ
	bool ReadText( const std::string &filePath, bool isShowExceptionMessage = true );
	bool WriteText( const std::string &filePath, bool isShowExceptionMessage = true ) const;
	bool ReadTextString( const std::string &textString );
	bool WriteTextString( std::string &textString ) const;

	bool ReadXmlFromString( const std::string &xmlBuffer );
*/
};


}}
