#include "stdafx.h"
#include <jenga/include/jenga.h>
#include <abdev/ab_common/include/ab_common.h>
#include <algorithm>

using namespace ActiveBasic::Common::Lexical;


NamespaceScopes::NamespaceScopes( const std::string &namespaceStr ){
	if( namespaceStr.size() == 0 ){
		return;
	}

	std::string::size_type i = 0;
	while( true ){
		std::string::size_type i2 = namespaceStr.find( '.', i );

		std::string tempName = namespaceStr.substr( i, i2-i );

		push_back(std::move(tempName));

		if( i2 == std::string::npos ){
			break;
		}

		i = i2 + 1;
	}
}

NamespaceScopes ActiveBasic::Common::Lexical::operator +(const NamespaceScopes &lhs, const NamespaceScopes &rhs)
{
	return NamespaceScopes(lhs) += rhs;
}

bool NamespaceScopes::IsEqual( const NamespaceScopes &namespaceScopes ) const
{
	if( this->size() != namespaceScopes.size() )
	{
		return false;
	}
	return std::equal(begin(), end(), namespaceScopes.begin() );
}

void NamespaceScopesCollection::SplitNamespace( const char *fullName, char *namespaceStr, char *simpleName ) const
{
	NamespaceScopes namespaceScopes( fullName );
	bool hasSimpleName = false;
	while( namespaceScopes.size() > 0 ){
		if( IsExist( namespaceScopes ) ){
			break;
		}
		namespaceScopes.pop_back();

		hasSimpleName = true;
	}

	strcpy( namespaceStr, namespaceScopes.ToString().c_str() );

	bool hasNamespace = false;
	if( namespaceStr[0] ){
		hasNamespace = true;
	}

	int dotLength = 0;
	if( hasSimpleName && hasNamespace ){
		dotLength = 1;
	}

	strcpy( simpleName, fullName + strlen( namespaceStr ) + dotLength );
}

