#pragma once

#include "MachineFixed.h"


//ϐ̎
#define NON_VAR				0
#define VAR_GLOBAL			1	// Global Variable
#define VAR_REFGLOBAL		2	// Global Refference Variable
#define VAR_LOCAL			3	// Local Variable
#define VAR_REFLOCAL		4	// Local Refference Variable
#define VAR_DIRECTMEM		5	// Direct memory


extern int cp;

#define breakpoint compiler.codeGenerator.PutOld( (char)0xCC );


//vV[W
struct PROCEDURE{
	char name[255];
	int address;
	int types[MAX_PARMS];
	_int8 ByVal[MAX_PARMS];
	BOOL ReturnType;
};

//With
struct WithInfo
{
	std::string name;
	int sourceCodePos;

	WithInfo( const std::string &name, int sourceCodePos )
		: name( name )
		, sourceCodePos( sourceCodePos )
	{
	}

	WithInfo(WithInfo&& y)
		: name(std::move(y.name))
		, sourceCodePos(std::move(y.sourceCodePos))
	{
	}

	WithInfo(WithInfo const& y)
		: name(y.name)
		, sourceCodePos(y.sourceCodePos)
	{
	}

	WithInfo& operator =(WithInfo&& y)
	{
		name = std::move(y.name);
		sourceCodePos = std::move(y.sourceCodePos);
		return *this;
	}

	WithInfo& operator =(WithInfo const& y)
	{
		return *this = std::move(WithInfo(y));
	}
};
typedef std::vector<WithInfo> WithInfos;


//RSrcSection.cpp
char *GetRSrcSectionBuffer(int *pLen);

//Compile.cpp
void Compile( const char *source );
void ChangeOpcode(char *Command);
void GetGlobalDataForDll(void);
DWORD CompileBuffer(char Return_Sequence,WORD Return_Command);

//Compile_Calc.cpp
void ChangeTypeToDouble_ToFpuReg(int OldType);
void ChangeTypeToDouble(int OldType);
void ChangeTypeToSingle(int OldType);
void ChangeTypeToInt64(int OldType);
void ChangeTypeToLong(int OldType);
void ChangeTypeToInteger(int OldType);
void ChangeTypeToByte(int OldType);
void SetVariableFromEax( const Type &varType, int CalcType,RELATIVE_VAR *pRelativeVar);
void OpcodeCalc( const char *Command );

//NumOpe.cpp
void PushReturnValue( const Type &type );
bool TermOpeOnlyVariable( const char *term, Type &resultType, RELATIVE_VAR &relativeVar, bool isWriteAccess );
bool TermOpe(
			 const char *term,
			 const Type &baseType,
			 Type &resultType,
			 bool &isLiteral,
			 bool &isNeedHeapFreeStructure,
			 bool *pIsClassName = NULL,
			 bool isProcedureCallOnly = false,
			 bool isWriteAccess = false );
bool NumOpe( int reg,
			const char *expression,
			const Type &baseType,
			Type &resultType,
			bool *pbIsNeedHeapFreeStructure = NULL );
bool NumOpe( const char *Command,
		   const Type &baseType,
		   Type &resultType,
		   bool *pbIsNeedHeapFreeStructure = NULL );

//NumOpe_Arithmetic.cpp
void GetStackData_ToRegister(int *type,int sp);
BOOL CalcTwoTerm_Arithmetic(int idCalc,int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Mod(int *type,int *pStackPointer);
BOOL Calc_Divide(int *type,int *pStackPointer,int BaseType);
BOOL Calc_IntDivide(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_MinusMark(int *type,int sp);
BOOL Calc_Power(int *type,int *pStackPointer);
BOOL Calc_Cast(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_SHL(int *type,int *pStackPointer);
BOOL Calc_SHR(int *type,int *pStackPointer);

//NumOpe_Logical.cpp
BOOL Calc_Xor(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Or(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_And(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Not(int *type,int sp);

//NumOpe_Relation.cpp
BOOL Calc_Relation_PE(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_QE(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_P(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_Q(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_NotEqual(int *type,int *pStackPointer);
BOOL Calc_Relation_Equal(int *type,int *pStackPointer);

//NumOpe_TypeOperation.cpp
void ExtendStackTo64( const Type &oldType );
void ChangeTypeToWhole( const Type &oldType, const Type &newType );

//Compile_Set_Var.cpp
BOOL IsUse_ecx(RELATIVE_VAR *pRelativeVar);
void SetStructVariable( const Type &varType, const Type &calcType, BOOL bUseHeap);
void SetRealVariable(int VarType, int CalcType, RELATIVE_VAR *pRelativeVar);
void SetWholeVariable( int varSize,int calcType, RELATIVE_VAR *pRelative );

void SetDoubleVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetSingleVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetInt64Variable(int type,RELATIVE_VAR *pRelative);
void SetDWordVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetLongVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void Set16Variable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void Set8Variable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetBooleanVariable(int type,RELATIVE_VAR *pRelative);
void ExtendTypeTo64(int type);
void ExtendTypeTo32(int type,int reg);
void ExtendTypeTo16(int type,int reg);

//increment.cpp
void IncDec(int idCalc, const char *lpszLeft, const char *lpszRight);

//calc2.cpp
#define EXP_TYPE_NUMBER	1
#define EXP_TYPE_EAX	2
#define EXP_TYPE_FPU	3
#define EXP_TYPE_VAR	4
int NumOpEx(char *Command,double *pDbl,DWORD *pdwType,RELATIVE_VAR *pRelativeVar);

//SetVar.cpp
BOOL SetVariable(DWORD dwVarType,RELATIVE_VAR *pVarRelativeVar,
				 DWORD dwExpType,DWORD dwType,void *data);

//Compile_Calc_PushVar.cpp
void SetReg_RealVariable(int type,RELATIVE_VAR *pRelativeVar);
void SetReg_WholeVariable( const Type &type, RELATIVE_VAR *pRelativeVar,int reg, bool is64Head = false);
void PushLongVariable(RELATIVE_VAR *pRelativeVar);

//Compile_Object.cpp
void Operator_New( const CClass &classObj, const char *objectSizeStr, const char *parameter, const Type &baseType );
void OpcodeDelete(const char *Parameter, bool isSweeping);

//Compile_Var.cpp
void SetRelativeOffset( RELATIVE_VAR &relativeVar );
bool _member_offset(bool isErrorEnabled, bool isWriteAccess, const Type &classType, const char *member, RELATIVE_VAR *pRelativeVar, Type &resultType, BOOL bPrivateAccess);
void SetThisPtrToReg(int reg);
bool GetVarOffset(bool isErrorEnabled,bool isWriteAccess,const char *NameBuffer,RELATIVE_VAR *pRelativeVar,Type &resultType, Subscripts *pResultSubscripts = NULL );
bool SetInitGlobalData(int offset,const Type &type,const Subscripts &subscripts,const char *InitBuf);
#define DIMFLAG_INITDEBUGVAR			1
#define DIMFLAG_NONCALL_CONSTRACTOR		2
#define DIMFLAG_STATIC					4
#define DIMFLAG_CONST					8
void dim( char *VarName, const Subscripts &subscripts, const Type &type, const char *InitBuf,const char *ConstractParameter,DWORD dwFlags);
void SetVarPtrToEax(RELATIVE_VAR *pRelativeVar);
void SetVarPtrToReg(int reg,RELATIVE_VAR *pRelativeVar);
bool Compile_AddGlobalRootsForGc();

//ParamImpl.cpp
class ParamImpl{
	char *Parms[255];
	Types types;
	int ParmsNum;

	Type leftType;
	Type returnType;

	//ꎞIuWFNgǗp
	bool useTempObject;
	bool useTempParameters[255];
	bool isNeedFreeStructures[255];
	int nCountOfTempObjects;

public:
	ParamImpl(const char *buffer);
	ParamImpl(const Parameters &params);
	~ParamImpl();
	void SetLeftType( const Type &type )
	{
		this->leftType = type;
	}
	void SetReturnType( const Type &returnType );

private:
	bool EvaluateOverloadScore( int level, const Parameters &targetParms, const Type &targetResultType, const Type &leftType, const UserProc &userProc, bool &isErrored );
public:
	const UserProc *_OverloadSolution( const char *name, std::vector<const UserProc *> &subs, const Type &leftType, bool isEnabledReturnType );
	const UserProc *OverloadSolution( const char *name, std::vector<const UserProc *> &subs, const Type &leftType, bool isEnabledReturnType = false );

	void ApplyDefaultParameters( const Parameters &params );
	bool ErrorCheck( const std::string &procName, const Parameters &params, int SecondParmNum = -1 );
	void MacroParameterSupport( const Parameters &params );
	void SetStructParameter( const Type &baseType, const char *expression );
	int SetParameter( const std::string &procName, const Parameters &params, int SecondParmNum = -1, const UserProc *pUserProc = NULL );

	//ꎞIuWFNgp[^̐Ɣj
	int NewTempParameters( const std::string &procName, const Parameters &params, int SecondParmNum = -1 );
	void DeleteTempParameters();

private:
	ParamImpl(ParamImpl const&);
	ParamImpl& operator =(ParamImpl const&);
};

//Compile_CallProc.cpp
#define PROCFLAG_NEW				1
#define PROCFLAG_PERMIT_CONSTRUCTOR	2
#define PROCFLAG_PERMIT_DESTRUCTOR	4
bool Opcode_CallProcPtr( const char *variable, const char *lpszParms,ProcPointer *pProcPointer);
bool Opcode_CallProc(const char *Parameter,const UserProc *pUserProc,DWORD dwFlags,const char *ObjectName );
bool Opcode_CallDllProc( const char *lpszParms, const DllProc *pDllProc );
void Opcode_CallDelegate( const Delegate &dg, const char *methodPtrValueStr, const char *objPtrValueStr, const char *params );

//Compile_ProcOp.cpp
void _compile_proc(const UserProc *pUserProc);

//Compile_Func.cpp
int GetFunctionFromName(char *FuncName);
bool Opcode_CallFunc( const char *Parameter, const int FuncNum, const Type &baseType, Type &resultType, bool isCallOn = true );

//OperatorProc.cpp
void FreeTempObject(int reg,const CClass *pobj_c);
int CallOperatorProc(int idCalc, const Type &baseType, int *type_stack, LONG_PTR *index_stack,bool isNeedHeapFreeStructureStack[],int &sp);
void CallCastOperatorProc(Type &calcType,BOOL bCalcUseHeap,const Type &toType);
void CallIndexerGetterProc( const Type &classType, const char *ObjectName, char *Parameter,Type &resultType, DWORD dwProcFlags = 0 );

//Compile_Statement.cpp
void OpcodeOthers( const char *Command );
void OpcodeIf(char *Parameter);
void OpcodeGoto(char *Parameter);
void OpcodeWhile(char *Parameter);
void OpcodeFor(char *Parameter);
void OpcodeForeach( const char *Parameter );
void OpcodeDo(char *Parameter);
void OpcodeContinue(void);
void OpcodeExitSub(void);
void OpcodeSelect(const char *lpszParms);
void OpcodeCase(char *Parameter);
void OpcodeGosub(char *Parameter);
void OpcodeReturn(char *Parameter);
void OpcodeSetPtrData(char *Parameter,int type);




//op32_main.cpp
BOOL IsSafeReg(int reg);
