#include "stdafx.h"
#include <uxtheme.h>

DWORD const PROCESS_DEP_ENABLE = 0x00000001;

std::string ActiveBasic::Common::Environment::rootPath;
bool ActiveBasic::Common::Environment::isRemoveExternal = false;

using namespace ActiveBasic::Common;

void Environment::SetAbdevRootPath( const std::string &rootPath )
{
	Environment::rootPath = Jenga::Common::Path::MakeFullPath( rootPath, Jenga::Common::Environment::GetAppDir() );
}
const std::string Environment::GetAbdevRootPath()
{
	if( rootPath.empty() )
	{
		SetAbdevRootPath( "" );
	}
	return rootPath;
}

const std::string Environment::GetUserAppDir()
{
	return Jenga::Common::Environment::GetUserAppDir() + "\\ActiveBasic";
}

const std::string Environment::GetCompilerExePath( Platform::EnumType platform )
{
	switch( platform )
	{
	case Platform::X86:
		return rootPath + "\\bin\\x86\\abc.exe";
	case Platform::X64:
		return rootPath + "\\bin\\x64\\abc.exe";
	}
	throw;
}

void* operator new( std::size_t n )
{
	if ( void* p = dlmalloc(n) ){
		return p;
	}
	else{
		throw std::bad_alloc();
	}
}

void* operator new[]( std::size_t n )
{
	return ::operator new( n );
}

void operator delete( void* p )
{
	dlfree( p );
}

void operator delete[]( void* p )
{
	::operator delete( p );
}

typedef HRESULT (WINAPI* PFN_EnableThemeDialogTexture)(HWND, DWORD);

HMODULE hmodUxTheme = LoadLibrary("uxtheme");

HRESULT ApplyDialogTexture( HWND hwnd )
{
	if( hmodUxTheme )
	{
		if( PFN_EnableThemeDialogTexture pfn = reinterpret_cast<PFN_EnableThemeDialogTexture>(
			GetProcAddress(hmodUxTheme, "EnableThemeDialogTexture")) )
		{
			return pfn(hwnd, ETDT_ENABLETAB);
		}
	}
	return E_NOTIMPL;
}

BOOL ActiveBasic::Common::EnableNX()
{
	typedef BOOL (WINAPI* PFNSETDEP)(DWORD);

	HMODULE hmodKernel = GetModuleHandle(TEXT("KERNEL32.DLL"));
	if (PFNSETDEP pfnSetDEP = reinterpret_cast<PFNSETDEP>(GetProcAddress(hmodKernel, "SetProcessDEPPolicy")))
	{
		return pfnSetDEP(PROCESS_DEP_ENABLE);
	}
	else
	{
		return FALSE;
	}
}

void ActiveBasic::Common::SetHeapOptions()
{
//	SetDllDirectory(_T(""));
	HMODULE hmodKernel = GetModuleHandle(TEXT("KERNEL32.DLL"));

	typedef BOOL (WINAPI* HSI)(HANDLE, HEAP_INFORMATION_CLASS ,PVOID, SIZE_T);
	HSI pHsi = reinterpret_cast<HSI>(GetProcAddress(hmodKernel, "HeapSetInformation"));
	if (!pHsi)
	{
		return;
	}

	ULONG enableLFH = 2;
	pHsi(GetProcessHeap(), HeapCompatibilityInformation, &enableLFH, sizeof enableLFH);

#ifndef HeapEnableTerminationOnCorruption
#	define HeapEnableTerminationOnCorruption (HEAP_INFORMATION_CLASS)1
#endif

	pHsi(NULL, HeapEnableTerminationOnCorruption, NULL, 0);
}
