#include "stdafx.h"
#include <boost/numeric/conversion/cast.hpp>
#include <boost/algorithm/string/replace.hpp>

using boost::numeric_cast;
using boost::implicit_cast;

bool Jenga::Common::IsExistString(const Jenga::Common::Strings &strings, const std::string &findStr)
{
	return boost::find(strings, findStr) != strings.end();
}

std::string& Jenga::Common::StringReplace(std::string& str, const std::string &sb, const std::string &sa)
{
	boost::algorithm::replace_all(str, sb, sa);
	return str;
}

std::string Jenga::Common::ToString(int n)
{
	// VC++ 2010Ƃ̃LXgKvB
	return std::to_string(implicit_cast<long long>(n));
}

std::string Jenga::Common::ToString( const std::wstring &wstr )
{
	if (wstr.empty())
	{
		return std::string();
	}
	int srcSize = numeric_cast<int>(wstr.size());
	int needSize = WideCharToMultiByte(
		CP_ACP,
		0,
		wstr.data(), srcSize,
		nullptr, 0,
		nullptr, nullptr);
	if (needSize <= 0)
	{
		throw std::runtime_error("WideCharToMultiByte error");
	}

	std::string ret(needSize, '\0');
	int res = WideCharToMultiByte(
		CP_ACP,
		0,
		wstr.data(), srcSize,
		&ret[0], needSize,
		nullptr, nullptr);
	if (res <= 0)
	{
		throw std::runtime_error("WideCharToMultiByte error");
	}

	return ret;
}

std::wstring Jenga::Common::ToWString(const std::string &str)
{
	if (str.empty())
	{
		return std::wstring();
	}
	int srcSize = numeric_cast<int>(str.size());
	int needSize = MultiByteToWideChar(
		CP_ACP,
		0,
		str.data(), srcSize,
		nullptr, 0);
	if (needSize <= 0)
	{
		throw std::runtime_error("WideCharToMultiByte error");
	}

	std::wstring ret(needSize, L'\0');
	int res = MultiByteToWideChar(
		CP_ACP,
		0,
		str.data(), srcSize,
		&ret[0], needSize);
	if (res <= 0)
	{
		throw std::runtime_error("WideCharToMultiByte error");
	}

	return ret;
}

bool Jenga::Common::IsIdentifierTopChar( char c )
{
	return ('A' <= c && c <= 'Z')
		|| ('a' <= c && c <= 'z')
		|| c == '_' ;
}

bool Jenga::Common::IsIdentifierChar( char c )
{
	return IsIdentifierTopChar(c)
		|| ('0' <= c && c <= '9');
}
