#pragma once

#include <boost/shared_ptr.hpp>

//TCYύXg̑
#define LEVER_THICK 5

#define WM_SHOWERROR			WM_USER+70	//G[\bZ[W

#define WM_SETCOMPILEVIEW		WM_USER+71	//RpCEBhE\ꂽƂ
#define WM_DESTROYCOMPILEVIEW	WM_USER+72	//RpCEBhEjꂽƂ

#define WM_SETDEBUGGERBASE		WM_USER+73	//fobKx[XEBhE\ꂽƂ
#define WM_DESTROYDEBUGGERBASE	WM_USER+74	//fobKx[XEBhEjꂽƂ

#define WM_SETDEBUGGERVIEW		WM_USER+75	//fobKEBhE\ꂽƂ
#define WM_DESTROYDEBUGGERVIEW	WM_USER+76	//fobKEBhE\ꂽƂ

class TaskbarList;

namespace ActiveBasic{ namespace IDE{


class MainFrame
	: public WindowComponents::MdiWindow
{
	WindowAreaManager wam;
	UINT TaskbarButtonCreated;
	boost::shared_ptr<TaskbarList> taskbarList;

public:
	MainFrame();

	// TCỸtbV
	void Resized();

	// WebuEUURLJ
	void OpenWebBrowser( const std::string &url );

	// ExplorerŃpXJ
	void OpenExplorer( const std::string &filepath );

	// ꂽ
	::LRESULT OnCreate( ::CREATESTRUCT const* );

	// OSI
	BOOL OnQueryEndSession(UINT nSource, UINT uLogOff);

	// uv{^NbNꂽ
	void OnClose();

	// TCYꂽ
	void OnSize(UINT nType, CSize size);

	// jꂽ
	void OnDestroy();

	// ^C}[Cxg
	void OnTimer( UINT_PTR id );

	// Nbv{[h̃f[^ύX
	void OnDrawClipboard();

	// j[Iꂽ
	void OnMenuSelect( UINT nItemID, UINT nFlags, HMENU menu );

	// j[ANeBuɂȂ钼Oɑ
	void OnInitMenu( HMENU menu );

	// j[ACẽTCYvꂽ
	void OnMeasureItem( int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct );

	// j[ACe̕`悪vꂽ
	void OnDrawItem( int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct );

	// gRg[烁bZ[Wʒmꂽ
	LRESULT OnNotify( int idCtrl, LPNMHDR pnmh );

	// t@Chbvꂽ
	void OnDropFiles( HDROP hDropInfo );

	// ĕ`
	void OnPaint( HDC dummy );

	// \[XR[h\bZ[W
	::LRESULT OnShowSourceLine( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, ::BOOL& handled );

	// ^XNo[{^ꂽ
	::LRESULT OnTaskbarButtonCreated(::UINT msg, ::WPARAM wParam, ::LPARAM lParam);

	// qEBhEꂽ
	void AddChildWindow( HWND hwndChild );

	// qEBhEjꂽ
	void DeleteChildWindow( HWND hwndChild );

	// qEBhEANeBuɂȂ
	void ActivateChildWindow( HWND hwndChild );

	// ^ȕύXɂȂ
	void SetTabOrder( HWND hwndChild, HWND hwndInsertBefore );

	// TlC摜ÂȂîōXVj
	void InvalidateBitmap( HWND hwndChild );

	// uVK쐬vj[NbNꂽ
	void OnCmdNew( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uJvj[NbNꂽ
	void OnCmdOpen( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uvj[NbNꂽ
	void OnCmdClose( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uvWFNgJvj[NbNꂽ
	void OnCmdProjectOpen( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uvWFNgۑvj[NbNꂽ
	void OnCmdProjectSave( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uvWFNgvj[NbNꂽ
	void OnCmdProjectClose( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uvWFNg tH_Jvj[NbNꂽ
	void OnCmdProjectFolderOpen( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uۑvj[NbNꂽ
	void OnCmdSave( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uOtĕۑvj[NbNꂽ
	void OnCmdNewSave( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uR[hw肵ĕۑvj[NbNꂽ
	void OnCmdCodeSave( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uׂĕۑvj[NbNꂽ
	void OnCmdAllSave( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uy[Wݒvj[NbNꂽ
	void OnCmdPageSet( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uvr[vj[NbNꂽ
	void OnCmdPreview( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uvj[NbNꂽ
	void OnCmdPrintOut( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uIvj[NbNꂽ
	void OnCmdExit( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uɖ߂vj[NbNꂽ
	void OnCmdUndo( UINT uNotifyCode, int nID, CWindow wndCtl );

	// u蒼vj[NbNꂽ
	void OnCmdRedo( UINT uNotifyCode, int nID, CWindow wndCtl );

	// u؂vj[NbNꂽ
	void OnCmdCut( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uRs[vj[NbNꂽ
	void OnCmdCopy( UINT uNotifyCode, int nID, CWindow wndCtl );

	// u\tvj[NbNꂽ
	void OnCmdPaste( UINT uNotifyCode, int nID, CWindow wndCtl );

	// u폜vj[NbNꂽ
	void OnCmdDelete( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uׂđIvj[NbNꂽ
	void OnCmdAllSelect( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uvj[NbNꂽ
	void OnCmdFind( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uuvj[NbNꂽ
	void OnCmdPermutation( UINT uNotifyCode, int nID, CWindow wndCtl );

	// ϊj[̂ꂩNbNꂽ
	void OnCmdConvertX( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uJEgvj[NbNꂽ
	void OnCmdStringCount( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uI͈͂̕JEgvj[NbNꂽ
	void OnCmdSelStringCount( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uvWFNgr[vj[NbNꂽ
	void OnCmdProjectView( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uvWFNgIvVvj[NbNꂽ
	void OnCmdProjectOption( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uőOʕ\vj[NbNꂽ
	void OnCmdTopMost( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uE[Ő܂Ԃvj[NbNꂽ
	void OnCmdRightTurn( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uIvVvj[NbNꂽ
	void OnCmdSet( UINT uNotifyCode, int nID, CWindow wndCtl );

	// ufobOsvj[NbNꂽ
	void OnCmdDebug( UINT uNotifyCode, int nID, CWindow wndCtl );

	// ufobOrhvj[NbNꂽ
	void OnCmdDebugCompile( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uA^b`vj[NbNꂽ
	void OnCmdAttach( UINT uNotifyCode, int nID, CWindow wndCtl );

	// u[Xrhvj[NbNꂽ
	void OnCmdReleaseCompile( UINT uNotifyCode, int nID, CWindow wndCtl );

	// u[Xsvj[NbNꂽ
	void OnCmdReleaseRun( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uXebvCvj[NbNꂽ
	void OnCmdStepIn( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uXebvI[o[vj[NbNꂽ
	void OnCmdStepOver( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uJ[\s܂Ŏsvj[NbNꂽ
	void OnCmdStepCursor( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uu[N|Cgvj[NbNꂽ
	void OnCmdBreakPoint( UINT uNotifyCode, int nID, CWindow wndCtl );

	// ufobO̒~vj[NbNꂽ
	void OnCmdDebugStop( UINT uNotifyCode, int nID, CWindow wndCtl );

	// ufobÖꎞ~vj[NbNꂽ
	void OnCmdDebugPause( UINT uNotifyCode, int nID, CWindow wndCtl );

	// WebNj[NbNꂽ
	void OnCmdWebLink( UINT uNotifyCode, int nID, CWindow wndCtl );

	// ugsbNXvj[NbNꂽ
	void OnCmdTopics( UINT uNotifyCode, int nID, CWindow wndCtl );

	// uo[Wvj[NbNꂽ
	void OnCmdAbout( UINT uNotifyCode, int nID, CWindow wndCtl );

	// o[́uhLgZNgvj[NbNꂽ
	void OnCmdDocSelectBand( UINT uNotifyCode, int nID, CWindow wndCtl );

	// o[́uWvj[NbNꂽ
	void OnCmdStandardBand( UINT uNotifyCode, int nID, CWindow wndCtl );

	// o[́u[Xvj[NbNꂽ
	void OnCmdReleaseBand( UINT uNotifyCode, int nID, CWindow wndCtl );

	// o[́ufobOvj[NbNꂽ
	void OnCmdDebugBand( UINT uNotifyCode, int nID, CWindow wndCtl );

	// o[́uvbgtH[Ivj[NbNꂽ
	void OnCmdSelectCompilerBand( UINT uNotifyCode, int nID, CWindow wndCtl );

	// o[́uo[Œvj[NbNꂽ
	void OnCmdNoGripper( UINT uNotifyCode, int nID, CWindow wndCtl );

	// o[́uo[Zbgvj[NbNꂽ
	void OnCmdResetRebar( UINT uNotifyCode, int nID, CWindow wndCtl );

	// ^úuȊÕEBhEvj[NbNꂽ
	void OnCmdAllCloseOmitMyself( UINT uNotifyCode, int nID, CWindow wndCtl );

	// ^úu΃pXRs[vj[NbNꂽ
	void OnCmdPathCopy( UINT uNotifyCode, int nID, CWindow wndCtl );

	// ^úutH_Jvj[NbNꂽ
	void OnCmdFolderOpen( UINT uNotifyCode, int nID, CWindow wndCtl );

	// ^úut@C폜vj[NbNꂽ
	void OnCmdDeleteFile( UINT uNotifyCode, int nID, CWindow wndCtl );

	// ^úu^u̐Fvj[NbNꂽ
	void OnCmdColor( UINT uNotifyCode, int nID, CWindow wndCtl );

private:
	// bZ[W}bv
	BEGIN_MSG_MAP( MainFrame )
		MSG_WM_CREATE( OnCreate )
		MSG_WM_SIZE( OnSize )
		MSG_WM_QUERYENDSESSION( OnQueryEndSession )
		MSG_WM_CLOSE( OnClose )
		MSG_WM_DESTROY( OnDestroy )
		MSG_WM_TIMER( OnTimer )
		MSG_WM_DRAWCLIPBOARD( OnDrawClipboard )
		MSG_WM_MENUSELECT( OnMenuSelect )
		MSG_WM_INITMENU( OnInitMenu )
		MSG_WM_MEASUREITEM( OnMeasureItem )
		MSG_WM_DRAWITEM( OnDrawItem )
		MSG_WM_NOTIFY( OnNotify );
		MSG_WM_DROPFILES( OnDropFiles )
		MSG_WM_PAINT( OnPaint )
		MESSAGE_HANDLER( WM_SHOWERROR, OnShowSourceLine )	
		MESSAGE_HANDLER_EX( TaskbarButtonCreated, OnTaskbarButtonCreated )
		COMMAND_ID_HANDLER_EX( IDM_NEW, OnCmdNew )
		COMMAND_ID_HANDLER_EX( IDM_OPEN, OnCmdOpen )
		COMMAND_ID_HANDLER_EX( IDM_CLOSE, OnCmdClose )
#ifndef THETEXT
		COMMAND_ID_HANDLER_EX( IDM_PROJECT_OPEN, OnCmdProjectOpen )
		COMMAND_ID_HANDLER_EX( IDM_PROJECT_SAVE, OnCmdProjectSave )
		COMMAND_ID_HANDLER_EX( IDM_PROJECT_CLOSE, OnCmdProjectClose )
		COMMAND_ID_HANDLER_EX( IDM_PROJECT_FOLDER_OPEN, OnCmdProjectFolderOpen )
#endif
		COMMAND_ID_HANDLER_EX( IDM_SAVE, OnCmdSave )
		COMMAND_ID_HANDLER_EX( IDM_NEWSAVE, OnCmdNewSave )
		COMMAND_ID_HANDLER_EX( IDM_CODE_SAVE, OnCmdCodeSave )
		COMMAND_ID_HANDLER_EX( IDM_ALLSAVE, OnCmdAllSave )
		COMMAND_ID_HANDLER_EX( IDM_PAGESET, OnCmdPageSet )
		COMMAND_ID_HANDLER_EX( IDM_PREVIEW, OnCmdPreview )
		COMMAND_ID_HANDLER_EX( IDM_PRINTOUT, OnCmdPrintOut )
		COMMAND_ID_HANDLER_EX( IDM_EXIT, OnCmdExit )
		COMMAND_ID_HANDLER_EX( IDM_UNDO, OnCmdUndo )
		COMMAND_ID_HANDLER_EX( (WORD)IDM_ACCEL_UNDO, OnCmdUndo )
		COMMAND_ID_HANDLER_EX( IDM_REDO, OnCmdRedo )
		COMMAND_ID_HANDLER_EX( (WORD)IDM_ACCEL_REDO, OnCmdRedo )
		COMMAND_ID_HANDLER_EX( IDM_CUT, OnCmdCut )
		COMMAND_ID_HANDLER_EX( IDM_COPY, OnCmdCopy )
		COMMAND_ID_HANDLER_EX( IDM_PASTE, OnCmdPaste )
		COMMAND_ID_HANDLER_EX( IDM_DELETE, OnCmdDelete )
		COMMAND_ID_HANDLER_EX( IDM_ALLSELECT, OnCmdAllSelect )
		COMMAND_ID_HANDLER_EX( IDM_FIND, OnCmdFind )
		COMMAND_ID_HANDLER_EX( IDM_PERMUTATION, OnCmdPermutation )
		COMMAND_ID_HANDLER_EX( IDM_CONV_ALPHA_SMALL, OnCmdConvertX )
		COMMAND_ID_HANDLER_EX( IDM_CONV_ALPHA_BIG, OnCmdConvertX )
		COMMAND_ID_HANDLER_EX( IDM_CONV_HALF, OnCmdConvertX )
		COMMAND_ID_HANDLER_EX( IDM_CONV_MULTI, OnCmdConvertX )
		COMMAND_ID_HANDLER_EX( IDM_CONV_KATAKANA, OnCmdConvertX )
		COMMAND_ID_HANDLER_EX( IDM_CONV_HIRAGANA, OnCmdConvertX )
		COMMAND_ID_HANDLER_EX( IDM_CONV_SPACE, OnCmdConvertX )
		COMMAND_ID_HANDLER_EX( IDM_CONV_TAB, OnCmdConvertX )
#ifdef THETEXT
		COMMAND_ID_HANDLER_EX( IDM_CONV_HASRETURN, OnCmdConvertX )
		COMMAND_ID_HANDLER_EX( IDM_CONV_QUOTE, OnCmdConvertX )
		COMMAND_ID_HANDLER_EX( IDM_STRING_COUNT, OnCmdStringCount )
		COMMAND_ID_HANDLER_EX( IDM_SEL_STRING_COUNT, OnCmdSelStringCount )
#else
		COMMAND_ID_HANDLER_EX( IDM_CODEFORMAT, OnCmdConvertX )
#endif
		COMMAND_ID_HANDLER_EX( IDM_PROJECTVIEW, OnCmdProjectView )
		COMMAND_ID_HANDLER_EX( IDM_PROJECT_OPTION, OnCmdProjectOption )
		COMMAND_ID_HANDLER_EX( IDM_TOPMOST, OnCmdTopMost )
#ifdef THETEXT
		COMMAND_ID_HANDLER_EX( IDM_RIGHT_TURN, OnCmdRightTurn )
#endif
		COMMAND_ID_HANDLER_EX( IDM_SET, OnCmdSet )
#ifndef THETEXT
		COMMAND_ID_HANDLER_EX( IDM_DEBUG, OnCmdDebug )
		COMMAND_ID_HANDLER_EX( IDM_DEBUGCOMPILE, OnCmdDebugCompile )
		COMMAND_ID_HANDLER_EX( IDM_ATTACH, OnCmdAttach )
		COMMAND_ID_HANDLER_EX( IDM_RELEASECOMPILE, OnCmdReleaseCompile )
		COMMAND_ID_HANDLER_EX( IDM_RELEASERUN, OnCmdReleaseRun )
		COMMAND_ID_HANDLER_EX( IDM_STEP_IN, OnCmdStepIn )
		COMMAND_ID_HANDLER_EX( IDM_STEP_OVER, OnCmdStepOver )
		COMMAND_ID_HANDLER_EX( IDM_STEP_CURSOR, OnCmdStepCursor )
		COMMAND_ID_HANDLER_EX( IDM_BREAKPOINT, OnCmdBreakPoint )
		COMMAND_ID_HANDLER_EX( IDM_DEBUG_STOP, OnCmdDebugStop )
		COMMAND_ID_HANDLER_EX( IDM_DEBUG_PAUSE, OnCmdDebugPause )
		COMMAND_ID_HANDLER_EX( IDM_COMMUNITY, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( IDM_COMMU_SEARCH, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( IDM_COMMU_PM, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( ID_COMMU_FORUM1, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( ID_COMMU_FORUM2, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( ID_COMMU_FORUM3, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( ID_COMMU_FORUM4, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( ID_COMMU_FORUM5, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( ID_COMMU_FORUM6, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( ID_COMMU_FORUM7, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( ID_COMMU_FORUM8, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( IDM_AB_WEBSITE, OnCmdWebLink )
		COMMAND_ID_HANDLER_EX( IDM_ACTBDL, OnCmdWebLink )
#else
		COMMAND_ID_HANDLER_EX( IDM_DSHOMEPAGE, OnCmdWebLink )
#endif
		COMMAND_ID_HANDLER_EX( IDM_TOPIC, OnCmdTopics )
		COMMAND_ID_HANDLER_EX( IDM_ABOUT, OnCmdAbout )
		COMMAND_ID_HANDLER_EX( IDM_DOCSELECTBAND, OnCmdDocSelectBand )
		COMMAND_ID_HANDLER_EX( IDM_STANDARDBAND, OnCmdStandardBand )
#ifndef THETEXT
		COMMAND_ID_HANDLER_EX( IDM_RELEASEBAND, OnCmdReleaseBand )
		COMMAND_ID_HANDLER_EX( IDM_DEBUGBAND, OnCmdDebugBand )
		COMMAND_ID_HANDLER_EX( IDM_SELECTCOMPILERBAND, OnCmdSelectCompilerBand )
#endif
		COMMAND_ID_HANDLER_EX( IDM_NOGRIPPER, OnCmdNoGripper )
		COMMAND_ID_HANDLER_EX( IDM_RESET_REBAR, OnCmdResetRebar )
		COMMAND_ID_HANDLER_EX( IDM_ALLCLOSE_OMIT_MYSELF, OnCmdAllCloseOmitMyself )
		COMMAND_ID_HANDLER_EX( IDM_PATH_COPY, OnCmdPathCopy )
		COMMAND_ID_HANDLER_EX( IDM_FOLDER_OPEN, OnCmdFolderOpen )
		COMMAND_ID_HANDLER_EX( IDM_DELETE_FILE, OnCmdDeleteFile )
		COMMAND_ID_HANDLER_EX( IDM_USER_COLOR, OnCmdColor )
		COMMAND_ID_HANDLER_EX( IDM_GRAY, OnCmdColor )
		COMMAND_ID_HANDLER_EX( IDM_WHITE, OnCmdColor )
		COMMAND_ID_HANDLER_EX( IDM_RED, OnCmdColor )
		COMMAND_ID_HANDLER_EX( IDM_GREEN, OnCmdColor )
		COMMAND_ID_HANDLER_EX( IDM_BLUE, OnCmdColor )
		COMMAND_ID_HANDLER_EX( IDM_YELLOW, OnCmdColor )

		CHAIN_MSG_MAP(CUpdateUI<WindowComponents::MdiWindow>)
        CHAIN_MSG_MAP(CMDIFrameWindowImpl<WindowComponents::MdiWindow>)
	END_MSG_MAP()
};


}}
