/**
@file jenga.cpp

@brief jengavWFNg̃R[hɑ΂eXgB
*/


#include "stdafx.h"

#include <boost/assign.hpp>
#include <jenga/include/jenga.h>

using namespace boost::assign;
using namespace Jenga::Common;

/**
@breif Jenga/Common/String.h̊֐Ȃǂɑ΂eXgB
*/
BOOST_AUTO_TEST_CASE( JengaCommonString )
{
	std::vector<std::string> v;
	v += "ABC", "def", "123";

	BOOST_CHECK(IsExistString(v, "123"));
	BOOST_CHECK(!IsExistString(v, "abc"));

	std::string s = "Dete koi dete koi ike no koi";
	StringReplace(s, "koi", "ike");
	BOOST_CHECK_EQUAL(s, "Dete ike dete ike ike no ike");

	BOOST_CHECK_EQUAL(ToString(42), "42");
	BOOST_CHECK_EQUAL(ToString(-7), "-7");

	BOOST_CHECK_EQUAL(ToString(std::wstring(L"ABC123")), "ABC123");

	BOOST_CHECK(ToWString(std::string("ABC123")) == L"ABC123");

	BOOST_CHECK(IsIdentifierTopChar('a'));
	BOOST_CHECK(IsIdentifierTopChar('z'));
	BOOST_CHECK(IsIdentifierTopChar('A'));
	BOOST_CHECK(IsIdentifierTopChar('Z'));
	BOOST_CHECK(IsIdentifierTopChar('_'));
	BOOST_CHECK(IsIdentifierChar('a'));
	BOOST_CHECK(IsIdentifierChar('z'));
	BOOST_CHECK(IsIdentifierChar('A'));
	BOOST_CHECK(IsIdentifierChar('Z'));
	BOOST_CHECK(IsIdentifierChar('_'));
	BOOST_CHECK(IsIdentifierChar('0'));
	BOOST_CHECK(IsIdentifierChar('9'));
}
