#include <string>
#include <windows.h>
#include <shlobj.h>

#pragma once

namespace Jenga{
namespace Common{


class Environment
{
public:
	static const std::string GetCurrentDir()
	{
		char temp[MAX_PATH];
		::GetCurrentDirectory( MAX_PATH, temp );
		return temp;
	}

	static const std::string &GetAppDir()
	{
		static std::string appDir;
		if( appDir.empty() )
		{
			char temporary[MAX_PATH];
			char temp2[MAX_PATH];
			char temp3[MAX_PATH];
			GetModuleFileName(GetModuleHandle(0),temporary,MAX_PATH);
			_splitpath(temporary,temp2,temp3,NULL,NULL);
			if( temp3[lstrlen(temp3)-1]=='\\' )
			{
				temp3[lstrlen(temp3)-1] = 0;
			}
			lstrcat(temp2,temp3);

			appDir = temp2;
		}
		return appDir;
	}

	static const std::string &GetAppFileName()
	{
		static std::string appFileName;
		if( appFileName.empty() )
		{
			char temporary[MAX_PATH];
			char temp2[MAX_PATH];
			char temp3[MAX_PATH];
			GetModuleFileName(GetModuleHandle(0),temporary,MAX_PATH);
			_splitpath(temporary,NULL,NULL,temp2,temp3);
			lstrcat(temp2,temp3);

			appFileName = temp2;
		}
		return appFileName;
	}

	static const std::string &GetAppFilePath()
	{
		static std::string appFilePath;
		if( appFilePath.empty() )
		{
			char temporary[MAX_PATH];
			GetModuleFileName(GetModuleHandle(0),temporary,MAX_PATH);

			appFilePath = temporary;
		}
		return appFilePath;
	}

	static const std::string &GetUserAppDir()
	{
		static std::string userAppDir;
		if( userAppDir.empty() )
		{
			char szDirPath[MAX_PATH];
			if( SHGetSpecialFolderPath( NULL, szDirPath, CSIDL_APPDATA, TRUE ) == FALSE )
			{
				throw;
			}
			userAppDir = szDirPath;

			if( userAppDir[userAppDir.size()-1] == '\\' )
			{
				userAppDir = userAppDir.substr( 0, userAppDir.size() - 1 );
			}
		}

		return userAppDir;
	}
};


}}
