#include <string>

#pragma once

namespace Jenga{
namespace Common{


class CmdLine{
	std::string command;
	std::string parameter;
public:

	CmdLine( const std::string &command, const std::string &parameter )
		: command( command )
		, parameter( parameter )
	{
	}

	bool IsNamelessCommand() const
	{
		return ( command.size() == 0 );
	}
	const std::string& GetCommand() const
	{
		return command;
	}
	const std::string& GetParameter() const
	{
		return parameter;
	}
};

class CmdLines : public std::vector<CmdLine>
{
public:
	CmdLines( const std::string &strCmdLine );
	bool IsExist( const std::string &commandString ) const;
};


}}
