#pragma once

class EnumMember
{
	std::string name;
	std::string value;
	int sourceIndex;

public:
	EnumMember( const std::string &name, const std::string &value, int sourceIndex )
		: name( name )
		, value( value )
		, sourceIndex( sourceIndex )
	{
	}

	EnumMember(EnumMember&& y)
		: name(std::move(y.name))
		, value(std::move(y.value))
		, sourceIndex(std::move(y.sourceIndex))
	{
	}

	EnumMember(EnumMember const& y)
		: name(y.name)
		, value(y.value)
		, sourceIndex(y.sourceIndex)
	{
	}

	EnumMember& operator =(EnumMember&& y)
	{
		name = std::move(y.name);
		value = std::move(y.value);
		sourceIndex = std::move(y.sourceIndex);
		return *this;
	}

	EnumMember& operator =(EnumMember const& y)
	{
		return *this = std::move(EnumMember(y));
	}

	const std::string &GetName() const
	{
		return name;
	}
	const std::string &GetValueStr() const
	{
		return value;
	}
	int GetSourceIndex() const
	{
		return sourceIndex;
	}
};

class EnumInfo
	: public Symbol
{

	BOOL bConst;

	std::vector<EnumMember> members;
public:

	EnumInfo( const NamespaceScopes &namespaceScopes, const std::string &name )
		: Symbol( namespaceScopes, name )
	{
	}

	EnumInfo(EnumInfo&& y)
		: Symbol(std::move(y))
		, bConst(std::move(y.bConst))
		, members(std::move(y.members))
	{
	}

	EnumInfo(EnumInfo const& y)
		: Symbol(y)
		, bConst(y.bConst)
		, members(y.members)
	{
	}

	EnumInfo& operator =(EnumInfo&& y)
	{
		Symbol::operator =(std::move(y));
		bConst = std::move(y.bConst);
		members = std::move(y.members);
		return *this;
	}

	EnumInfo& operator =(EnumInfo const& y)
	{
		return *this = std::move(EnumInfo(y));
	}

	const std::vector<EnumMember> &GetMembers() const
	{
		return members;
	}

	const EnumMember &GetEnumMember( const std::string &memberName ) const
	{
		foreach( const EnumMember &member, members )
		{
			if( member.GetName() == memberName )
			{
				return member;
			}
		}
		throw;
	}

	std::vector<EnumMember> &GetEnumMembers()
	{
		return members;
	}
};

class EnumInfoCollection
	: public std::vector<EnumInfo>
{
public:
	const EnumInfo *Find( const Symbol &symbol ) const
	{
		const EnumInfoCollection &thisEnumInfoCollection = *this;
		foreach( const EnumInfo &enumInfo, thisEnumInfoCollection )
		{
			if( enumInfo.IsEqualSymbol( symbol ) )
			{
				return &enumInfo;
			}
		}
		return NULL;
	};

	EnumInfoCollection() {}

private:
	EnumInfoCollection(EnumInfoCollection const&);
	EnumInfoCollection& operator =(EnumInfoCollection const&);
};
