#pragma once

class Messenger
{
public:
	void Output( const std::string &message );
	int GetNextErrorLine();
};

class ErrorInfo
{
	int errorCode;
	std::string keyword;
	std::string sourceFilePath;
	int sourceLineNum;
	int errorLineNum;

public:
	ErrorInfo( int errorCode, const std::string &keyword, const std::string &sourceFilePath, int sourceLineNum )
		: errorCode( errorCode )
		, keyword( keyword )
		, sourceFilePath( sourceFilePath )
		, sourceLineNum( sourceLineNum )
	{
	}

	ErrorInfo( int errorCode, const std::string &keyword, int sourceIndex );

	ErrorInfo(ErrorInfo&& y)
		: errorCode(std::move(y.errorCode))
		, keyword(std::move(y.keyword))
		, sourceFilePath(std::move(y.sourceFilePath))
		, sourceLineNum(std::move(y.sourceLineNum))
		, errorLineNum(std::move(y.errorLineNum))
	{
	}

	ErrorInfo(ErrorInfo const& y)
		: errorCode(y.errorCode)
		, keyword(y.keyword)
		, sourceFilePath(y.sourceFilePath)
		, sourceLineNum(y.sourceLineNum)
		, errorLineNum(y.errorLineNum)
	{
	}

	ErrorInfo& operator =(ErrorInfo&& y)
	{
		errorCode = std::move(y.errorCode);
		keyword = std::move(y.keyword);
		sourceFilePath = std::move(y.sourceFilePath);
		sourceLineNum = std::move(y.sourceLineNum);
		errorLineNum = std::move(y.errorLineNum);
		return *this;
	}

	ErrorInfo& operator =(ErrorInfo const& y)
	{
		return *this = std::move(ErrorInfo(y));
	}

	int GetErrorCode() const
	{
		return errorCode;
	}
	bool IsWarning() const
	{
		return ( errorCode < -100 );
	}
	const std::string &GetKeyword() const
	{
		return keyword;
	}
	const std::string &GetSourceFilePath() const
	{
		return sourceFilePath;
	}
	int GetSourceLineNum() const
	{
		return sourceLineNum;
	}
	int GetErrorLineNum() const
	{
		return errorLineNum;
	}

	std::string GetMessageString() const;
	std::string GetFullMessageString() const;
};
typedef std::vector<ErrorInfo> ErrorInfos;

class ErrorMessenger
	: public Messenger
{
	ErrorInfos errorInfos;
	Jenga::Common::Strings synonymKeyWords;

public:
	ErrorMessenger() {}

	void Output( const ErrorInfo &errorInfo );
	void Output( int errorCode, const std::string &keyword, int sourceIndex = -1 );
	void Output( int errorCode, const char *keyword, int sourceIndex = -1 );
	void OutputFatalError();

	void ClearSynonymKeyWords();

	int GetErrorCount() const;
	bool HasError() const;
	int GetWarningCount() const;

	void ShowErrorLine( int errorLineNum );

private:
	ErrorMessenger(ErrorMessenger const&);
	ErrorMessenger& operator =(ErrorMessenger const&);
};
