#pragma once

namespace ActiveBasic{ namespace Common{ namespace Lexical{


class ResolveError
{
	int relationalObjectModuleIndex;
	std::string targetItemName;
public:
	ResolveError( int relationalObjectModuleIndex, const std::string targetItemName )
		: relationalObjectModuleIndex( relationalObjectModuleIndex )
		, targetItemName( targetItemName )
	{
	}

	ResolveError(ResolveError&& y)
		: relationalObjectModuleIndex(std::move(y.relationalObjectModuleIndex))
		, targetItemName(std::move(y.targetItemName))
	{
	}

	ResolveError(ResolveError const& y)
		: relationalObjectModuleIndex(y.relationalObjectModuleIndex)
		, targetItemName(y.targetItemName)
	{
	}

	ResolveError& operator =(ResolveError&& y)
	{
		relationalObjectModuleIndex = std::move(y.relationalObjectModuleIndex);
		targetItemName = std::move(y.targetItemName);
		return *this;
	}

	ResolveError& operator =(ResolveError const& y)
	{
		return *this = std::move(ResolveError(y));
	}

	int GetRelationalObjectModuleIndex() const
	{
		return relationalObjectModuleIndex;
	}
	const std::string &GetTargetItemName() const
	{
		return targetItemName;
	}
};
class ResolveErrors
	: public std::vector<ResolveError>
{
public:
	ResolveErrors() {}
	ResolveErrors(ResolveErrors&& y) : std::vector<ResolveError>(std::move(y)) {}
	ResolveErrors(ResolveErrors const& y) : std::vector<ResolveError>(y) {}
	ResolveErrors& operator =(ResolveErrors&& y)
	{
		std::vector<ResolveError>::operator =(std::move(y));
		return *this;
	}
	ResolveErrors& operator =(ResolveErrors const& y)
	{
		return *this = std::move(ResolveErrors(y));
	}

	void Add( const ResolveError &resolveError )
	{
		this->push_back( resolveError );
	}
};


}}}
