#pragma once

class CClass;

class GenericType;
typedef std::vector<GenericType> GenericTypes;

class Type
{
	int basicType;
	union{
		LONG_PTR index;
		const CClass *pClass;
	};

	// WFlNX NX CX^X^̏ꍇɎg
	GenericTypes actualGenericTypes;

	// ^p[^Ŏg
	std::string formalTypeName;	// ^p[^̖O
	int formalTypeIndex;		// ^p[^̈ԍ

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Type" );

		ar & BOOST_SERIALIZATION_NVP( basicType );
		if( HasMember() )
		{
			ar & boost::serialization::make_nvp("pClass", const_cast<CClass *&>(pClass));
			ar & BOOST_SERIALIZATION_NVP( actualGenericTypes );
		}
		else
		{
			ar & BOOST_SERIALIZATION_NVP( index );
		}

		if( IsTypeParameter() )
		{
			ar & BOOST_SERIALIZATION_NVP( formalTypeName );
			ar & BOOST_SERIALIZATION_NVP( formalTypeIndex );
		}
	}

public:
	static int GetBasicSize( int basicType );

	Type():
	  basicType( DEF_NON ),
	  index( -1 ){}
	Type( int basicType ):
	  basicType( basicType ),
	  index( -1 ){}

	Type( int basicType, LONG_PTR index )
		: basicType( basicType )
		, index( index )
	{
	}

	Type( int basicType, const CClass &objClass ):
	  basicType( basicType ),
	  index( (LONG_PTR)&objClass ){}

	Type(Type&& type)
		: basicType(std::move(type.basicType))
		, index(std::move(type.index))
		, actualGenericTypes(std::move(type.actualGenericTypes))
		, formalTypeName(std::move(type.formalTypeName))
		, formalTypeIndex(std::move(type.formalTypeIndex))
	{
	}

	Type(Type const& type)
		: basicType(type.basicType)
		, index(type.index)
		, actualGenericTypes(type.actualGenericTypes)
		, formalTypeName(type.formalTypeName)
		, formalTypeIndex(type.formalTypeIndex)
	{
	}

	~Type();

	Type& operator =(Type&& type)
	{
		basicType = std::move(type.basicType);
		index = std::move(type.index);
		actualGenericTypes = std::move(type.actualGenericTypes);
		formalTypeName = std::move(type.formalTypeName);
		formalTypeIndex = std::move(type.formalTypeIndex);
		return *this;
	}

	Type& operator =(Type const& type)
	{
		return *this = Type(type);
	}

	inline int GetBasicType() const
	{
		return basicType;
	}
	LONG_PTR GetIndex() const
	{
		return index;
	}
	const CClass &GetClass() const;

	void SetBasicType( int basicType ){
		this->basicType = basicType;
	}
	void SetIndex( LONG_PTR index ){
		this->index = index;
	}
	void SetClassPtr( const CClass *pClass )
	{
		if( !HasMember() )
		{
			Jenga::Throw( "NX܂͍\̂łȂ^ɑ΂SetClassPtrĂяo" );
		}
		this->pClass = pClass;
	}
	void SetNull(){
		SetBasicType( DEF_NON );
		SetIndex( -1 );
	}
	void SetType( int basicType, LONG_PTR index ){
		SetBasicType( basicType );
		SetIndex( index );
	}
	void SetType( int basicType, const CClass *pClass ){
		SetBasicType( basicType );
		this->pClass = pClass;
	}
	void SetActualGenericTypes( const GenericTypes &genericTypes )
	{
		this->actualGenericTypes = genericTypes;
	}

	int PtrLevel() const
	{
		return PTR_LEVEL( basicType );
	}
	void PtrLevelUp(){
		PTR_LEVEL_UP( basicType );
	}
	void PtrLevelDown(){
		PTR_LEVEL_DOWN( basicType );
	}
	void SetPtrLevel( int level )
	{
		basicType = MAKE_PTR_TYPE( NATURAL_TYPE( basicType ), level );
	}

	bool Equals( const Type &type ) const;
	bool IsCovariant( const Type &type ) const;
	bool IsContravariant( const Type &type ) const;

	int GetBasicSize() const;
	int GetSize() const;

	bool IsNull() const;

	bool IsByte() const;
	bool IsSByte() const;
	bool IsWord() const;
	bool IsInteger() const;
	bool IsDWord() const;
	bool IsLong() const;
	bool IsQWord() const;
	bool IsInt64() const;
	bool IsSingle() const;
	bool IsDouble() const;
	bool IsBoolean() const;

	static bool IsPointer( int basicType );
	bool IsPointer() const;
	bool IsSigned() const;
	bool IsNaturalWhole() const;
	bool IsWhole() const;
	bool IsReal() const;
	bool Is64() const;
	bool IsValueType() const;
	bool IsProcPtr() const;
	bool IsStruct() const;
	bool IsStructPtr() const;
	bool IsObject() const;
	bool IsObjectPtr() const;
	bool IsTypeParameter() const;
	bool IsObjectClass() const;
	bool IsStringClass() const;
	bool IsVoidPtr() const;
	bool IsAny() const;
	bool IsDelegate() const;
	bool IsInterface() const;
	bool IsComInterface() const;

	// IuWFNg\̂ȂǁAo^ǂ𔻕ʂ
	bool HasMember() const;

	// ^p[^̖O擾
	const std::string &GetFormalTypeName() const
	{
		if( !IsTypeParameter() )
		{
			Jenga::Throw( "^p[^łȂ^ɑ΂GetFormalTypeName\bhĂ΂ꂽ" );
		}
		return formalTypeName;
	}
	void SetFormalTypeName( const std::string &formalTypeName )
	{
		if( !IsTypeParameter() )
		{
			Jenga::Throw( "^p[^łȂ^ɑ΂SetFormalTypeName\bhĂ΂ꂽ" );
		}
		this->formalTypeName = formalTypeName;
	}
	int GetFormalTypeIndex() const
	{
		if( !IsTypeParameter() )
		{
			Jenga::Throw( "^p[^łȂ^ɑ΂GetFormalTypeIndex\bhĂ΂ꂽ" );
		}
		return formalTypeIndex;
	}
	void SetFormalTypeIndex( int formalTypeIndex )
	{
		if( !IsTypeParameter() )
		{
			Jenga::Throw( "^p[^łȂ^ɑ΂SetFormalTypeIndex\bhĂ΂ꂽ" );
		}
		this->formalTypeIndex = formalTypeIndex;
	}

	// 
	const Type &GetActualGenericType( int index ) const;
	bool HasActualGenericType() const;

	//^擾
	std::string ToString() const;

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );


private:
	static const int basicTypeList[];
	static const std::string basicTypeNameList[];
public:
	static bool StringToBasicType( const std::string &typeName, int &basicType );
	static const char *Type::BasicTypeToCharPtr( const Type &type );
	static int GetBasicTypeFromSimpleName( const char *variable );
};

class Types
	: public std::vector<Type>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & boost::serialization::make_nvp("vector_Type", boost::serialization::base_object<vector<Type>>(*this));
	}

public:
	Types() {}
	Types(Types&& y) : std::vector<Type>(std::move(y)) {}
	Types(Types const& y) : std::vector<Type>(y) {}

	Types& operator =(Types&& y)
	{
		std::vector<Type>::operator =(std::move(y));
		return *this;
	}

	Types& operator =(Types const& y)
	{
		return *this = std::move(Types(y));
	}

	bool IsEquals( const Types &Types ) const;
};

/*!
@brief	WFlbNȌ^
@param	typeParameter WFlbN^w肷Bɉ̌^B
		classType CX^XĂIuWFNǧ^
		pUserProc ݃RpC̊֐iNX\bĥ݁j
*/
void ResolveFormalGenericTypeParameter( Type &typeParameter, const Type &classType, const UserProc *pUserProc = NULL );

class GenericType
{
	std::string name;
	Type type;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - GenericType" );

		ar & BOOST_SERIALIZATION_NVP( name );
		ar & BOOST_SERIALIZATION_NVP( type );
	}

public:
	GenericType( std::string name, Type type )
		: name(std::move(name))
		, type(std::move(type))
	{
	}

	GenericType()
	{
	}

	GenericType(GenericType&& y)
		: name(std::move(y.name))
		, type(std::move(y.type))
	{
	}

	GenericType(GenericType const& y)
		: name(y.name)
		, type(y.type)
	{
	}

	GenericType& operator =(GenericType&& y)
	{
		name = std::move(y.name);
		type = std::move(y.type);
		return *this;
	}

	GenericType& operator =(GenericType const& y)
	{
		return *this = std::move(GenericType(y));
	}

	~GenericType()
	{
	}

	const std::string &GetName() const
	{
		return name;
	}
	const Type &GetType() const
	{
		return type;
	}
	Type &GetType()
	{
		return type;
	}
};

class BlittableType
{
	Type basicType;
	const CClass *pClass;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - BlittableType" );

		ar & BOOST_SERIALIZATION_NVP( basicType );
		ar & boost::serialization::make_nvp("pClass", const_cast<CClass *&>(pClass) );
	}

public:
	BlittableType( const Type &basicType, const CClass *pClass )
		: basicType( basicType )
		, pClass( pClass )
	{
	}

	BlittableType()
		: basicType()
		, pClass()
	{
	}

	BlittableType(BlittableType&& y)
		: basicType(std::move(y.basicType))
		, pClass(std::move(y.pClass))
	{
	}

	BlittableType(BlittableType const& y)
		: basicType(y.basicType)
		, pClass(y.pClass)
	{
	}

	BlittableType& operator =(BlittableType&& y)
	{
		basicType = std::move(y.basicType);
		pClass = std::move(y.pClass);
		return *this;
	}

	BlittableType& operator =(BlittableType const& y)
	{
		return *this = std::move(BlittableType(y));
	}

	const Type &GetBasicType() const
	{
		return basicType;
	}
	const CClass *GetClassPtr() const
	{
		return pClass;
	}
	const std::string GetCreateStaticMethodFullName() const;

	virtual bool Resolve( const ObjectModule &resolver, ResolveErrors &resolveErrors );
};

class BlittableTypes : public std::vector<BlittableType>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - BlittableTypes" );

		ar & boost::serialization::make_nvp("vector_BlittableType",
			boost::serialization::base_object<std::vector<BlittableType>>(*this));
	}

public:
	BlittableTypes() {}
	BlittableTypes(BlittableTypes&& y) : std::vector<BlittableType>(std::move(y)) {}
	BlittableTypes(BlittableTypes const& y) : std::vector<BlittableType>(y) {}
	BlittableTypes& operator =(BlittableTypes&& y)
	{
		std::vector<BlittableType>::operator =(std::move(y));
		return *this;
	}
	BlittableTypes& operator =(BlittableTypes const& y)
	{
		return *this = std::move(BlittableTypes(y));
	}

	bool IsExist( Type type ) const
	{
		const BlittableTypes &blittableTypes = *this;
		foreach( const BlittableType &blittableType, blittableTypes ){
			if( blittableType.GetBasicType().Equals( type ) ){
				return true;
			}
		}
		return false;
	}
	const BlittableType &Find( const Type &type ) const
	{
		const BlittableTypes &blittableTypes = *this;
		foreach( const BlittableType &blittableType, blittableTypes ){
			if( blittableType.GetBasicType().Equals( type ) ){
				return blittableType;
			}
		}
		Jenga::Throw( "Blittable^ł͂Ȃ" );

		static BlittableType dummy;
		return dummy;
	}
	const CClass *GetClassPtr( const Type &type ) const
	{
		const BlittableTypes &blittableTypes = *this;
		foreach( const BlittableType &blittableType, blittableTypes ){
			if( blittableType.GetBasicType().Equals( type ) ){
				return blittableType.GetClassPtr();
			}
		}
		return NULL;
	}
	const CClass &GetClass( const Type &type ) const
	{
		return *GetClassPtr( type );
	}
};
