#include "Messenger.h"
#include "CodeGenerator.h"
#include "Linker.h"
#include "Enum.h"
#include "ErrorCode.h"

#pragma once

class Compiler
{
	// rh̃tO
	bool isBuildSuccessful;

	// W[
	std::string moduleName;

	// W[ ^Cv
	ActiveBasic::Common::TargetModuleType::EnumType targetModuleType;

	// fobO rhǂ
	bool isDebug;

	// UnicodeΉW[ǂ
	bool isUnicode;

	// OԃT|[g
	NamespaceSupporter namespaceSupporter;

	// RpCUserProc/CClass
	const UserProc *pCompilingUserProc;
	const CClass *pCompilingClass;

	// ݎQƂ\[XR[h̃IuWFNg W[ CfbNX
	int currentRelationalObjectModuleIndexForSource;



public:

	Compiler();
	~Compiler();

	// ÓIN̏siIuWFNgW[m̖OXǧȂǁAOsj
	void PreStaticLink( const ObjectModules &staticLibraries );

	// ÓINs
	void StaticLink( ObjectModules &staticLibraries );

	// rh̃tO
	bool IsBuildSuccessful() const
	{
		return isBuildSuccessful;
	}
	void BuildSuccessful()
	{
		isBuildSuccessful = true;
	}

	// W[
	void SetModuleName( const std::string &moduleName )
	{
		this->moduleName = moduleName;
	}
	const std::string &GetModuleName() const
	{
		return moduleName;
	}

	// OԃT|[g
	NamespaceSupporter &GetNamespaceSupporter()
	{
		return namespaceSupporter;
	}

	// bZW[
	Messenger messenger;
	ErrorMessenger errorMessenger;

	// R[h@\
	CodeGenerator codeGenerator;

	// J
	Linker linker;

	// \[X}l[W
	ActiveBasic::Common::ResourceManager resourceManager;

	// ÓINIuWFNgt@C
	std::vector<std::string> staticLibraryFilePaths;

	// ÓINIuWFNgW[
	ObjectModules staticLibraries;

	ObjectModule *pSelectedObjectModule;

	// IuWFNgW[
	ObjectModule &GetObjectModule()
	{
		return *pSelectedObjectModule;
	}

	void SelectObjectModule( ObjectModule *pObjectModule )
	{
		this->pSelectedObjectModule = pObjectModule;
	}

	// ݎQƂׂ\[XR[h
	const BasicSource &GetCurrentSource()
	{
		return staticLibraries[currentRelationalObjectModuleIndexForSource]->GetSource();
	}

	// ݎQƂׂ\[XR[hi[IuWFNgW[̃CfbNX
	int GetCurrentRelationalObjectModuleIndexForSource() const
	{
		return currentRelationalObjectModuleIndexForSource;
	}
	void SetCurrentRelationalObjectModuleIndexForSource( int currentRelationalObjectModuleIndexForSource )
	{
		this->currentRelationalObjectModuleIndexForSource = currentRelationalObjectModuleIndexForSource;
	}

	bool IsExe() const
	{
		if( targetModuleType == ActiveBasic::Common::TargetModuleType::Exe )
		{
			return true;
		}
		return false;
	}
	bool IsDll() const
	{
		if( targetModuleType == ActiveBasic::Common::TargetModuleType::Dll )
		{
			return true;
		}
		return false;
	}

	// X^eBbN N CurhH
	bool IsSll() const
	{
		if( targetModuleType == ActiveBasic::Common::TargetModuleType::Sll )
		{
			return true;
		}
		return false;
	}

	void SetTargetModuleType( ActiveBasic::Common::TargetModuleType::EnumType targetModuleType )
	{
		this->targetModuleType = targetModuleType;
	}

	void SetDebugMark( bool isDebug )
	{
		this->isDebug = isDebug;
	}
	bool IsDebug() const
	{
		return isDebug;
	}

	void SetUnicodeMark( bool isUnicode )
	{
		this->isUnicode = isUnicode;
	}
	bool IsUnicode()
	{
		return isUnicode;
	}

	int AddStringToDataTable( const std::string &text );


	// RAW[ǂ
	bool isCore;
	void SetCoreMark( bool isCore )
	{
		this->isCore = isCore;
	}
	bool IsCore() const
	{
		return isCore;
	}

	// O[oGAu֐
	const std::string &GetGlobalAreaProcName() const;

	// 񋓌^
	EnumInfoCollection enumInfoCollection;


private:
	ActiveBasic::Compiler::Error::StringToTypeErrorCode::EnumType StringToGenericTypeEx( const std::string &typeName, Type &type );
public:
	ActiveBasic::Compiler::Error::StringToTypeErrorCode::EnumType StringToTypeEx( const std::string &typeName, Type &type, bool isResolveGenerics = false );
	bool StringToType( const std::string &typeName, Type &type );
	const std::string TypeToString( const Type &type );

	// WFlbN^̌^p[^T|[gSizeOf֐̖߂l擾
	int SizeOf( const Type &type );

	void ClearCompilingUserProcAndClass();
	void StartGlobalAreaCompile();
	void FinishGlobalAreaCompile();
	void SetCompilingClass( const CClass *pClass );
	void SetCompilingUserProc( const UserProc *pUserProc );
	void StartProcedureCompile( const UserProc *pUserProc );
	void FinishProcedureCompile();

	bool IsGlobalAreaCompiling();
	bool IsLocalAreaCompiling();
	const UserProc &GetCompilingUserProc();
	bool IsCompilingClass();
	const CClass &GetCompilingClass();
};

extern Compiler compiler;
