#pragma once

#include <memory>
#include <windows.h>
#include <boost/optional.hpp>

namespace ActiveBasic { namespace Resource {

HICON LoadIconAlt(HINSTANCE hinst, USHORT id, int cxDesired, int cyDesired, UINT load = 0);
HICON LoadIconAlt(HINSTANCE hinst, USHORT id);

HCURSOR LoadCursorAlt(HINSTANCE hinst, USHORT id);

boost::optional<std::wstring> LoadStringAlt(HINSTANCE hinst, USHORT id);

HACCEL LoadAcceleratorsAlt(HINSTANCE hinst, USHORT id);

HMENU LoadMenuAlt(HINSTANCE hinst, USHORT id);

INT_PTR DialogBoxAlt(HINSTANCE hinst, USHORT id, HWND hwndParent, DLGPROC dialogFunc, LPARAM initParam = 0);
HWND CreateDialogAlt(HINSTANCE hinst, USHORT id, HWND hwndParent, DLGPROC dialogFunc, LPARAM initParam = 0);

struct IconDeleter
{
	typedef HICON pointer;

	void operator ()(HICON hicon) const
	{
		::DestroyIcon(hicon);
	}
};

typedef std::unique_ptr<HICON, IconDeleter> UniqueHIcon;

}}
