#include "stdafx.h"

#include "common.h"

HRESULT ApplyDialogTexture( HWND );

char *GetIconEditToolName(DWORD id){
	char *pTemp=0;

#if defined(JPN)
	//{
	if(id==IDC_TOOL_SELECT) pTemp="I";
	else if(id==IDC_TOOL_PEN) pTemp="y";
	else if(id==IDC_TOOL_LINE) pTemp="";
	else if(id==IDC_TOOL_FILL) pTemp="hԂ";
	else if(id==IDC_TOOL_RECTANGLE) pTemp="lp`";
	else if(id==IDC_TOOL_FILLRECT) pTemp="tlp`";
	else if(id==IDC_TOOL_FILLRECT2) pTemp="hԂlp`";
	else if(id==IDC_TOOL_ELLIPSE) pTemp="ȉ~";
#else
	//p
	if(id==IDC_TOOL_SELECT) pTemp="Tool";
	else if(id==IDC_TOOL_PEN) pTemp="Pen";
	else if(id==IDC_TOOL_LINE) pTemp="Line";
	else if(id==IDC_TOOL_FILL) pTemp="Fill";
	else if(id==IDC_TOOL_RECTANGLE) pTemp="Rectangle";
	else if(id==IDC_TOOL_FILLRECT) pTemp="Rectangle with edge";
	else if(id==IDC_TOOL_FILLRECT2) pTemp="Fill Rectangle";
	else if(id==IDC_TOOL_ELLIPSE) pTemp="Ellipse";
#endif

	return pTemp;
}

INT_PTR CALLBACK DlgIconButtons(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	int WndNum;
	RECT rect;
#define BMPNUM_ICONTOOLBAR 8
	TBBUTTON IconToolBar[]={
		{0,IDC_TOOL_SELECT,TBSTATE_ENABLED|TBSTATE_WRAP,TBSTYLE_CHECKGROUP,0,0},
		{1,IDC_TOOL_PEN,TBSTATE_ENABLED|TBSTATE_CHECKED,TBSTYLE_CHECKGROUP,0,0},
		{2,IDC_TOOL_LINE,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{3,IDC_TOOL_FILL,TBSTATE_ENABLED|TBSTATE_WRAP,TBSTYLE_CHECKGROUP,0,0},
		{4,IDC_TOOL_RECTANGLE,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{5,IDC_TOOL_FILLRECT,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{6,IDC_TOOL_FILLRECT2,TBSTATE_ENABLED|TBSTATE_WRAP,TBSTYLE_CHECKGROUP,0,0},
		{7,IDC_TOOL_ELLIPSE,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
	};
	TOOLTIPTEXT *pTipText;
	static HWND hToolBar;

	switch(message){
		case WM_INITDIALOG:
			MoveWindow(hwnd,20,120,80,200,1);

			hToolBar=CreateToolbarEx(hwnd,WS_CHILD|WS_VISIBLE|CCS_NODIVIDER|TBSTYLE_FLAT|TBSTYLE_TOOLTIPS,
				0,
				BMPNUM_ICONTOOLBAR,	/*rbg}bv̌*/
				hResInst,(unsigned int)MAKEINTRESOURCE(IDR_ICONTOOLBAR),IconToolBar,
				BMPNUM_ICONTOOLBAR,	/*ACě*/
				0,0,16,15,sizeof(TBBUTTON));


			//Windows9xnOSł̕sh
			PostMessage(hwnd,WM_USER+120,0,0);

			ApplyDialogTexture(hwnd);
			break;
		case WM_USER+120:
			GetClientRect(hwnd,&rect);
			MoveWindow(hToolBar,0,0,rect.right,rect.bottom,1);
			return 1;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_TOOL_SELECT:
				case IDC_TOOL_PEN:
				case IDC_TOOL_LINE:
				case IDC_TOOL_FILL:
				case IDC_TOOL_RECTANGLE:
				case IDC_TOOL_FILLRECT:
				case IDC_TOOL_FILLRECT2:
				case IDC_TOOL_ELLIPSE:
					WndNum=GetWndNum(GetParent(GetParent(hwnd)));
					if(LOWORD(wParam)!=IDC_TOOL_SELECT&&
						MdiInfo[WndNum]->MdiIconEditInfo->NowTool==IDC_TOOL_SELECT){
						MdiInfo[WndNum]->MdiIconEditInfo->NowTool=LOWORD(wParam);
						if(MdiInfo[WndNum]->MdiIconEditInfo->SelectLevel){
							if(MdiInfo[WndNum]->MdiIconEditInfo->SelectLevel==2)
								DeleteObject(MdiInfo[WndNum]->MdiIconEditInfo->hSelectingBmp);
							MdiInfo[WndNum]->MdiIconEditInfo->SelectLevel=0;
						}
						InvalidateRect(MdiInfo[WndNum]->MdiIconEditInfo->hMain,NULL,0);
					}
					else MdiInfo[WndNum]->MdiIconEditInfo->NowTool=LOWORD(wParam);
					return 1;
			}
			break;
		case WM_NOTIFY:
			pTipText=(TOOLTIPTEXT *)lParam;
			if(pTipText->hdr.code==TTN_NEEDTEXT){
				//c[`bv\
				pTipText->lpszText=GetIconEditToolName(pTipText->hdr.idFrom);
			}
			break;
	}
	return 0;
}
INT_PTR CALLBACK DlgIconType(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	int i,WndNum;
	HWND hList;
	BOOL bExist[4];
	char temporary[32];

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);

			WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));

			memset(bExist,0,sizeof(BOOL)*4);
			for(i=0;i<MdiInfo[WndNum]->MdiIconEditInfo->num;i++){
				if(MdiInfo[WndNum]->MdiIconEditInfo->pBmpHdr[i]->biWidth==16&&
					MdiInfo[WndNum]->MdiIconEditInfo->pBmpHdr[i]->biBitCount==4){
					bExist[0]=1;
				}
				if(MdiInfo[WndNum]->MdiIconEditInfo->pBmpHdr[i]->biWidth==16&&
					MdiInfo[WndNum]->MdiIconEditInfo->pBmpHdr[i]->biBitCount==8){
					bExist[1]=1;
				}
				if(MdiInfo[WndNum]->MdiIconEditInfo->pBmpHdr[i]->biWidth==32&&
					MdiInfo[WndNum]->MdiIconEditInfo->pBmpHdr[i]->biBitCount==4){
					bExist[2]=1;
				}
				if(MdiInfo[WndNum]->MdiIconEditInfo->pBmpHdr[i]->biWidth==32&&
					MdiInfo[WndNum]->MdiIconEditInfo->pBmpHdr[i]->biBitCount==8){
					bExist[3]=1;
				}
			}

			hList=GetDlgItem(hwnd,IDC_TYPELIST);
			if(bExist[0]==0){
				//"16*16 (16F)"
				sprintf(temporary,"16*16 (16%s)",STRING_UNIT_COLORS);
				SendMessage(hList,LB_ADDSTRING,0,(LPARAM)temporary);
			}
			if(bExist[1]==0){
				//"16*16 (256F)"
				sprintf(temporary,"16*16 (256%s)",STRING_UNIT_COLORS);
				SendMessage(hList,LB_ADDSTRING,0,(LPARAM)temporary);
			}
			if(bExist[2]==0){
				//"32*32 (16F)"
				sprintf(temporary,"32*32 (16%s)",STRING_UNIT_COLORS);
				SendMessage(hList,LB_ADDSTRING,0,(LPARAM)temporary);
			}
			if(bExist[3]==0){
				//"32*32 (256F)"
				sprintf(temporary,"32*32 (256%s)",STRING_UNIT_COLORS);
				SendMessage(hList,LB_ADDSTRING,0,(LPARAM)temporary);
			}
			ApplyDialogTexture(hwnd);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					hList=GetDlgItem(hwnd,IDC_TYPELIST);
					SendMessage(hList,LB_GETTEXT,SendMessage(hList,LB_GETCURSEL,0,0),(LPARAM)temporary);

					if(temporary[0]=='1'&&temporary[7]=='1') i=ICONTYPE_16_16;
					if(temporary[0]=='1'&&temporary[7]=='2') i=ICONTYPE_16_256;
					if(temporary[0]=='3'&&temporary[7]=='1') i=ICONTYPE_32_16;
					if(temporary[0]=='3'&&temporary[7]=='2') i=ICONTYPE_32_256;
					EndDialog(hwnd,i);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,-1);
					return 1;
			}
			break;
	}
	return 0;
}
INT_PTR CALLBACK DlgIconToolProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	int i,WndNum;

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_ADD_ICONTYPE:
					i = ActiveBasic::Resource::DialogBoxAlt(hResInst, IDD_ICONEDIT_ICONTYPE, GetParent(hwnd), DlgIconType);
					if(i==-1) return 1;

					WndNum=GetWndNum(GetParent(hwnd));
					AddIconType(WndNum,i);

					EnableWindow(GetDlgItem(hwnd,IDC_DELETE_ICONTYPE),1);
					return 1;
				case IDC_DELETE_ICONTYPE:
					WndNum=GetWndNum(GetParent(hwnd));
					DeleteIconType(WndNum);

					if(MdiInfo[WndNum]->MdiIconEditInfo->num<=1)
						EnableWindow(GetDlgItem(hwnd,IDC_DELETE_ICONTYPE),0);
					return 1;
				case IDC_ICONTYPECOMBO:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						WndNum=GetWndNum(GetParent(hwnd));

						//C[WIp̃
						if(MdiInfo[WndNum]->MdiIconEditInfo->SelectLevel==2)
							DeleteObject(MdiInfo[WndNum]->MdiIconEditInfo->hSelectingBmp);
						MdiInfo[WndNum]->MdiIconEditInfo->SelectLevel=0;

						MdiInfo[WndNum]->MdiIconEditInfo->SelectIconNum=
							SendDlgItemMessage(hwnd,IDC_ICONTYPECOMBO,CB_GETCURSEL,0,0);

						HBRUSH hOldBrush;
						hOldBrush=(HBRUSH)SelectObject(MdiInfo[WndNum]->MdiIconEditInfo->memdc,GetStockObject(WHITE_BRUSH));
						PatBlt(MdiInfo[WndNum]->MdiIconEditInfo->memdc,0,0,400,400,PATCOPY);
						SelectObject(MdiInfo[WndNum]->MdiIconEditInfo->memdc,hOldBrush);
						DrawIconToMemBmp(WndNum,0);

						InvalidateRect(MdiInfo[WndNum]->MdiIconEditInfo->hMain,NULL,1);
						InvalidateRect(MdiInfo[WndNum]->MdiIconEditInfo->hColorDlg,NULL,0);
					}
					return 1;
			}
			break;
	}
	return 0;
}
