#include "stdafx.h"

#include "Common.h"

using namespace ActiveBasic::IDE;

#if defined(JPN)
//{
#include "pj_msg_jpn.h"
#else
//p
#include "pj_msg_eng.h"
#endif

int GetWndInfoNum( const std::string &name )
{
	for( int i=0;i<static_cast<int>(projectInfo.windowInfos.size());i++){
		if(lstrcmpi(name.c_str(),projectInfo.windowInfos[i]->GetName().c_str())==0) return i;
	}
	return -1;
}
ActiveBasic::PM::WindowInfo *GetWndInfo( const std::string &name )
{
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		if(lstrcmpi(name.c_str(),pWindowInfo->GetName().c_str())==0) return pWindowInfo;
	}
	return NULL;
}
void ChangeDivisionToOrSign(char *CopyBuffer,const char *ReadBuffer){
	int i,i2;
	for(i=0,i2=0;;i++,i2++){
		if(ReadBuffer[i]=='|'){
			CopyBuffer[i2]=0;
			lstrcpy(CopyBuffer+i2," or ");
			i2+=3;
			continue;
		}
		CopyBuffer[i2]=ReadBuffer[i];
		if(ReadBuffer[i]=='\0') break;
	}
}
void ChangeOrSignToDivision(char *CopyBuffer,const char *ReadBuffer){
	int i,i2,IsStr;
	for(i=0,i2=0,IsStr=0;;i++,i2++){
		if(ReadBuffer[i]=='\"') IsStr^=1;
		if(ReadBuffer[i]=='\0'){
			CopyBuffer[i2]=0;
			break;
		}
		if(ReadBuffer[i+3]=='\0'){
			memcpy(CopyBuffer+i2,ReadBuffer+i,3);
			CopyBuffer[i2+3]=0;
			break;
		}
		if((ReadBuffer[i]==' '||ReadBuffer[i]=='\t')&&
			(ReadBuffer[i+1]=='O'||ReadBuffer[i+1]=='o')&&(ReadBuffer[i+2]=='R'||ReadBuffer[i+2]=='r')&&
			(ReadBuffer[i+3]==' '||ReadBuffer[i+3]=='\t')&&IsStr==0){
			CopyBuffer[i2]='|';
			i+=3;
			continue;
		}
		CopyBuffer[i2]=ReadBuffer[i];
	}
}

HGLOBAL Rad_GetChildInfoClipboardData(int WndNum,int WndInfoNum){
	//ChildWindowInfo\̂Nbv{[hpf[^ipByteobt@jɕϊ
	HGLOBAL hGlobal;
	BYTE *pByte;
	int i2,i3,MemSize;

	for(i3=0;;i3++){
		if(MdiInfo[WndNum]->MdiRadInfo->SelectingItem[i3]==-1) break;
	}
	

	hGlobal=GlobalAlloc(GMEM_MOVEABLE,sizeof(int));
	pByte=(BYTE *)GlobalLock(hGlobal);
	*((int *)pByte)=i3;
	GlobalUnlock(hGlobal);
	i2=sizeof(int);

	MemSize=i2;

	for(i3--;i3>=0;i3--){
		ActiveBasic::PM::ChildWindowInfo *pChildInfo = projectInfo.windowInfos[WndInfoNum]->childWindowInfos[MdiInfo[WndNum]->MdiRadInfo->SelectingItem[i3]];

		MemSize+=pChildInfo->GetName().size()+1+
			sizeof(POINT)+
			sizeof(SIZE)+
			pChildInfo->GetCaption().size()+1+
			sizeof(DWORD)+
			sizeof(DWORD)+
			sizeof(int)+
			sizeof(int)+
			pChildInfo->image.path.size()+1;

		hGlobal=GlobalReAlloc(hGlobal,MemSize,0);
		pByte=(BYTE *)GlobalLock(hGlobal);

		lstrcpy((char *)pByte+i2,pChildInfo->GetName().c_str());
		i2+=pChildInfo->GetName().size()+1;

		memcpy(pByte+i2,&pChildInfo->pos,sizeof(POINT));
		i2+=sizeof(POINT);

		memcpy(pByte+i2,&pChildInfo->size,sizeof(SIZE));
		i2+=sizeof(SIZE);

		lstrcpy((char *)pByte+i2,pChildInfo->GetCaption().c_str());
		i2+=pChildInfo->GetCaption().size()+1;

		*(DWORD *)(pByte+i2) = pChildInfo->GetStyle();
		i2+=sizeof(DWORD);

		*(DWORD *)(pByte+i2) = pChildInfo->GetExStyle();
		i2+=sizeof(DWORD);

		memcpy(pByte+i2,&pChildInfo->Control,sizeof(int));
		i2+=sizeof(int);

		memcpy(pByte+i2,&pChildInfo->image.type,sizeof(int));
		i2+=sizeof(int);

		if( pChildInfo->image.path.empty() )
		{
			lstrcpy((char *)pByte+i2,"");
			i2++;
		}
		else{
			lstrcpy((char *)pByte+i2,pChildInfo->image.path.c_str());
			i2+=pChildInfo->image.path.size()+1;
		}

		GlobalUnlock(hGlobal);
	}

	return hGlobal;
}
void Rad_PasteChildInfoClipboardData(int WndNum,HGLOBAL hGlobal){
	//hGlobalɊi[ĂNbv{[hf[^RADʂɑ}
	BYTE *pByte;
	int i2,i3,WndInfoNum;
	ActiveBasic::PM::ChildWindowInfo ChildInfo;

	for(i2=1;i2<MAX_RAD_SELITEM;i2++) MdiInfo[WndNum]->MdiRadInfo->SelectingItem[i2]=-1;

	WndInfoNum=GetWndInfoNum(MdiInfo[WndNum]->path);
	pByte=(BYTE *)GlobalLock(hGlobal);
	i3=*((int *)pByte);
	i2=sizeof(int);

	for(i3--;i3>=0;i3--){
		//IdNameo͕ύX\
		ChildInfo.SetName( (char *)pByte+i2 );
		i2 += ChildInfo.GetName().size()+1;

		memcpy(&ChildInfo.pos,pByte+i2,sizeof(POINT));
		i2+=sizeof(POINT);

		memcpy(&ChildInfo.size,pByte+i2,sizeof(SIZE));
		i2+=sizeof(SIZE);

		ChildInfo.SetCaption( (char *)pByte+i2 );
		i2+=ChildInfo.GetCaption().size()+1;

		ChildInfo.SetStyle( *(DWORD *)(pByte+i2) );
		i2+=sizeof(DWORD);

		ChildInfo.SetExStyle( *(DWORD *)(pByte+i2) );
		i2+=sizeof(DWORD);

		memcpy(&ChildInfo.Control,pByte+i2,sizeof(int));
		i2+=sizeof(int);

		memcpy(&ChildInfo.image.type,pByte+i2,sizeof(int));
		i2+=sizeof(int);

		ChildInfo.image.path = (char *)pByte+i2;
		i2+=ChildInfo.image.path.size()+1;

		ChildInfo.pos.x+=17;
		ChildInfo.pos.y+=10;

		MdiInfo[WndNum]->MdiRadInfo->SelectingItem[i3]=InsertDlgItem(WndNum,
			WndInfoNum,
			-1,
			&ChildInfo.pos,
			&ChildInfo.size,
			ChildInfo.GetName().c_str(),
			ChildInfo.GetCaption().c_str(),
			ChildInfo.GetStyle(),
			ChildInfo.GetExStyle(),
			ChildInfo.Control,
			ChildInfo.image.type,
			ChildInfo.image.path.c_str(),
			2);
	}

	GlobalUnlock(hGlobal);

	ChangePropertyWindow(WndNum,WndInfoNum);
}

char *FormatCaption(const char *caption){
	extern HANDLE hHeap;
	int i2,i3,BufSize;
	char *buffer;

	BufSize=256*2;
	buffer=(char *)HeapAlloc(hHeap,0,BufSize);
	for(i2=0,i3=0;;i2++,i3++){
		if(i2+256>=BufSize){
			BufSize+=256;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);
		}
		if(caption[i3]=='\"'){
			lstrcpy(buffer+i2,"\"+Chr$(34)+\"");
			i2+=lstrlen(buffer+i2);
			i2--;
			continue;
		}
		buffer[i2]=caption[i3];
		if(caption[i3]=='\0') break;
	}

	return buffer;
}
char *SetCaptionSequence(const char *caption){
	extern HANDLE hHeap;
	int i2,i3,BufSize;
	char *buffer;

	BufSize=256*2;
	buffer=(char *)HeapAlloc(hHeap,0,BufSize);
	for(i2=0,i3=0;;i2++,i3++){
		if(i2+256>=BufSize){
			BufSize+=256;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufSize);
		}
		buffer[i2]=caption[i3];
		if(caption[i3]=='\"'){
			buffer[i2++]='\\';
			buffer[i2]='1';
		}
		else if(caption[i3]=='\\'){
			buffer[i2++]='\\';
			buffer[i2]='\\';
		}
		else if(caption[i3]=='\0') break;
	}

	return buffer;
}
void RestoreCaptionSequence(char *caption){
	int i2,i3;

	for(i2=0,i3=0;;i2++,i3++){
		caption[i2]=caption[i3];
		if(caption[i3]=='\\'){
			i3++;
			if(caption[i3]=='1') caption[i2]='\"';
			else caption[i2]=caption[i3];
		}
		else if(caption[i3]=='\0') break;
	}
}

//ev[g\[Xt@CɒlZbg
char *PermutationWndPgmTemplate(char *pBuf,const char *pPjName, char *pWndName, char *pHandleName, char *pProcName){
	extern HANDLE hHeap;
	int i,i2;

	for(i=0;;i++){
		if(pBuf[i]=='\0') break;
		if(memicmp(pBuf+i,"#name#",6)==0){
			//vWFNgu
			i2=lstrlen(pPjName);
			if(i2>6) pBuf=(char *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pBuf,lstrlen(pBuf)+(i2-6)+1);
			SlideString(pBuf+i+6,i2-6);
			memcpy(pBuf+i,pPjName,i2);
		}
		if(memicmp(pBuf+i,"#window#",8)==0){
			//EBhEu
			i2=lstrlen(pWndName);
			if(i2>6) pBuf=(char *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pBuf,lstrlen(pBuf)+(i2-8)+1);
			SlideString(pBuf+i+8,i2-8);
			memcpy(pBuf+i,pWndName,i2);
		}
		if(memicmp(pBuf+i,"#handle#",8)==0){
			//nhu
			i2=lstrlen(pHandleName);
			if(i2>6) pBuf=(char *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pBuf,lstrlen(pBuf)+(i2-8)+1);
			SlideString(pBuf+i+8,i2-8);
			memcpy(pBuf+i,pHandleName,i2);
		}
		if(memicmp(pBuf+i,"#procedure#",11)==0){
			//vV[Wu
			i2=lstrlen(pProcName);
			if(i2>6) pBuf=(char *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pBuf,lstrlen(pBuf)+(i2-11)+1);
			SlideString(pBuf+i+11,i2-11);
			memcpy(pBuf+i,pProcName,i2);
		}
	}

	return pBuf;
}
const std::string PermutationWndPgmTemplate( const std::string &templateFilePath, const std::string &projectName, const std::string &windowName, const std::string &handleName, const std::string &procName )
{
	Jenga::Common::SourceTemplate sourceTemplate( templateFilePath );
	Jenga::Common::SourceTemplate::Values values;

	values.Insert( "#name#", projectName );
	values.Insert( "#window#", windowName );
	values.Insert( "#handle#", handleName );
	values.Insert( "#procedure#", procName );

	return sourceTemplate.GetResult( values );
}

BOOL GetItemNotifyMessageNameByEvent(char *buffer,int ClassID,const char *EventName){
	if(lstrcmp(EventName,"Click")==0) lstrcpy(buffer,"NM_CLICK");
	else if(lstrcmp(EventName,"CustomDraw")==0) lstrcpy(buffer,"NM_CUSTOMDRAW");
	else if(lstrcmp(EventName,"DblClick")==0) lstrcpy(buffer,"NM_DBLCLK");
	else if(lstrcmp(EventName,"KillFocus")==0) lstrcpy(buffer,"NM_KILLFOCUS");
	else if(lstrcmp(EventName,"OutOfMemory")==0) lstrcpy(buffer,"NM_OUTOFMEMORY");
	else if(lstrcmp(EventName,"RClick")==0) lstrcpy(buffer,"NM_RCLICK");
	else if(lstrcmp(EventName,"RDblClick")==0) lstrcpy(buffer,"NM_RDBLCLK");
	else if(lstrcmp(EventName,"ReleasedCapture")==0) lstrcpy(buffer,"NM_RELEASEDCAPTURE");
	else if(lstrcmp(EventName,"Return")==0) lstrcpy(buffer,"NM_RETURN");
	else if(lstrcmp(EventName,"SetFocus")==0) lstrcpy(buffer,"NM_SETFOCUS");
	else{
		if(ClassID==CT_LISTVIEW){
			if(lstrcmp(EventName,"BeginDrag")==0) lstrcpy(buffer,"LVN_BEGINDRAG");
			else if(lstrcmp(EventName,"BeginLabelEdit")==0) lstrcpy(buffer,"LVN_BEGINLABELEDIT");
			else if(lstrcmp(EventName,"BeginRDrag")==0) lstrcpy(buffer,"LVN_BEGINRDRAG");
			else if(lstrcmp(EventName,"ColumnClick")==0) lstrcpy(buffer,"LVN_COLUMNCLICK");
			else if(lstrcmp(EventName,"DeleteAllItems")==0) lstrcpy(buffer,"LVN_DELETEALLITEMS");
			else if(lstrcmp(EventName,"DeleteItem")==0) lstrcpy(buffer,"LVN_DELETEITEM");
			else if(lstrcmp(EventName,"EndLabelEdit")==0) lstrcpy(buffer,"LVN_ENDLABELEDIT");
			else if(lstrcmp(EventName,"GetDispInfo")==0) lstrcpy(buffer,"LVN_GETDISPINFO");
			else if(lstrcmp(EventName,"InsertItem")==0) lstrcpy(buffer,"LVN_INSERTITEM");
			else if(lstrcmp(EventName,"ItemChanged")==0) lstrcpy(buffer,"LVN_ITEMCHANGED");
			else if(lstrcmp(EventName,"ItemChanging")==0) lstrcpy(buffer,"LVN_ITEMCHANGING");
			else if(lstrcmp(EventName,"KeyDown")==0) lstrcpy(buffer,"LVN_KEYDOWN");
			else if(lstrcmp(EventName,"SetDispInfo")==0) lstrcpy(buffer,"LVN_SETDISPINFO");
			else return 0;
		}
		else if(ClassID==CT_UPDOWN){
			if(lstrcmp(EventName,"Deltapos")==0) lstrcpy(buffer,"UDN_DELTAPOS");
			else return 0;
		}
		else return 0;
		//
	}
	return 1;
}
BOOL GetNotifyCommandByItemMessage(ActiveBasic::PM::WindowInfo *pWindowInfo,ITEMEVENTINFO *pItemEventInfo,char *Command,char *spaces){
	int i,i2,i3,sw;
	char temporary[MAX_PATH];

	i2=0;
	sw=0;
	for(i=0;;i++){
		if(pItemEventInfo[i].IdName==0) break;
		if(pItemEventInfo[i].ClassID==CT_LISTVIEW||
			pItemEventInfo[i].ClassID==CT_TREEVIEW||
			pItemEventInfo[i].ClassID==CT_UPDOWN||
			pItemEventInfo[i].ClassID==CT_PROGRESSBAR||
			pItemEventInfo[i].ClassID==CT_TRACKBAR){
			//R Rg[iWM_NOTIFYj
			sw=1;
			sprintf(Command+i2,"%sCase %s\r\n",spaces,pItemEventInfo[i].IdName);
			i2+=lstrlen(Command+i2);
			sprintf(Command+i2,"%s\tSelect Case pnmHdr->code\r\n",spaces);
			i2+=lstrlen(Command+i2);
			for(i3=0;i3<pItemEventInfo[i].EventNum;i3++){
				if(GetItemNotifyMessageNameByEvent(temporary,pItemEventInfo[i].ClassID,pItemEventInfo[i].pEventNames[i3])){
					sprintf(Command+i2,"%s\t\tCase %s\r\n",spaces,temporary);
					i2+=lstrlen(Command+i2);
					sprintf(Command+i2,"%s\t\t\t%s_%s_%s(ByVal (pnmHdr As VoidPtr))\r\n",
						spaces,
						pWindowInfo->GetName().c_str(),
						pItemEventInfo[i].IdName,pItemEventInfo[i].pEventNames[i3]
					);
					i2+=lstrlen(Command+i2);
				}
			}
			sprintf(Command+i2,"%s\tEnd Select\r\n",spaces);
			i2+=lstrlen(Command+i2);
		}
	}
	return sw;
}
void GetItemMessageNameByEvent(char *buffer,int ClassID,const char *EventName){
	if(ClassID==CT_BUTTON||
		ClassID==CT_CHECKBOX||
		ClassID==CT_RADIOBUTTON){
		if(lstrcmp(EventName,"Click")==0) lstrcpy(buffer,"BN_CLICKED");
		else if(lstrcmp(EventName,"DblClick")==0) lstrcpy(buffer,"BN_DBLCLK");
	}
	else if(ClassID==CT_COMBOBOX){
		if(lstrcmp(EventName,"CloseUp")==0) lstrcpy(buffer,"CBN_CLOSEUP");
		else if(lstrcmp(EventName,"DblClick")==0) lstrcpy(buffer,"CBN_DBLCLK");
		else if(lstrcmp(EventName,"DropDown")==0) lstrcpy(buffer,"CBN_DROPDOWN");
		else if(lstrcmp(EventName,"EditChange")==0) lstrcpy(buffer,"CBN_EDITCHANGE");
		else if(lstrcmp(EventName,"EditUpdate")==0) lstrcpy(buffer,"CBN_EDITUPDATE");
		else if(lstrcmp(EventName,"ErrSpace")==0) lstrcpy(buffer,"CBN_ERRSPACE");
		else if(lstrcmp(EventName,"KillFocus")==0) lstrcpy(buffer,"CBN_KILLFOCUS");
		else if(lstrcmp(EventName,"SelChange")==0) lstrcpy(buffer,"CBN_SELCHANGE");
		else if(lstrcmp(EventName,"SelEndCancel")==0) lstrcpy(buffer,"CBN_SELENDCANCEL");
		else if(lstrcmp(EventName,"SelEndOk")==0) lstrcpy(buffer,"CBN_SELENDOK");
		else if(lstrcmp(EventName,"SetFocus")==0) lstrcpy(buffer,"CBN_SETFOCUS");
	}
	else if(ClassID==CT_EDIT){
		if(lstrcmp(EventName,"Change")==0) lstrcpy(buffer,"EN_CHANGE");
		else if(lstrcmp(EventName,"ErrSpace")==0) lstrcpy(buffer,"EN_ERRSPACE");
		else if(lstrcmp(EventName,"HScroll")==0) lstrcpy(buffer,"EN_HSCROLL");
		else if(lstrcmp(EventName,"KillFocus")==0) lstrcpy(buffer,"EN_KILLFOCUS");
		else if(lstrcmp(EventName,"MaxText")==0) lstrcpy(buffer,"EN_MAXTEXT");
		else if(lstrcmp(EventName,"SetFocus")==0) lstrcpy(buffer,"EN_SETFOCUS");
		else if(lstrcmp(EventName,"Update")==0) lstrcpy(buffer,"EN_UPDATE");
		else if(lstrcmp(EventName,"VScroll")==0) lstrcpy(buffer,"EN_VSCROLL");
	}
	else if(ClassID==CT_IMAGEBOX||
		ClassID==CT_STATIC){
		if(lstrcmp(EventName,"Click")==0) lstrcpy(buffer,"STN_CLICKED");
		else if(lstrcmp(EventName,"DblClick")==0) lstrcpy(buffer,"STN_DBLCLK");
	}
	else if(ClassID==CT_LISTBOX){
		if(lstrcmp(EventName,"SelChange")==0) lstrcpy(buffer,"LBN_SELCHANGE");
		else if(lstrcmp(EventName,"DblClick")==0) lstrcpy(buffer,"LBN_DBLCLK");
		else if(lstrcmp(EventName,"ErrSpace")==0) lstrcpy(buffer,"LBN_ERRSPACE");
		else if(lstrcmp(EventName,"KillFocus")==0) lstrcpy(buffer,"LBN_KILLFOCUS");
		else if(lstrcmp(EventName,"SelCancel")==0) lstrcpy(buffer,"LBN_SELCANCEL");
		else if(lstrcmp(EventName,"SetFocus")==0) lstrcpy(buffer,"LBN_SETFOCUS");
	}
}
void GetCommandByItemMessage(ActiveBasic::PM::WindowInfo *pWindowInfo,ITEMEVENTINFO *pItemEventInfo,char *Command,char *spaces){
	extern HANDLE hHeap;
	int i,i2,i3;
	char temporary[MAX_PATH];

	i2=0;
	for(i=0;;i++){
		if(pItemEventInfo[i].IdName==0) break;
		if(pItemEventInfo[i].ClassID!=CT_LISTVIEW&&
			pItemEventInfo[i].ClassID!=CT_PROGRESSBAR&&
			pItemEventInfo[i].ClassID!=CT_TREEVIEW&&
			pItemEventInfo[i].ClassID!=CT_TRACKBAR&&
			pItemEventInfo[i].ClassID!=CT_UPDOWN
			){
			//WM_COMMAND
			sprintf(Command+i2,"%sCase %s\r\n",spaces,pItemEventInfo[i].IdName);
			i2+=lstrlen(Command+i2);
			if(pItemEventInfo[i].ClassID==CT_MENU){
				sprintf(Command+i2,"%s\t%s_%s_MenuClick()\r\n",spaces,pWindowInfo->GetName().c_str(),pItemEventInfo[i].IdName);
				i2+=lstrlen(Command+i2);
				for(i3=0;i3<pItemEventInfo[i].EventNum;i3++)
					HeapDefaultFree(pItemEventInfo[i].pEventNames[i3]);
			}
			else{
				sprintf(Command+i2,"%s\tSelect Case HIWORD(wParam)\r\n",spaces);
				i2+=lstrlen(Command+i2);
				for(i3=0;i3<pItemEventInfo[i].EventNum;i3++){
					GetItemMessageNameByEvent(temporary,pItemEventInfo[i].ClassID,pItemEventInfo[i].pEventNames[i3]);
					sprintf(Command+i2,"%s\t\tCase %s\r\n",spaces,temporary);
					i2+=lstrlen(Command+i2);
					sprintf(Command+i2,"%s\t\t\t%s_%s_%s()\r\n",spaces,pWindowInfo->GetName().c_str(),pItemEventInfo[i].IdName,pItemEventInfo[i].pEventNames[i3]);
					i2+=lstrlen(Command+i2);
					HeapDefaultFree(pItemEventInfo[i].pEventNames[i3]);
				}
				sprintf(Command+i2,"%s\tEnd Select\r\n",spaces);
				i2+=lstrlen(Command+i2);
			}
			HeapDefaultFree(pItemEventInfo[i].IdName);
			HeapDefaultFree(pItemEventInfo[i].pEventNames);
		}
		else{
			//WM_NOTIFỸ
			for(i3=0;i3<pItemEventInfo[i].EventNum;i3++)
				HeapDefaultFree(pItemEventInfo[i].pEventNames[i3]);
			HeapDefaultFree(pItemEventInfo[i].IdName);
			HeapDefaultFree(pItemEventInfo[i].pEventNames);
		}
	}
}

void GetItemClassName(char *buffer,int Control){
	switch(Control){
		case CT_BUTTON:
		case CT_CHECKBOX:
		case CT_GROUPBOX:
		case CT_RADIOBUTTON:
			lstrcpy(buffer,"BUTTON");
			break;
		case CT_COMBOBOX:
			lstrcpy(buffer,"COMBOBOX");
			break;
		case CT_EDIT:
			lstrcpy(buffer,"EDIT");
			break;
		case CT_HSCROLLBAR:
		case CT_VSCROLLBAR:
			lstrcpy(buffer,"SCROLLBAR");
			break;
		case CT_LISTBOX:
			lstrcpy(buffer,"LISTBOX");
			break;
		case CT_LISTVIEW:
			lstrcpy(buffer,"SysListView32");
			break;
		case CT_IMAGEBOX:
		case CT_STATIC:
			lstrcpy(buffer,"STATIC");
			break;
		case CT_PROGRESSBAR:
			lstrcpy(buffer,"msctls_progress32");
			break;
		case CT_TRACKBAR:
			lstrcpy(buffer,"msctls_trackbar32");
			break;
		case CT_TREEVIEW:
			lstrcpy(buffer,"SysTreeView32");
			break;
		//CT_UPDOWNCreateUpDownControl֐œƎɍ쐬
	}
}
long GetCommandByMessage(int WndInfoNum,const char *MessageName,BOOL bProcedureCall,char *Command,char *spaces){
	int i,i2,sw;
	char temporary[MAX_PATH],*temp2;

	ActiveBasic::PM::WindowInfo *pWindowInfo = projectInfo.windowInfos[WndInfoNum];

	Command[0]=0;


	/////////////////////
	// Default R}h

	if(lstrcmp(MessageName,"Activate")==0){
		sprintf(Command,"%sCase WM_ACTIVATE\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(LOWORD(wParam),HIWORD(wParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"Create")==0){
		if( pWindowInfo->IsModalDlg() || pWindowInfo->IsModelessDlg() )
		{
			sprintf(Command,"%sCase WM_INITDIALOG\r\n",spaces);
		}
		else
		{
			sprintf(Command,"%sCase WM_CREATE\r\n",spaces);
		}
		i=lstrlen(Command);

		sprintf(Command+i,"%s\t%s=hWnd\r\n",spaces,pWindowInfo->GetHandleName().c_str());
		i+=lstrlen(Command+i);

		if( pWindowInfo->HasMenu() )
		{
			//j[쐬
			for(i2=0;i2<projectInfo.NumberOfMenu;i2++){
				if(lstrcmpi(projectInfo.pMenuInfo[i2].IdName,pWindowInfo->GetMenuIdName().c_str())==0) break;
			}
			if(i2!=projectInfo.NumberOfMenu){
				sprintf(Command+i,"%s\tSetMenu(hWnd,hMenu_%s)\r\n",spaces,projectInfo.pMenuInfo[i2].IdName);
				i+=lstrlen(Command+i);
			}
		}

		//qEBhE쐬
		sw = 0;
		BOOST_FOREACH( const ActiveBasic::PM::ChildWindowInfo *pChildInfo, pWindowInfo->childWindowInfos )
		{
			if(pChildInfo->Control==CT_UPDOWN){
				sprintf(Command+i,"%s\tCreateUpDownControl(%d,%d,%d,%d,%d,hWnd,%s,GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,0,0,100,0)\r\n",
					spaces,
					pChildInfo->GetStyle(),
					pChildInfo->pos.x,pChildInfo->pos.y,
					pChildInfo->size.cx,pChildInfo->size.cy,
					pChildInfo->GetName().c_str());
				i+=lstrlen(Command+i);
			}
			else{
				GetItemClassName(temporary,pChildInfo->Control);
				temp2=FormatCaption(pChildInfo->GetCaption().c_str());
				sprintf(Command+i,"%s\tCreateWindowEx(&H%08x,\"%s\",\"%s\",&H%08x,%d,%d,%d,%d,hWnd,%s As HMENU,GetModuleHandle(0),0)\r\n",
					spaces,
					pChildInfo->GetExStyle(),
					temporary,
					temp2,
					pChildInfo->GetStyle(),
					pChildInfo->pos.x,
					pChildInfo->pos.y,
					pChildInfo->size.cx,
					pChildInfo->size.cy,
					pChildInfo->GetName().c_str());
				i+=lstrlen(Command+i);
				HeapDefaultFree(temp2);
				sprintf(Command+i,"%s\tSendMessage(GetDlgItem(hWnd,%s),WM_SETFONT,hFont_%s As WPARAM,0)\r\n",
					spaces,
					pChildInfo->GetName().c_str(),
					pWindowInfo->GetName().c_str());
				i+=lstrlen(Command+i);

				if(pChildInfo->Control==CT_IMAGEBOX){
					//C[W {bNX̏ꍇ
					if((pChildInfo->GetStyle()&0x000F)==SS_ICON){
						if(pChildInfo->image.IsFile()){
							if(strstr(pChildInfo->image.path.c_str(),":")||
								strstr(pChildInfo->image.path.c_str(),"\\\\")){
								sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,\"%s\",IMAGE_ICON,0,0,LR_DEFAULTSIZE or LR_LOADFROMFILE)\r\n",
									spaces,
									pWindowInfo->GetName().c_str(),
									pChildInfo->GetName().c_str(),
									pChildInfo->image.path.c_str());
							}
							else{
								if(sw==0){
									sw=1;
									lstrcpy(Command+i,"\r\n");
									i+=2;
									sprintf(Command+i,"%s\tDim ImageFilePath[MAX_PATH] As Byte\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tDim ModulePath[MAX_PATH] As Byte, i As Long\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tGetModuleFileName(GetModuleHandle(0),ModulePath,MAX_PATH)\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tFor i=lstrlen(ModulePath)-1 To 0 Step -1\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\t\tIf ModulePath[i]=&H5C Then Exit For\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tNext\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tModulePath[i+1]=0\r\n",spaces);
									i+=lstrlen(Command+i);
									lstrcpy(Command+i,"\r\n");
									i+=2;
								}
								sprintf(Command+i,"%s\twsprintf(ImageFilePath,\"%%s%s\",ModulePath)\r\n",spaces,pChildInfo->image.path.c_str());
								i+=lstrlen(Command+i);
								sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,ImageFilePath,IMAGE_ICON,0,0,LR_DEFAULTSIZE or LR_LOADFROMFILE)\r\n",
									spaces,
									pWindowInfo->GetName().c_str(),
									pChildInfo->GetName().c_str());
							}
							i+=lstrlen(Command+i);
						}
						else if(pChildInfo->image.IsResource()){
							sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,%s As *Byte,IMAGE_ICON,0,0,LR_DEFAULTSIZE)\r\n",
								spaces,
								pWindowInfo->GetName().c_str(),
								pChildInfo->GetName().c_str(),
								pChildInfo->image.path.c_str());
							i+=lstrlen(Command+i);
						}
						sprintf(Command+i,"%s\tSendMessage(GetDlgItem(hWnd,%s),STM_SETICON,hImage_%s_%s As WPARAM,0)\r\n",
							spaces,
							pChildInfo->GetName().c_str(),
							pWindowInfo->GetName().c_str(),
							pChildInfo->GetName().c_str());
						i+=lstrlen(Command+i);
					}
					else if((pChildInfo->GetStyle()&0x000F)==SS_BITMAP){
						if(pChildInfo->image.IsFile()){
							if(strstr(pChildInfo->image.path.c_str(),":")||
								strstr(pChildInfo->image.path.c_str(),"\\\\")){
								sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,\"%s\",IMAGE_BITMAP,0,0,LR_DEFAULTSIZE or LR_LOADFROMFILE)\r\n",
									spaces,
									pWindowInfo->GetName().c_str(),
									pChildInfo->GetName().c_str(),
									pChildInfo->image.path.c_str());
							}
							else{
								if(sw==0){
									sw=1;
									lstrcpy(Command+i,"\r\n");
									i+=2;
									sprintf(Command+i,"%s\tDim ImageFilePath[MAX_PATH] As Byte\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tDim ModulePath[MAX_PATH] As Byte, i As Long\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tGetModuleFileName(GetModuleHandle(0),ModulePath,MAX_PATH)\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tFor i=lstrlen(ModulePath)-1 To 0 Step -1\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\t\tIf ModulePath[i]=&H5C Then Exit For\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tNext\r\n",spaces);
									i+=lstrlen(Command+i);
									sprintf(Command+i,"%s\tModulePath[i+1]=0\r\n",spaces);
									i+=lstrlen(Command+i);
									lstrcpy(Command+i,"\r\n");
									i+=2;
								}
								sprintf(Command+i,"%s\twsprintf(ImageFilePath,\"%%s%s\",ModulePath)\r\n",spaces,pChildInfo->image.path.c_str());
								i+=lstrlen(Command+i);
								sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,ImageFilePath,IMAGE_BITMAP,0,0,LR_LOADFROMFILE)\r\n",
									spaces,
									pWindowInfo->GetName().c_str(),
									pChildInfo->GetName().c_str());
							}
							i+=lstrlen(Command+i);
						}
						else if(pChildInfo->image.IsResource()){
							sprintf(Command+i,"%s\thImage_%s_%s=LoadImage(GetWindowLongPtr(hWnd,GWLP_HINSTANCE) As HINSTANCE,%s As *Byte,IMAGE_BITMAP,0,0,LR_DEFAULTSIZE)\r\n",
								spaces,
								pWindowInfo->GetName().c_str(),
								pChildInfo->GetName().c_str(),
								pChildInfo->image.path.c_str());
							i+=lstrlen(Command+i);
						}
						sprintf(Command+i,"%s\tSendMessage(GetDlgItem(hWnd,%s),STM_SETIMAGE,IMAGE_BITMAP,hImage_%s_%s As LPARAM)\r\n",
							spaces,
							pChildInfo->GetName().c_str(),
							pWindowInfo->GetName().c_str(),
							pChildInfo->GetName().c_str());
						i+=lstrlen(Command+i);
					}
				}
			}
		}

		if(bProcedureCall)
			sprintf(Command+i,"%s\t%s_%s(ByVal (lParam As VoidPtr))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
		return WM_CREATE;
	}
	else if(lstrcmp(MessageName,"Destroy")==0){
		sprintf(Command,"%sCase WM_DESTROY\r\n",spaces);
		i=lstrlen(Command);
		if(bProcedureCall){
			sprintf(Command+i,"%s\t%s_%s()\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
			i+=lstrlen(Command+i);
		}

		if( pWindowInfo->HasMenu() )
		{
			//j[
			for(i2=0;i2<projectInfo.NumberOfMenu;i2++){
				if(lstrcmpi(projectInfo.pMenuInfo[i2].IdName,pWindowInfo->GetMenuIdName().c_str())==0) break;
			}
			if(i2!=projectInfo.NumberOfMenu){
				sprintf(Command+i,"%s\tSetMenu(hWnd,NULL)\r\n",spaces);
				i+=lstrlen(Command+i);
			}
		}

		//C[W {bNXp̕ϐ
		BOOST_FOREACH( const ActiveBasic::PM::ChildWindowInfo *pChildInfo, pWindowInfo->childWindowInfos )
		{
			if(pChildInfo->Control==CT_IMAGEBOX){
				if((pChildInfo->GetStyle()&0x000F)==SS_ICON)
					sprintf(Command+i,"%s\tDestroyIcon(hImage_%s_%s)\r\n",spaces,pWindowInfo->GetName().c_str(),pChildInfo->GetName().c_str());
				else if((pChildInfo->GetStyle()&0x000F)==SS_BITMAP)
					sprintf(Command+i,"%s\tDeleteObject(hImage_%s_%s)\r\n",spaces,pWindowInfo->GetName().c_str(),pChildInfo->GetName().c_str());
				i+=lstrlen(Command+i);
			}
		}
		return WM_DESTROY;
	}
	else if(lstrcmp(MessageName,"DropFiles")==0){
		sprintf(Command,"%sCase WM_DROPFILES\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As HDROP)\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"HScroll")==0){
		sprintf(Command,"%sCase WM_HSCROLL\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(LOWORD(wParam),HIWORD(wParam),lParam As HWND)\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"KeyDown")==0){
		sprintf(Command,"%sCase WM_KEYDOWN\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,lParam As Long)\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"KeyPress")==0){
		sprintf(Command,"%sCase WM_CHAR\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,lParam As Long)\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"KeyUp")==0){
		sprintf(Command,"%sCase WM_KEYUP\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,lParam As Long)\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"LButtonDown")==0){
		sprintf(Command,"%sCase WM_LBUTTONDOWN\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"LButtonDblClick")==0){
		sprintf(Command,"%sCase WM_LBUTTONDBLCLK\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"LButtonUp")==0){
		sprintf(Command,"%sCase WM_LBUTTONUP\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"MButtonDown")==0){
		sprintf(Command,"%sCase WM_MBUTTONDOWN\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"MButtonDblClick")==0){
		sprintf(Command,"%sCase WM_MBUTTONDBLCLK\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"MButtonUp")==0){
		sprintf(Command,"%sCase WM_MBUTTONUP\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"MouseMove")==0){
		sprintf(Command,"%sCase WM_MOUSEMOVE\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"Move")==0){
		sprintf(Command,"%sCase WM_MOVE\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"Notify")==0){
		//RRg[bZ[WƋɑ}
		return WM_NOTIFY;
	}
	else if(lstrcmp(MessageName,"Paint")==0){
		sprintf(Command,"%sCase WM_PAINT\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\tDim ps As PAINTSTRUCT\r\n",spaces);
		i+=lstrlen(Command+i);
		sprintf(Command+i,"%s\tDim hDC As HDC\r\n",spaces);
		i+=lstrlen(Command+i);
		sprintf(Command+i,"%s\thDC=BeginPaint(hWnd,ps)\r\n",spaces);
		i+=lstrlen(Command+i);
		sprintf(Command+i,"%s\t%s_%s(hDC)\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
		i+=lstrlen(Command+i);
		sprintf(Command+i,"%s\tEndPaint(hWnd,ps)\r\n",spaces);
		return WM_PAINT;
	}
	else if(lstrcmp(MessageName,"QueryClose")==0){
		sprintf(Command,"%sCase WM_CLOSE\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\tDim cancel=0 As Integer\r\n",spaces);
		i+=lstrlen(Command+i);
		if(bProcedureCall)
		{
			sprintf(Command+i,"%s\t%s_%s(cancel)\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
			i+=lstrlen(Command+i);
		}

		if( pWindowInfo->IsModalDlg() )
		{
			sprintf(Command+i,"%s\tIf cancel=0 Then EndDialog(hWnd,0)\r\n",spaces);
		}
		else
		{
			sprintf(Command+i,"%s\tIf cancel=0 Then DestroyWindow(hWnd)\r\n",spaces);
		}
		return WM_CLOSE;
	}
	else if(lstrcmp(MessageName,"RButtonDblClick")==0){
		sprintf(Command,"%sCase WM_RBUTTONDBLCLK\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"RButtonDown")==0){
		sprintf(Command,"%sCase WM_RBUTTONDOWN\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"RButtonUp")==0){
		sprintf(Command,"%sCase WM_RBUTTONUP\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"Resize")==0){
		sprintf(Command,"%sCase WM_SIZE\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As Long,LOWORD(lParam),HIWORD(lParam))\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"SetFocus")==0){
		sprintf(Command,"%sCase WM_SETFOCUS\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s()\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"Timer")==0){
		sprintf(Command,"%sCase WM_TIMER\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam As DWord)\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	else if(lstrcmp(MessageName,"VScroll")==0){
		sprintf(Command,"%sCase WM_VSCROLL\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(LOWORD(wParam),HIWORD(wParam),lParam As HWND)\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}


	///////////////////
	// MMSYS R}h

	else if(lstrcmp(MessageName,"MciNotify")==0){
		sprintf(Command,"%sCase MM_MCINOTIFY\r\n",spaces);
		i=lstrlen(Command);
		sprintf(Command+i,"%s\t%s_%s(wParam,lParam)\r\n",spaces,pWindowInfo->GetName().c_str(),MessageName);
	}
	return 0;
}

void GetMenuItemConstData(MENU_INFO *pMenuInfo,int NumberOfMenu,int *ConstNumber,Jenga::Common::Strings &namesForDuplicationCheck,char *buffer,int *base){
	extern HANDLE hHeap;
	int i;

	for(i=0;i<NumberOfMenu;i++){
		if(pMenuInfo[i].pMenuInfo){
			//|bvAbv
			GetMenuItemConstData(pMenuInfo[i].pMenuInfo,pMenuInfo[i].NumberOfMenu,ConstNumber,namesForDuplicationCheck,buffer,base);
		}
		else if(pMenuInfo[i].type==MFT_STRING){
			//d`FbN
			bool isMatch = false;
			BOOST_FOREACH( const std::string &name, namesForDuplicationCheck )
			{
				if(lstrcmpi(name.c_str(),pMenuInfo[i].IdName)==0)
				{
					isMatch = true;
					break;
				}
			}
			if( !isMatch )
			{
				namesForDuplicationCheck.push_back( pMenuInfo[i].IdName );

				sprintf(buffer+(*base),"Const %s=%d\r\n",pMenuInfo[i].IdName,*ConstNumber);
				(*base)+=lstrlen(buffer+(*base));
				(*ConstNumber)++;
			}
		}
	}
}
int GetMakeMenuCommand(MENU_INFO *pMenuInfo,int NumberOfMenu,char *MenuHandle,char *Command,BOOL bMain){
	int i,i2;
	char temporary[MAX_PATH];

	i=0;
	sprintf(Command+i,"Dim %s As HMENU\r\n",MenuHandle);
	i+=lstrlen(Command+i);
	if(bMain) sprintf(Command+i,"%s=CreateMenu()\r\n",MenuHandle);
	else sprintf(Command+i,"%s=CreatePopupMenu()\r\n",MenuHandle);
	i+=lstrlen(Command+i);

	for(i2=NumberOfMenu-1;i2>=0;i2--){
		if(pMenuInfo[i2].pMenuInfo){
			sprintf(temporary,"%s_%d",MenuHandle,i2);
			i+=GetMakeMenuCommand(pMenuInfo[i2].pMenuInfo,pMenuInfo[i2].NumberOfMenu,temporary,Command+i,0);
			sprintf(Command+i,"InsMenu %s,0,MF_BYPOSITION,Ex\"%s\",0,%s,%d\r\n",
				MenuHandle,
				pMenuInfo[i2].caption,
				temporary,
				pMenuInfo[i2].state);
			i+=lstrlen(Command+i);
		}
		else{
			if(pMenuInfo[i2].type==MFT_STRING){
				sprintf(Command+i,"InsMenu %s,0,MF_BYPOSITION,Ex\"%s\",%s,0,%d\r\n",
					MenuHandle,
					pMenuInfo[i2].caption,
					pMenuInfo[i2].IdName,
					pMenuInfo[i2].state);
				i+=lstrlen(Command+i);
			}
			else if(pMenuInfo[i2].type==MFT_SEPARATOR){
				sprintf(Command+i,"InsMenu %s,0,MF_BYPOSITION,\"\"\r\n",
					MenuHandle);
				i+=lstrlen(Command+i);
			}
		}
	}
	return i;
}
int GetDestroyMenuCommand(MENU_INFO *pMenuInfo,int NumberOfMenu,char *MenuHandle,char *Command){
	int i,i2;
	char temporary[MAX_PATH];

	i=0;
	sprintf(Command+i,"\tDestroyMenu(%s)\r\n",MenuHandle);
	i+=lstrlen(Command+i);

	for(i2=NumberOfMenu-1;i2>=0;i2--){
		if(pMenuInfo[i2].pMenuInfo){
			sprintf(temporary,"%s_%d",MenuHandle,i2);
			i+=GetDestroyMenuCommand(pMenuInfo[i2].pMenuInfo,pMenuInfo[i2].NumberOfMenu,temporary,Command+i);
		}
	}
	return i;
}
void SaveWindowProgram(){
	extern HANDLE hHeap;
	int i,i2,i3,i4,i5,sw1,sw2,sw3,sw4,size;
	char *buffer,temporary[MAX_PATH];

	size=2;
	buffer=(char *)HeapAlloc(hHeap,0,65535*size);
	lstrcpy(buffer,"'̃t@C̓EBhE`t@Ci*.wndjƂɐĂ܂\r\n\r\n");
	i2=lstrlen(buffer);

	if(projectInfo.dwOption&PJ_OP_COMMCTRL){
		//R}Rg[
		lstrcpy(buffer+i2,"Dim _RadSys_InitCtrls As INITCOMMONCONTROLSEX\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"_RadSys_InitCtrls.dwSize=Len(_RadSys_InitCtrls)\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"_RadSys_InitCtrls.dwICC=ICC_WIN95_CLASSES\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"InitCommonControlsEx(_RadSys_InitCtrls)\r\n\r\n");
		i2+=lstrlen(buffer+i2);
	}


	////////////
	//ID`

	Jenga::Common::Strings namesForDuplicationCheck;
	i4=1000;
	i5=0;
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		BOOST_FOREACH( const ActiveBasic::PM::ChildWindowInfo *pChildInfo, pWindowInfo->childWindowInfos )
		{
			//d`FbN
			bool isMatch = false;
			BOOST_FOREACH( const std::string &name, namesForDuplicationCheck )
			{
				if(lstrcmpi(name.c_str(),pChildInfo->GetName().c_str())==0){
					isMatch = true;
					break;
				}
			}
			if( isMatch ) continue;

			namesForDuplicationCheck.push_back( pChildInfo->GetName() );

			sprintf(buffer+i2,"Const %s=%d\r\n",pChildInfo->GetName().c_str(),i4);
			i2+=lstrlen(buffer+i2);
			i4++;

			while(i2>65535*(size-1)){
				size++;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
			}
		}
	}

	//j[ID`
	GetMenuItemConstData(projectInfo.pMenuInfo,projectInfo.NumberOfMenu,&i4,namesForDuplicationCheck,buffer,&i2);

	lstrcpy(buffer+i2,"\r\n");
	i2+=lstrlen(buffer+i2);


	//nhϐ`
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		sprintf(buffer+i2,"Dim %s As HWND\r\n",pWindowInfo->GetHandleName().c_str());
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"Dim hFont_%s As HFONT\r\n",pWindowInfo->GetName().c_str());
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"hFont_%s=CreateFont(%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,\"%s\")\r\n",
			pWindowInfo->GetName().c_str(),
			pWindowInfo->LogFont.lfHeight,
			pWindowInfo->LogFont.lfWidth,
			pWindowInfo->LogFont.lfEscapement,
			pWindowInfo->LogFont.lfOrientation,
			pWindowInfo->LogFont.lfWeight,
			pWindowInfo->LogFont.lfItalic,
			pWindowInfo->LogFont.lfUnderline,
			pWindowInfo->LogFont.lfStrikeOut,
			pWindowInfo->LogFont.lfCharSet,
			pWindowInfo->LogFont.lfOutPrecision,
			pWindowInfo->LogFont.lfClipPrecision,
			pWindowInfo->LogFont.lfQuality,
			pWindowInfo->LogFont.lfPitchAndFamily,
			pWindowInfo->LogFont.lfFaceName);
		i2+=lstrlen(buffer+i2);

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}

	//wiɎgpuV`
	lstrcpy(buffer+i2,"Dim h3DFaceBrush As HBRUSH\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"h3DFaceBrush=CreateSolidBrush(GetSysColor(COLOR_3DFACE))\r\n");
	i2+=lstrlen(buffer+i2);
	i=0;
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		if(pWindowInfo->GetBackgroundColor()<=0&&
			pWindowInfo->GetBackgroundColor()!=-(int)RGB(255,255,255)&&
			pWindowInfo->GetBackgroundColor()!=-(int)RGB(0,0,0)){
				sprintf(buffer+i2,"Dim _RadSys_hBackBrush%d As HBRUSH\r\n",i);
				i2+=lstrlen(buffer+i2);
				sprintf(buffer+i2,"_RadSys_hBackBrush%d=CreateSolidBrush(%d)\r\n",i,-pWindowInfo->GetBackgroundColor());
				i2+=lstrlen(buffer+i2);
		}
		if(pWindowInfo->GetBackgroundColor()>=0x1000){
				sprintf(buffer+i2,"Dim _RadSys_hBackBrush%d As HBRUSH\r\n",i);
				i2+=lstrlen(buffer+i2);
				sprintf(buffer+i2,"_RadSys_hBackBrush%d=CreatePatternBrush(LoadImage(GetModuleHandle(0),%s,IMAGE_BITMAP,0,0,LR_DEFAULTSIZE or LR_SHARED))\r\n",
					i,
					projectInfo.resourceManager.bitmapResources[pWindowInfo->GetBackgroundColor()-0x1000].idName.c_str());
				i2+=lstrlen(buffer+i2);
		}

		i++;
	}

	lstrcpy(buffer+i2,"\r\n");
	i2+=lstrlen(buffer+i2);

	//C[W {bNXp̕ϐ`
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		BOOST_FOREACH( const ActiveBasic::PM::ChildWindowInfo *pChildInfo, pWindowInfo->childWindowInfos )
		{
			if(pChildInfo->Control==CT_IMAGEBOX){
				if((pChildInfo->GetStyle()&0x000F)==SS_ICON||
					(pChildInfo->GetStyle()&0x000F)==SS_BITMAP){
					sprintf(buffer+i2,"Dim hImage_%s_%s As HANDLE\r\n",pWindowInfo->GetName().c_str(),pChildInfo->GetName().c_str());
					i2+=lstrlen(buffer+i2);

					while(i2>65535*(size-1)){
						size++;
						buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
					}
				}
			}
		}
	}

	lstrcpy(buffer+i2,"\r\n");
	i2+=lstrlen(buffer+i2);

	//j[쐬
	for(i=0;i<projectInfo.NumberOfMenu;i++){
		sprintf(temporary,"hMenu_%s",projectInfo.pMenuInfo[i].IdName);

		//InsertMenuItemS
		i2+=GetMakeMenuCommand(projectInfo.pMenuInfo[i].pMenuInfo,projectInfo.pMenuInfo[i].NumberOfMenu,temporary,buffer+i2,1);

		lstrcpy(buffer+i2,"\r\n");
		i2+=lstrlen(buffer+i2);

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}


	//////////////////////////
	//IuWFNg̉
	sprintf(buffer+i2,"Sub %s_DestroyObjects()\r\n",projectInfo.GetName().c_str());
	i2+=lstrlen(buffer+i2);

	//j[
	for(i=0;i<projectInfo.NumberOfMenu;i++){
		sprintf(temporary,"hMenu_%s",projectInfo.pMenuInfo[i].IdName);
		i2+=GetDestroyMenuCommand(projectInfo.pMenuInfo[i].pMenuInfo,projectInfo.pMenuInfo[i].NumberOfMenu,temporary,buffer+i2);

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}

	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		//tHgnh
		sprintf(buffer+i2,"\tDeleteObject(hFont_%s)\r\n",pWindowInfo->GetName().c_str());
		i2+=lstrlen(buffer+i2);

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
	}

	//wiuV
	lstrcpy(buffer+i2,"\tDeleteObject(h3DFaceBrush)\r\n");
	i2+=lstrlen(buffer+i2);
	i=0;
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		if(pWindowInfo->GetBackgroundColor()<=0&&
			pWindowInfo->GetBackgroundColor()!=-(int)RGB(255,255,255)&&
			pWindowInfo->GetBackgroundColor()!=-(int)RGB(0,0,0)){
				sprintf(buffer+i2,"\tDeleteObject(_RadSys_hBackBrush%d)\r\n",i);
				i2+=lstrlen(buffer+i2);
		}
		i++;
	}

	sprintf(buffer+i2,"End Sub\r\n\r\n");
	i2+=lstrlen(buffer+i2);

	//[U[`̃R[obN֐݂邩ǂ
	BOOL bAvailUserProc[MAX_WNDNUM];


	i=0;
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		if(i!=0){
			lstrcpy(buffer+i2,"\r\n");
			i2+=lstrlen(buffer+i2);
		}

		//////////////////////////
		//R[obN֐𐶐

		//bZ[W𒊏o
		ITEMEVENTINFO *pItemEventInfo;
		char **ppNames=GetProcedureNamesOfMessageCall(i,&pItemEventInfo,&i3,&bAvailUserProc[i]);

		sprintf(buffer+i2,"Function EventCall_%s(hWnd As HWND, message As DWord, wParam As WPARAM, lParam As LPARAM) As LRESULT\r\n",pWindowInfo->GetName().c_str());
		i2+=lstrlen(buffer+i2);

		lstrcpy(buffer+i2,"\tSelect Case message\r\n");
		i2+=lstrlen(buffer+i2);

		//ʏ탁bZ[WS
		for(i4=0,sw1=0,sw2=0,sw3=0,sw4=0;i4<i3;i4++){
			i5=GetCommandByMessage(i,ppNames[i4],1,buffer+i2,"\t\t");
			i2+=lstrlen(buffer+i2);
			if(i5==WM_CREATE) sw1=1;
			else if(i5==WM_DESTROY) sw2=1;
			else if(i5==WM_CLOSE) sw3=1;
			else if(i5==WM_NOTIFY) sw4=1;
			HeapDefaultFree(ppNames[i4]);
		}
		HeapDefaultFree(ppNames);

		//WM_CREATEAWM_DESTROYAWM_PAINTĂяoĂȂꍇ
		if(!sw1){
			GetCommandByMessage(i,"Create",0,buffer+i2,"\t\t");
			i2+=lstrlen(buffer+i2);
		}
		if(!sw2){
			GetCommandByMessage(i,"Destroy",0,buffer+i2,"\t\t");
			i2+=lstrlen(buffer+i2);
		}
		if(!sw3){
			GetCommandByMessage(i,"QueryClose",0,buffer+i2,"\t\t");
			i2+=lstrlen(buffer+i2);
		}

		//ACebZ[WSiWM_NOTIFYj
		if(pItemEventInfo[0].IdName){
			i3=i2;
			lstrcpy(buffer+i2,"\t\tCase WM_NOTIFY\r\n");
			i2+=lstrlen(buffer+i2);
			if(sw4){
				sprintf(buffer+i2,"\t\t\t%s_Notify(ByVal (lParam As *NMHDR))\r\n",pWindowInfo->GetName().c_str());
				i2+=lstrlen(buffer+i2);
			}
			lstrcpy(buffer+i2,"\t\t\tDim pnmHdr As *NMHDR\r\n");
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"\t\t\tpnmHdr=lParam As *NMHDR\r\n");
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"\t\t\tSelect Case LOWORD(wParam)\r\n");
			i2+=lstrlen(buffer+i2);

			if(GetNotifyCommandByItemMessage(pWindowInfo,pItemEventInfo,buffer+i2,"\t\t\t\t")){
				i2+=lstrlen(buffer+i2);

				lstrcpy(buffer+i2,"\t\t\tEnd Select\r\n");
				i2+=lstrlen(buffer+i2);
			}
			else{
				//WM_NOTIFY폜
				i2=i3;
				if(sw4) goto DefaultNotifyEvent;
			}
		}
		else if(sw4){
DefaultNotifyEvent:
			lstrcpy(buffer+i2,"\t\tCase WM_NOTIFY\r\n");
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"\t\t\t%s_Notify(ByVal (lParam As *NMHDR))\r\n",pWindowInfo->GetName().c_str());
			i2+=lstrlen(buffer+i2);
		}

		//ACebZ[WSiWM_COMMANDj
		if(pItemEventInfo[0].IdName){
			lstrcpy(buffer+i2,"\t\tCase WM_COMMAND\r\n");
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"\t\t\tSelect Case LOWORD(wParam)\r\n");
			i2+=lstrlen(buffer+i2);

			//pItemEventInfoIdNameAEventNameõ͂̊֐ōs
			GetCommandByItemMessage(pWindowInfo,pItemEventInfo,buffer+i2,"\t\t\t\t");
			i2+=lstrlen(buffer+i2);

			lstrcpy(buffer+i2,"\t\t\tEnd Select\r\n");
			i2+=lstrlen(buffer+i2);
		}
		HeapDefaultFree(pItemEventInfo);

		// DefWindowProc֐
		lstrcpy(buffer+i2,"\t\tCase Else\r\n");
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"\t\t\tEventCall_%s=DefWindowProc(hWnd,message,wParam,lParam)\r\n",pWindowInfo->GetName().c_str());
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\t\tExit Function\r\n");
		i2+=lstrlen(buffer+i2);

		lstrcpy(buffer+i2,"\tEnd Select\r\n");
		i2+=lstrlen(buffer+i2);

		sprintf(buffer+i2,"\tEventCall_%s=0\r\n",pWindowInfo->GetName().c_str());
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"End Function\r\n");
		i2+=lstrlen(buffer+i2);

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}

		i++;
	}


	//////////////////////////
	//_CAO{bNX֘A

	//NXo^
	lstrcpy(buffer+i2,"\r\nFunction DefaultCallProc(hWnd As HWND, message As DWord, wParam As WPARAM, lParam As LPARAM) As LRESULT\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\tDefaultCallProc=DefWindowProc(hWnd,message,wParam,lParam)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"End Function\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\r\nDim _RadSys_dlgwcl As WNDCLASSEX\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"FillMemory(VarPtr(_RadSys_dlgwcl),Len(_RadSys_dlgwcl),0)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.cbSize=Len(_RadSys_dlgwcl)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.hInstance=GetModuleHandle(0)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.style=CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.hIcon=LoadIcon(NULL,MAKEINTRESOURCE(IDI_APPLICATION))\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.hIconSm=LoadIcon(NULL,MAKEINTRESOURCE(IDI_WINLOGO))\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.hCursor=LoadCursor(NULL,MAKEINTRESOURCE(IDC_ARROW))\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.lpszClassName=\"NORMALDLG\"\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.hbrBackground=h3DFaceBrush\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_dlgwcl.lpfnWndProc=AddressOf(DefaultCallProc)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"RegisterClassEx(_RadSys_dlgwcl)\r\n");
	i2+=lstrlen(buffer+i2);

	//DialogBox֐
	lstrcpy(buffer+i2,"\r\nFunction DialogBox(hOwnerWnd As HWND, TemplateName As LPSTR) As LONG_PTR\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\tDim hDlg As HWND\r\n");
	i2+=lstrlen(buffer+i2);
	sw1=0;
	i=0;
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		if( pWindowInfo->IsModalDlg() )
		{
			if(sw1==0){
				sprintf(buffer+i2,"\tIf lstrcmp(TemplateName,\"%s\")=0 Then\r\n",pWindowInfo->GetName().c_str());
				i2+=lstrlen(buffer+i2);
				sw1=1;
			}
			else{
				sprintf(buffer+i2,"\tElseIf lstrcmp(TemplateName,\"%s\")=0 Then\r\n",pWindowInfo->GetName().c_str());
				i2+=lstrlen(buffer+i2);
			}
			sprintf(buffer+i2,"\t\t%s=CreateWindowEx(&H%08x,\"NORMALDLG\",\"%s\",&H%08x,%d,%d,%d,%d,hOwnerWnd,NULL As HMENU,GetModuleHandle(0),0)\r\n",
				pWindowInfo->GetHandleName().c_str(),
				pWindowInfo->GetExStyle(),
				pWindowInfo->GetCaption().c_str(),
				pWindowInfo->GetStyle(),
				pWindowInfo->pos.x,
				pWindowInfo->pos.y,
				pWindowInfo->size.cx,
				pWindowInfo->size.cy);
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"\t\thDlg=%s\r\n",
				pWindowInfo->GetHandleName().c_str());
			i2+=lstrlen(buffer+i2);
			if(bAvailUserProc[i]){
				sprintf(buffer+i2,"\t\tSetWindowLongPtr(%s,GWLP_WNDPROC,AddressOf(%s) As LONG_PTR)\r\n",
					pWindowInfo->GetHandleName().c_str(),
					pWindowInfo->GetCallbackName().c_str());
			}
			else{
				sprintf(buffer+i2,"\t\tSetWindowLongPtr(%s,GWLP_WNDPROC,AddressOf(EventCall_%s) As LONG_PTR)\r\n",
					pWindowInfo->GetHandleName().c_str(),
					pWindowInfo->GetName().c_str());
			}
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"\t\tSendMessage(%s,WM_INITDIALOG,0,0)\r\n",pWindowInfo->GetHandleName().c_str());
			i2+=lstrlen(buffer+i2);
			if( pWindowInfo->HasIcon() )
			{
				sprintf(buffer+i2,"\t\tSendMessage(%s,WM_SETICON,ICON_SMALL,LoadIcon(GetModuleHandle(0),MAKEINTRESOURCE(%s)) As LPARAM)\r\n",pWindowInfo->GetHandleName().c_str(),pWindowInfo->GetIconResourceName().c_str());
				i2+=lstrlen(buffer+i2);
			}
			sprintf(buffer+i2,"\t\tShowWindow(%s,SW_SHOW)\r\n",pWindowInfo->GetHandleName().c_str());
			i2+=lstrlen(buffer+i2);
		}
		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
		i++;
	}
	if(sw1){
		lstrcpy(buffer+i2,"\tElse\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tExit Function\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tEnd If\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tEnableWindow(hOwnerWnd,0)\r\n\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tDim msg As MSG, iResult As Long\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tDo\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tiResult=GetMessage(msg,0,0,0)\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tIf iResult=0 or iResult=-1 Then Exit Do\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tIf IsDialogMessage(hDlg,msg) Then Continue\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tTranslateMessage(msg)\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\t\tDispatchMessage(msg)\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tLoop\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"\tDialogBox=msg.wParam\r\n");
		i2+=lstrlen(buffer+i2);
	}
	lstrcpy(buffer+i2,"End Function\r\n");
	i2+=lstrlen(buffer+i2);

	//EndDialog֐
	lstrcpy(buffer+i2,"Sub EndDialog(hWnd As HWND, lResult As Long)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\tEnableWindow(GetWindow(hWnd,GW_OWNER),1)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\tDestroyWindow(hWnd)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"\tPostMessage(0,WM_QUIT,lResult,0)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"End Sub\r\n");
	i2+=lstrlen(buffer+i2);

	//CreateDialog֐
	lstrcpy(buffer+i2,"\r\nFunction CreateDialog(hOwnerWnd As HWND, TemplateName As LPSTR) As HWND\r\n");
	i2+=lstrlen(buffer+i2);
	i=0;
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		if( pWindowInfo->IsModelessDlg() )
		{
			sprintf(buffer+i2,"\tIf lstrcmp(TemplateName,\"%s\")=0 Then\r\n",pWindowInfo->GetName().c_str());
			i2+=lstrlen(buffer+i2);

			sprintf(buffer+i2,"\t\t%s=CreateWindowEx(&H%08x,\"NORMALDLG\",\"%s\",&H%08x,%d,%d,%d,%d,hOwnerWnd,NULL As HMENU,GetModuleHandle(0),0)\r\n",
				pWindowInfo->GetHandleName().c_str(),
				pWindowInfo->GetExStyle(),
				pWindowInfo->GetCaption().c_str(),
				pWindowInfo->GetStyle(),
				pWindowInfo->pos.x,
				pWindowInfo->pos.y,
				pWindowInfo->size.cx,
				pWindowInfo->size.cy);
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"\t\tCreateDialog=%s\r\n",pWindowInfo->GetHandleName().c_str());
			i2+=lstrlen(buffer+i2);
			if(bAvailUserProc[i]){
				sprintf(buffer+i2,"\t\tSetWindowLongPtr(%s,GWLP_WNDPROC,AddressOf(%s) As LONG_PTR)\r\n",
					pWindowInfo->GetHandleName().c_str(),
					pWindowInfo->GetCallbackName().c_str());
			}
			else{
				sprintf(buffer+i2,"\t\tSetWindowLongPtr(%s,GWLP_WNDPROC,AddressOf(EventCall_%s) As LONG_PTR)\r\n",
					pWindowInfo->GetHandleName().c_str(),
					pWindowInfo->GetName().c_str());
			}
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"\t\tSendMessage(%s,WM_INITDIALOG,0,0)\r\n",pWindowInfo->GetHandleName().c_str());
			i2+=lstrlen(buffer+i2);
			if( pWindowInfo->HasIcon() )
			{
				sprintf(buffer+i2,"\t\tSendMessage(%s,WM_SETICON,ICON_SMALL,LoadIcon(GetModuleHandle(0),MAKEINTRESOURCE(%s)) As LPARAM)\r\n",pWindowInfo->GetHandleName().c_str(),pWindowInfo->GetIconResourceName().c_str());
				i2+=lstrlen(buffer+i2);
			}
			sprintf(buffer+i2,"\tEnd If\r\n",pWindowInfo->GetName().c_str());
			i2+=lstrlen(buffer+i2);
		}
		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}
		i++;
	}
	lstrcpy(buffer+i2,"End Function\r\n");
	i2+=lstrlen(buffer+i2);


	///////////////////////
	// ۑiCallback.wbpj
	sprintf(temporary,"%sCallback.wbp",projectInfo.GetWorkDir().GetPath().c_str() );
	WriteBuffer(temporary,buffer,i2);



	lstrcpy(buffer,"'̃t@C̓EBhE`t@Ci*.wndjƂɐĂ܂\r\n\r\n");
	i2=lstrlen(buffer);

	lstrcpy(buffer+i2,"Dim _RadSys_wcl As WNDCLASSEX\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"FillMemory(VarPtr(_RadSys_wcl),Len(_RadSys_wcl),0)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_wcl.cbSize=Len(_RadSys_wcl)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_wcl.hInstance=GetModuleHandle(0)\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_wcl.style=CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS\r\n");
	i2+=lstrlen(buffer+i2);
	lstrcpy(buffer+i2,"_RadSys_wcl.hCursor=LoadCursor(NULL,MAKEINTRESOURCE(IDC_ARROW))\r\n");
	i2+=lstrlen(buffer+i2);

	i=0;
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		if( pWindowInfo->IsDefaultWindow() )
		{
			//////////////////////
			//ʏEBhE쐬

			lstrcpy(buffer+i2,"\r\n");
			i2+=2;

			if( pWindowInfo->HasIcon() )
			{
				sprintf(buffer+i2,"_RadSys_wcl.hIcon=LoadIcon(_RadSys_wcl.hInstance,MAKEINTRESOURCE(%s))\r\n",pWindowInfo->GetIconResourceName().c_str());
				i2+=lstrlen(buffer+i2);
				sprintf(buffer+i2,"_RadSys_wcl.hIconSm=LoadIcon(_RadSys_wcl.hInstance,MAKEINTRESOURCE(%s))\r\n",pWindowInfo->GetIconResourceName().c_str());
				i2+=lstrlen(buffer+i2);
			}
			else{
				lstrcpy(buffer+i2,"_RadSys_wcl.hIcon=LoadIcon(NULL,MAKEINTRESOURCE(IDI_APPLICATION))\r\n");
				i2+=lstrlen(buffer+i2);
				lstrcpy(buffer+i2,"_RadSys_wcl.hIconSm=LoadIcon(NULL,MAKEINTRESOURCE(IDI_WINLOGO))\r\n");
				i2+=lstrlen(buffer+i2);
			}

			sprintf(buffer+i2,"_RadSys_wcl.lpszClassName=\"NORMAL%d\"\r\n",i);
			i2+=lstrlen(buffer+i2);
			if(bAvailUserProc[i])
				sprintf(buffer+i2,"_RadSys_wcl.lpfnWndProc=AddressOf(%s)\r\n",pWindowInfo->GetCallbackName().c_str());
			else sprintf(buffer+i2,"_RadSys_wcl.lpfnWndProc=AddressOf(EventCall_%s)\r\n",pWindowInfo->GetName().c_str());
			i2+=lstrlen(buffer+i2);
			if(pWindowInfo->GetBackgroundColor()==COLOR_3DFACE)
				lstrcpy(buffer+i2,"_RadSys_wcl.hbrBackground=h3DFaceBrush\r\n");
			else if(pWindowInfo->GetBackgroundColor()==-(int)RGB(255,255,255))
				lstrcpy(buffer+i2,"_RadSys_wcl.hbrBackground=GetStockObject(WHITE_BRUSH)\r\n");
			else if(pWindowInfo->GetBackgroundColor()==-(int)RGB(0,0,0))
				lstrcpy(buffer+i2,"_RadSys_wcl.hbrBackground=GetStockObject(BLACK_BRUSH)\r\n");
			else if(pWindowInfo->GetBackgroundColor()<=0||
				pWindowInfo->GetBackgroundColor()>=0x1000){
				//Fw܂̓rbg}bv
				sprintf(buffer+i2,"_RadSys_wcl.hbrBackground=_RadSys_hBackBrush%d\r\n",i);
			}
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"RegisterClassEx(_RadSys_wcl)\r\n");
			i2+=lstrlen(buffer+i2);
			sprintf(buffer+i2,"CreateWindowEx(&H%08x,\"%s%d\",\"%s\",&H%08x,%d,%d,%d,%d,0,0,GetModuleHandle(0),0)\r\n",
				pWindowInfo->GetExStyle(),
				pWindowInfo->GetClassName().c_str(), i,
				pWindowInfo->GetCaption().c_str(),
				pWindowInfo->GetStyle(),
				pWindowInfo->pos.x,
				pWindowInfo->pos.y,
				pWindowInfo->size.cx,
				pWindowInfo->size.cy);
			i2+=lstrlen(buffer+i2);
		}

		while(i2>65535*(size-1)){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,65535*size);
		}

		i++;
	}


	/////////////////////////
	// ۑiMakeWindow.wbpj
	sprintf(temporary,"%sMakeWindow.wbp",projectInfo.GetWorkDir().GetPath().c_str());
	WriteBuffer(temporary,buffer,i2);
	HeapDefaultFree(buffer);
}
int GetSaveMenuData(char *buffer,int SpaceNum,MENU_INFO *pMenuInfo,int ItemNum){
	int i,i2;
	char spaces[MAX_PATH];

	memset(spaces,' ',SpaceNum*4);
	spaces[SpaceNum*4]=0;

	for(i=0,i2=0;i<ItemNum;i++){
		if(pMenuInfo[i].pMenuInfo){
			sprintf(buffer+i2,"%sPOPUP     = \"%s\",%d\r\n",spaces,pMenuInfo[i].caption,pMenuInfo[i].state);
			i2+=lstrlen(buffer+i2);
			i2+=GetSaveMenuData(buffer+i2,SpaceNum+1,pMenuInfo[i].pMenuInfo,pMenuInfo[i].NumberOfMenu);
			sprintf(buffer+i2,"%sEND\r\n",spaces);
			i2+=lstrlen(buffer+i2);
		}
		else if(pMenuInfo[i].type==MFT_STRING){
			sprintf(buffer+i2,"%sITEM      = %s,\"%s\",%d\r\n",spaces,pMenuInfo[i].IdName,pMenuInfo[i].caption,pMenuInfo[i].state);
			i2+=lstrlen(buffer+i2);
		}
		else if(pMenuInfo[i].type==MFT_SEPARATOR){
			sprintf(buffer+i2,"%sSEPARATOR\r\n",spaces);
			i2+=lstrlen(buffer+i2);
		}
	}
	return i2;
}
void SaveWindowFile( char const *path, const ActiveBasic::PM::WindowInfos &windowInfos )
{
	extern HANDLE hHeap;
	int i,i2,size;
	char *buffer,*temporary;

	size=2;
	buffer=(char *)HeapAlloc(hHeap,0,GENERAL_SIZE*size);
	i2=0;
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, windowInfos )
	{
		sprintf(buffer+i2,"WINDOW:%s\r\n",pWindowInfo->GetName().c_str());
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    POINT     = %d,%d\r\n",pWindowInfo->pos.x,pWindowInfo->pos.y);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    SIZE      = %d,%d\r\n",pWindowInfo->size.cx,pWindowInfo->size.cy);
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    CAPTION   = \"%s\"\r\n",pWindowInfo->GetCaption().c_str());
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    STYLE     = &H%08x\r\n",pWindowInfo->GetStyle());
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    EXSTYLE   = &H%08x\r\n",pWindowInfo->GetExStyle());
		i2+=lstrlen(buffer+i2);
		if( pWindowInfo->HasMenu() )
		{
			sprintf(buffer+i2,"    MENUID    = %s\r\n",pWindowInfo->GetMenuIdName().c_str());
			i2+=lstrlen(buffer+i2);
		}
		sprintf(buffer+i2,"    BGCOLOR   = %d\r\n",pWindowInfo->GetBackgroundColor());
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    FONT      = %d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,\"%s\"\r\n",
			pWindowInfo->LogFont.lfHeight,
			pWindowInfo->LogFont.lfWidth,
			pWindowInfo->LogFont.lfEscapement,
			pWindowInfo->LogFont.lfOrientation,
			pWindowInfo->LogFont.lfWeight,
			pWindowInfo->LogFont.lfItalic,
			pWindowInfo->LogFont.lfUnderline,
			pWindowInfo->LogFont.lfStrikeOut,
			pWindowInfo->LogFont.lfCharSet,
			pWindowInfo->LogFont.lfOutPrecision,
			pWindowInfo->LogFont.lfClipPrecision,
			pWindowInfo->LogFont.lfQuality,
			pWindowInfo->LogFont.lfPitchAndFamily,
			pWindowInfo->LogFont.lfFaceName);
		i2+=lstrlen(buffer+i2);
		if( pWindowInfo->HasIcon() )
		{
			sprintf(buffer+i2,"    ICONID    = %s\r\n",pWindowInfo->GetIconResourceName().c_str());
			i2+=lstrlen(buffer+i2);
		}
		sprintf(buffer+i2,"    CLASS     = \"%s\"\r\n",pWindowInfo->GetClassName().c_str());
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"    TYPE      = %d\r\n",(DWORD)pWindowInfo->GetType());
		i2+=lstrlen(buffer+i2);
		BOOST_FOREACH( const ActiveBasic::PM::ChildWindowInfo *pChildInfo, pWindowInfo->childWindowInfos )
		{
			temporary=SetCaptionSequence(pChildInfo->GetCaption().c_str());
			sprintf(buffer+i2,"    ITEM      = %s,%d,%d,%d,%d,\"%s\",&H%08x,&H%08x,%d",
				pChildInfo->GetName().c_str(),
				pChildInfo->pos.x,pChildInfo->pos.y,
				pChildInfo->size.cx,pChildInfo->size.cy,
				temporary,
				pChildInfo->GetStyle(),
				pChildInfo->GetExStyle(),
				pChildInfo->Control
			);
			i2+=lstrlen(buffer+i2);
			HeapDefaultFree(temporary);
			if(pChildInfo->Control==CT_IMAGEBOX){
				sprintf(buffer+i2,",%d,\"%s\"",pChildInfo->image.type,pChildInfo->image.path.c_str());
				i2+=lstrlen(buffer+i2);
			}
			lstrcpy(buffer+i2,"\r\n");
			i2+=lstrlen(buffer+i2);
			if(i2-GENERAL_SIZE<GENERAL_SIZE){
				size++;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,GENERAL_SIZE*size);
			}
		}
		sprintf(buffer+i2,"END\r\n",pWindowInfo->GetName().c_str());
		i2+=lstrlen(buffer+i2);
		if(i2-GENERAL_SIZE<GENERAL_SIZE){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,GENERAL_SIZE*size);
		}
	}
	for(i=0;i<projectInfo.NumberOfMenu;i++){
		sprintf(buffer+i2,"MENU:%s\r\n",projectInfo.pMenuInfo[i].IdName);
		i2+=lstrlen(buffer+i2);
		i2+=GetSaveMenuData(buffer+i2,1,projectInfo.pMenuInfo[i].pMenuInfo,projectInfo.pMenuInfo[i].NumberOfMenu);
		sprintf(buffer+i2,"END\r\n",windowInfos[i]->GetName().c_str());
		i2+=lstrlen(buffer+i2);
		if(i2-GENERAL_SIZE<GENERAL_SIZE){
			size++;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,GENERAL_SIZE*size);
		}
	}
	WriteBuffer(path,buffer,i2);
	HeapDefaultFree(buffer);

	projectInfo.ModifyOfMaterial=0;
}

MENU_INFO *GetMenuData(char *buffer,int *pPos,int *pMenuNum){
	extern HANDLE hHeap;
	int i,i2,i3,i4;
	char temporary[MAX_PATH],*temp2,temp3[MAX_PATH];
	MENU_INFO *pMenuInfo;

	temp2=(char *)HeapAlloc(hHeap,0,lstrlen(buffer)+1);

	*pMenuNum=0;
	pMenuInfo=(MENU_INFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);

	for(i=*pPos;;i++){
		if(buffer[i]=='\0') return 0;
		if((buffer[i]=='\r'&&buffer[i+1]=='\n')||i==0){
			if(buffer[i]=='\r'&&buffer[i+1]=='\n')  i+=2;
			for(i2=0;;i++,i2++){
				if(!IsVariableChar(buffer[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(i2==0){
				i--;
				continue;
			}
			if(buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temp2[i2]=0;
						break;
					}
					temp2[i2]=buffer[i];
				}
			}
			else{
				temp2[0]=0;
				i2=0;
			}


			if(lstrcmpi(temporary,"POPUP")==0){
				(*pMenuNum)++;
				pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pMenuInfo,(*pMenuNum)*sizeof(MENU_INFO));
				i3=*pMenuNum-1;

				i4=GetOneParameter(temp2,0,temp3);
				RemoveStringQuotes(temp3);
				pMenuInfo[i3].caption=(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
				lstrcpy(pMenuInfo[i3].caption,temp3);

				i4=GetOneParameter(temp2,i4,temp3);
				pMenuInfo[i3].state=GetValue(temp3);

				pMenuInfo[i3].pMenuInfo=GetMenuData(buffer,&i,&pMenuInfo[i3].NumberOfMenu);
			}
			else if(lstrcmpi(temporary,"ITEM")==0){
				(*pMenuNum)++;
				pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pMenuInfo,(*pMenuNum)*sizeof(MENU_INFO));
				i3=*pMenuNum-1;

				i4=GetOneParameter(temp2,0,temp3);
				pMenuInfo[i3].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
				lstrcpy(pMenuInfo[i3].IdName,temp3);

				i4=GetOneParameter(temp2,i4,temp3);
				RemoveStringQuotes(temp3);
				pMenuInfo[i3].caption=(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
				lstrcpy(pMenuInfo[i3].caption,temp3);

				i4=GetOneParameter(temp2,i4,temp3);
				pMenuInfo[i3].state=GetValue(temp3);

				pMenuInfo[i3].type=0;
			}
			else if(lstrcmpi(temporary,"SEPARATOR")==0){
				(*pMenuNum)++;
				pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,pMenuInfo,(*pMenuNum)*sizeof(MENU_INFO));
				i3=*pMenuNum-1;

				pMenuInfo[i3].type=MFT_SEPARATOR;
			}
			else if(lstrcmpi(temporary,"END")==0) break;
			i--;
		}
	}
	*pPos=i;

	HeapDefaultFree(temp2);

	return pMenuInfo;
}
_int8 OpenWindowFile(char *path){
	extern HANDLE hHeap;
	int i,i2,i3,i4,i5;
	char *buffer,temporary[MAX_PATH],*temp2,temp3[MAX_PATH];

	buffer=ReadBuffer(path);
	if(!buffer) return 0;
	temp2=(char *)HeapAlloc(hHeap,0,lstrlen(buffer)+1);
	ChangeOrSignToDivision(temp2,buffer);
	KillSpaces(temp2,buffer);
	//temp2͂̌̏̈ꎞۑobt@ɂp̂ŉȂ

	projectInfo.NumberOfMenu=0;
	projectInfo.pMenuInfo=(MENU_INFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);

	projectInfo.windowInfos.Clear();

	for(i=0,i3=0;;i++){
		if(buffer[i]=='\0') break;
		if((buffer[i]=='\r'&&buffer[i+1]=='\n')||i==0){
			if(buffer[i]=='\r'&&buffer[i+1]=='\n')  i+=2;
			for(i2=0;;i++,i2++){
				if(!IsVariableChar(buffer[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(i2==0){
				i--;
				continue;
			}
			if(buffer[i]==':'||buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temp2[i2]=0;
						break;
					}
					temp2[i2]=buffer[i];
				}
			}
			else{
				temp2[0]=0;
				i2=0;
			}


			//////////////
			//EBhE
			if(lstrcmpi(temporary,"WINDOW")==0&&i3==0){
				projectInfo.windowInfos.push_back( new ActiveBasic::PM::WindowInfo() );
				i3=1;

				projectInfo.windowInfos.back()->SetName( temp2 );
			}
			else if(lstrcmpi(temporary,"HANDLE")==0&&i3==1){
				//
			}
			else if(lstrcmpi(temporary,"POINT")==0&&i3==1){
				sscanf(temp2,"%d,%d",
					&projectInfo.windowInfos.back()->pos.x,
					&projectInfo.windowInfos.back()->pos.y);
				if(projectInfo.windowInfos.back()->pos.x==-1) projectInfo.windowInfos.back()->pos.x=CW_USEDEFAULT;
				if(projectInfo.windowInfos.back()->pos.y==-1) projectInfo.windowInfos.back()->pos.y=CW_USEDEFAULT;
			}
			else if(lstrcmpi(temporary,"SIZE")==0&&i3==1){
				sscanf(temp2,"%d,%d",
					&projectInfo.windowInfos.back()->size.cx,
					&projectInfo.windowInfos.back()->size.cy);
			}
			else if(lstrcmpi(temporary,"CAPTION")==0&&i3==1){
				if(temp2[0]=='\"'&&temp2[lstrlen(temp2)-1]=='\"'){
					temp2[lstrlen(temp2)-1]=0;
					projectInfo.windowInfos.back()->SetCaption( temp2+1 );
				}
			}
			else if(lstrcmpi(temporary,"STYLE")==0&&i3==1) projectInfo.windowInfos.back()->SetStyle( GetValue(temp2) );
			else if(lstrcmpi(temporary,"EXSTYLE")==0&&i3==1) projectInfo.windowInfos.back()->SetExStyle( GetValue(temp2) );
			else if(lstrcmpi(temporary,"MENUID")==0&&i3==1){
				projectInfo.windowInfos.back()->SetMenuIdName( temp2 );
			}
			else if(lstrcmpi(temporary,"ID")==0&&i3==1)
			{
				// 
			}
			else if(lstrcmpi(temporary,"BGCOLOR")==0&&i3==1){
				projectInfo.windowInfos.back()->SetBackgroundColor( GetValue(temp2) );
				if(projectInfo.dwVersion<=3){
					//vWFNgo[W3ȑÔƂ͐Vlɕϊ
					if(projectInfo.windowInfos.back()->GetBackgroundColor()==-1)
						projectInfo.windowInfos.back()->SetBackgroundColor( -(int)RGB(255,255,255) );
				}
			}
			else if(lstrcmpi(temporary,"FONT")==0&&i3==1){
				i5=GetOneParameter(temp2,0,temp3);
				projectInfo.windowInfos.back()->LogFont.lfHeight=GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfWidth=GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfEscapement=GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfOrientation=GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfWeight=GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfItalic=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfUnderline=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfStrikeOut=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfCharSet=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfOutPrecision=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfClipPrecision=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfQuality=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				projectInfo.windowInfos.back()->LogFont.lfPitchAndFamily=(BYTE)GetValue(temp3);

				i5=GetOneParameter(temp2,i5,temp3);
				RemoveStringQuotes(temp3);
				lstrcpy(projectInfo.windowInfos.back()->LogFont.lfFaceName,temp3);
			}
			else if(lstrcmpi(temporary,"ICONID")==0&&i3==1){
				projectInfo.windowInfos.back()->SetIconResourceName( temp2 );
			}
			else if(lstrcmpi(temporary,"CLASS")==0&&i3==1){
				if(temp2[0]=='\"'&&temp2[lstrlen(temp2)-1]=='\"'){
					temp2[lstrlen(temp2)-1]=0;
					projectInfo.windowInfos.back()->SetClassName( temp2+1 );
				}
			}
			else if(lstrcmpi(temporary,"CALLBACK")==0&&i3==1)
			{
				// 
			}

			//ȑÕo[WƂ̌݊p
			else if(lstrcmpi(temporary,"DLGTMP")==0&&i3==1) projectInfo.windowInfos.back()->SetType( (ActiveBasic::PM::WindowType::EnumType)GetValue(temp2) );

			else if(lstrcmpi(temporary,"TYPE")==0&&i3==1) projectInfo.windowInfos.back()->SetType( (ActiveBasic::PM::WindowType::EnumType)GetValue(temp2) );
			else if(lstrcmpi(temporary,"FILEPATH")==0&&i3==1)
			{
				// 
			}
			else if(lstrcmpi(temporary,"ITEM")==0&&i3==1){
				ActiveBasic::PM::ChildWindowInfo *pChildInfo = new ActiveBasic::PM::ChildWindowInfo();

				//ID
				i5=GetOneParameter(temp2,0,temp3);
				pChildInfo->SetName( temp3 );

				//ʒu
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->pos.x=GetValue(temp3);
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->pos.y=GetValue(temp3);
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->size.cx=GetValue(temp3);
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->size.cy=GetValue(temp3);

				//eLXg
				i5=GetOneParameter(temp2,i5,temp3);
				RemoveStringQuotes(temp3);
				RestoreCaptionSequence(temp3);
				pChildInfo->SetCaption( temp3 );

				//X^C
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->SetStyle( GetValue(temp3) );

				//gX^C
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->SetExStyle( GetValue(temp3) );

				//NX
				i5=GetOneParameter(temp2,i5,temp3);
				pChildInfo->Control=GetValue(temp3);

				if(pChildInfo->Control==CT_IMAGEBOX){
					//C[W {bNX̏ꍇ
					i5=GetOneParameter(temp2,i5,temp3);
					pChildInfo->image.type = (ActiveBasic::PM::ImageReferenceType::EnumType)GetValue(temp3);
					i5=GetOneParameter(temp2,i5,temp3);
					RemoveStringQuotes(temp3);
					pChildInfo->image.path = temp3;
				}

				projectInfo.windowInfos.back()->childWindowInfos.push_back( pChildInfo );
			}


			////////////
			//j[
			else if(lstrcmpi(temporary,"MENU")==0&&i3==0){
				projectInfo.NumberOfMenu++;
				projectInfo.pMenuInfo=(MENU_INFO *)HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,projectInfo.pMenuInfo,projectInfo.NumberOfMenu*sizeof(MENU_INFO));
				i4=projectInfo.NumberOfMenu-1;

				//ID
				projectInfo.pMenuInfo[i4].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(temp2)+1);
				lstrcpy(projectInfo.pMenuInfo[i4].IdName,temp2);
				projectInfo.pMenuInfo[i4].pMenuInfo=GetMenuData(buffer,&i,&projectInfo.pMenuInfo[i4].NumberOfMenu);
				if(!projectInfo.pMenuInfo[i4].pMenuInfo){
					//"EBhE`t@CĂ܂B\n\n%s"
					sprintf(temporary,STRING_ERROR_BROKEN_WNDFILE,path);
					MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);

					HeapDefaultFree(temp2);
					HeapDefaultFree(buffer);
					return 0;
				}
			}


			else if(lstrcmpi(temporary,"END")==0&&i3) i3=0;
			else{
				//"EBhE`t@CĂ܂B\n\n%s"
				sprintf(temporary,STRING_ERROR_BROKEN_WNDFILE,path);
				MessageBox(hOwner,temporary,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);

				HeapDefaultFree(temp2);
				HeapDefaultFree(buffer);
				return 0;
			}
			i--;
		}
	}

	HeapDefaultFree(temp2);
	HeapDefaultFree(buffer);
	return 1;
}

struct NEW_WINDOW{
	char name[MAX_PATH];
	ActiveBasic::PM::WindowType::EnumType type;
};
NEW_WINDOW NewWindow;
BOOL CALLBACK DlgProject_NewWindow(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	char temporary[MAX_PATH],temp2[MAX_PATH];
	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);
			SendDlgItemMessage(hwnd,IDC_MODALDLG,BM_SETCHECK,BST_CHECKED,0);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					GetDlgItemText(hwnd,IDC_WINDOWNAME,NewWindow.name,MAX_PATH);
					if(SendDlgItemMessage(hwnd,IDC_DEFWINDOW,BM_GETCHECK,0,0))
					{
						NewWindow.type = ActiveBasic::PM::WindowType::Default;
					}
					else if(SendDlgItemMessage(hwnd,IDC_MODALDLG,BM_GETCHECK,0,0))
					{
						NewWindow.type = ActiveBasic::PM::WindowType::ModalDlg;
					}
					else if(SendDlgItemMessage(hwnd,IDC_MODELESSDLG,BM_GETCHECK,0,0))
					{
						NewWindow.type = ActiveBasic::PM::WindowType::ModelessDlg;
					}
					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
				case IDC_WINDOWNAME:
					if(HIWORD(wParam)==EN_CHANGE)
					{
						GetDlgItemText(hwnd,IDC_WINDOWNAME,temporary,MAX_PATH);
						if(temporary[0]){
							sprintf(temp2,"h%s",temporary);
							SetDlgItemText(hwnd,IDC_WINDOWHANDLE,temp2);
							sprintf(temp2,"%sProc",temporary);
							SetDlgItemText(hwnd,IDC_WINDOWPROC,temp2);
						}
						else{
							SetDlgItemText(hwnd,IDC_WINDOWHANDLE,"");
							SetDlgItemText(hwnd,IDC_WINDOWPROC,"");
						}
					}
					return 1;
			}
			break;
	}
	return 0;
}
void GetDefaultWindowFont(LOGFONT *LogFont){
	LogFont->lfHeight=-12;
	LogFont->lfWidth=0;
	LogFont->lfEscapement=0;
	LogFont->lfOrientation=0;
	LogFont->lfWeight=FW_REGULAR;
	LogFont->lfItalic=0;
	LogFont->lfUnderline=0;
	LogFont->lfStrikeOut=0;
	LogFont->lfCharSet=SHIFTJIS_CHARSET;
	LogFont->lfOutPrecision=OUT_STROKE_PRECIS;
	LogFont->lfClipPrecision=CLIP_STROKE_PRECIS;
	LogFont->lfQuality=DRAFT_QUALITY;
	LogFont->lfPitchAndFamily=FF_SWISS;
	lstrcpy(LogFont->lfFaceName,"lr oSVbN");
}
void Project_Window_Insert(void){
	extern HANDLE hHeap;
	char temporary[MAX_PATH],temp2[1024];

	if (!ActiveBasic::Resource::DialogBoxAlt(hResInst, IDD_PROJECT_NEWWINDOW, hOwner, DlgProject_NewWindow))
	{
		return;
	}

	//d`FbN
	sprintf(temporary,"%s.sbp",NewWindow.name);
	if(projectInfo.fileSystem.root.IsExistFile(temporary)){
		sprintf(temp2,"\"%s\" t@C͊ɃvWFNgɑ݂܂B",temporary);
		MessageBox(hOwner,temp2,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
		return;
	}
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		if(lstrcmpi(NewWindow.name,pWindowInfo->GetName().c_str())==0){
			//"\"%s\" EBhE͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_WINDOW_IN_PROJECT,pWindowInfo->GetName().c_str());
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	//projectInfo.windowInfos\̃RNVɒǉ
	projectInfo.windowInfos.push_back( new ActiveBasic::PM::WindowInfo() );


	///////////////////////////////////////
	//projectInfo.windowInfos\̂ݒ

	//EBhE
	projectInfo.windowInfos.back()->SetName( NewWindow.name );

	//ʒu
	projectInfo.windowInfos.back()->pos.x=-1;
	projectInfo.windowInfos.back()->pos.y=-1;
	projectInfo.windowInfos.back()->size.cx=480;
	projectInfo.windowInfos.back()->size.cy=360;

	//EBhEeLXg
	projectInfo.windowInfos.back()->SetCaption( NewWindow.name );

	//X^C
	switch(NewWindow.type){
		case ActiveBasic::PM::WindowType::Default:
			//ʏEBhE
			projectInfo.windowInfos.back()->SetStyle( WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_MINIMIZEBOX|WS_MAXIMIZEBOX );
			break;
		case ActiveBasic::PM::WindowType::ModalDlg:
		case ActiveBasic::PM::WindowType::ModelessDlg:
			//_CAO ev[giő剻Aŏ{^ȂāAטgɂj
			projectInfo.windowInfos.back()->SetStyle( WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU );
			break;
	}

	//gX^C
	projectInfo.windowInfos.back()->SetExStyle( 0 );

	//j[
	projectInfo.windowInfos.back()->SetMenuIdName( "" );

	//wiF
	projectInfo.windowInfos.back()->SetBackgroundColor( COLOR_3DFACE );

	//tHg
	GetDefaultWindowFont(&projectInfo.windowInfos.back()->LogFont);

	//ACR
	projectInfo.windowInfos.back()->SetIconResourceName( "" );

	//NX
	lstrcpy(temporary,"NORMAL");
	projectInfo.windowInfos.back()->SetClassName( temporary );

	//^Cv
	projectInfo.windowInfos.back()->SetType( NewWindow.type );



	//////////////////////////
	// bZ[Wt@C
	//////////////////////////

	// ev[ggMainWnd.ab𐶐
	const std::string resultStr = PermutationWndPgmTemplate(
		ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\new_window_template.sbp",
		projectInfo.GetName(),
		(std::string)NewWindow.name,
		(std::string)"h" + NewWindow.name,
		(std::string)NewWindow.name + "Proc"
	);

	sprintf(temporary,"%s%s.ab",projectInfo.GetWorkDir().GetPath().c_str(),projectInfo.windowInfos.back()->GetName().c_str());

	//
	WriteBuffer(temporary,resultStr.c_str(),resultStr.size());
	Project_File_Insert(temporary);



	//////////////////////
	//c[r[ɒǉ

	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=2;
	tv.item.iSelectedImage=2;
	tv.hParent=projectInfo.hWindowTreeItem;
	lstrcpy( temp2, projectInfo.windowInfos.back()->GetName().c_str() );
	tv.item.pszText = temp2;

	projectInfo.windowInfos.back()->hTreeItem=TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem(hMaterialTreeView,projectInfo.windowInfos.back()->hTreeItem);


	projectInfo.ModifyOfMaterial=1;

	NewRadWindow( *projectInfo.windowInfos.back() );
}
void Project_Window_Delete(int WndInfoNum){
	extern HANDLE hHeap;
	int i;

	ActiveBasic::PM::WindowInfo *pWindowInfo = projectInfo.windowInfos[WndInfoNum];

	//EBhEJĂꍇ͕
	for(i=0;i<MdiInfo.size();i++){
		if(MdiInfo[i]->hwnd&&lstrcmpi(pWindowInfo->GetName().c_str(),MdiInfo[i]->path.c_str())==0){
			SendMessage(MdiInfo[i]->hwnd,WM_CLOSE,0,0);
			break;
		}
	}

	//qEBhẼ
	BOOST_FOREACH( ActiveBasic::PM::ChildWindowInfo *pChildWindowInfo, pWindowInfo->childWindowInfos )
	{
		delete pChildWindowInfo;
	}
	pWindowInfo->childWindowInfos.clear();

	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,pWindowInfo->hTreeItem);

	//projectInfo.windowInfos\̂폜
	projectInfo.windowInfos.Erase( WndInfoNum );

	projectInfo.ModifyOfMaterial=1;
}
