#include "stdafx.h"

#include "common.h"

FileListTreeViewCtrl *pobj_FileTree;

WNDPROC OldFileTreeViewProc;

BOOL CALLBACK DlgProject_FileProperty(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	HTREEITEM hTreeItem;
	int i;
	char temporary[MAX_PATH];
	FILETIME LastWriteTime,LocalTime;
	SYSTEMTIME SystemTime;

	switch(message){
		case WM_INITDIALOG:
			{
				SetPosCenter(hwnd);

				hTreeItem = pobj_FileTree->GetSelectedItem();

				std::string tempPath = projectInfo.fileSystem.root.FindFile( hTreeItem ).GetRelationalPath();

				//΃pXA΃pX\
				lstrcpy( temporary, tempPath.c_str() );
				lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );
				SetDlgItemText(hwnd,IDC_USING_FILE,temporary);
				SetDlgItemText(hwnd,IDC_DEFINED_FILE,tempPath.c_str());

				//ŏIXV\
				ATL::CHandle hFile(CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL));
				if(hFile==INVALID_HANDLE_VALUE){
					hFile.Detach();
					//"G["
					lstrcpy(temporary,STRING_ERROR);
				}
				else{
					GetFileTime(hFile,NULL,NULL,&LastWriteTime);
					FileTimeToLocalFileTime(&LastWriteTime,&LocalTime);
					FileTimeToSystemTime(&LocalTime,&SystemTime);
					if(SystemTime.wHour>=12){
						//"ߌ "
						lstrcpy(temporary,STRING_AFTERNOON);
						lstrcat(temporary," ");
						SystemTime.wHour-=12;
					}
					else{
						//"ߑO "
						lstrcpy(temporary,STRING_MORNING);
						lstrcat(temporary," ");
					}
					sprintf(temporary+5,"%02d:%02d:%02d %04d/%02d/%02d",
						SystemTime.wHour,SystemTime.wMinute,SystemTime.wSecond,
						SystemTime.wYear,SystemTime.wMonth,SystemTime.wDay);
				}
				SetDlgItemText(hwnd,IDC_UPDATE_TIME,temporary);


				//////////////
				// `\
				//////////////
				i=GetFileExtension(tempPath.c_str());

				//"Basic vO"
				if(i==FT_BASICPROGRAM) lstrcpy(temporary,STRING_FILETYPE_BASICPROGRAM);
				//"Tu vO"
				else if(i==FT_SUBPROGRAM) lstrcpy(temporary,STRING_FILETYPE_SUBPROGRAM);
				//"eLXg hLg"
				else if(i==FT_TEXT) lstrcpy(temporary,STRING_FILETYPE_TEXT);
				//"ʂł܂"
				else lstrcpy(temporary,STRING_FILETYPE_UNKNOWN);

				SetDlgItemText(hwnd,IDC_FILETYPE,temporary);

				break;
			}
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					EndDialog(hwnd,0);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}

LRESULT CALLBACK FileTreeViewProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	HTREEITEM hTreeItem;
	char temporary[MAX_PATH];
	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDM_FILETREE_INSERT:
					//"vWFNg֑}t@Cw肵ĉ"
					extern LPSTR DefFileFilter;
					if(!GetFilePathDialog(hOwner,temporary,DefFileFilter,STRING_FILEOPENTITLE_INSERTEDPROJECT,1)) break;
					Project_File_Insert(temporary);
					break;
				case IDM_FILETREE_OPEN:
					{
						hTreeItem=TreeView_GetSelection(hwnd);

						if( !projectInfo.fileSystem.root.IsExistFile( hTreeItem ) )
						{
							// c[ACeɑ΂t@C݂ȂitH_Ȃǂ̏ꍇj
							break;
						}

						std::string tempPath = projectInfo.fileSystem.root.FindFile( hTreeItem ).GetRelationalPath();

						lstrcpy( temporary, tempPath.c_str() );
						lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );
						OpenFileWithExtension(temporary);
						break;
					}
				case IDM_FILETREE_DELETE:
					hTreeItem=TreeView_GetSelection(hwnd);
					Project_File_Delete(hTreeItem);
					break;
				case IDM_FILETREE_PROPERTY:
					ActiveBasic::Resource::DialogBoxAlt(hResInst, IDD_PROJECT_FILEPROPERTY, hOwner, DlgProject_FileProperty);
					break;
			}
			return 0;
		case WM_CHAR:
			if(wParam==VK_RETURN){
				SendMessage(hwnd,WM_COMMAND,IDM_FILETREE_OPEN,0);
				//ftHg̃bZ[Wƃr[vĂ܂̂Ŕ
				return 0;
			}
			break;
		case WM_KEYDOWN:
			if(wParam==VK_DELETE){
				SendMessage(hwnd,WM_COMMAND,IDM_FILETREE_DELETE,0);
			}
			break;
		case WM_LBUTTONDBLCLK:
			SendMessage(hwnd,WM_COMMAND,IDM_FILETREE_OPEN,0);
			break;
	}
	return CallWindowProc(OldFileTreeViewProc,hwnd,message,wParam,lParam);
}

FileListTreeViewCtrl::FileListTreeViewCtrl( HWND hParent )
	: CTreeViewCtrl()
{
	this->Create( hParent, NULL, NULL, 
		WS_CHILD | TVS_HASBUTTONS | TVS_HASLINES | TVS_LINESATROOT | TVS_SHOWSELALWAYS,
		WS_EX_CLIENTEDGE
	);

	OldFileTreeViewProc=(WNDPROC)this->GetWindowLongPtr(GWLP_WNDPROC);
	this->SetWindowLongPtr(GWLP_WNDPROC,(long)FileTreeViewProc);

	//C[WXgǂݍ݁Aݒ
	hImageList=ImageList_Create(16,16,ILC_COLOR24|ILC_MASK,3,0);
	ImageList_AddIcon(hImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_FOLDER_CLOSE));
	ImageList_AddIcon(hImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_FOLDER_OPEN));
	ImageList_AddIcon(hImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_TEXTDOCUMENT));
	this->SetImageList(hImageList,TVSIL_NORMAL);
}
FileListTreeViewCtrl::~FileListTreeViewCtrl()
{
	this->DestroyWindow();
	ImageList_Destroy(hImageList);
}

void FileListTreeViewCtrl::ContextMenu(POINT *pPos)
{
	//ENbNɂ郁j[\
	TV_HITTESTINFO tvHitTestInfo;
	tvHitTestInfo.pt=*pPos;
	this->ScreenToClient(&tvHitTestInfo.pt);

	HTREEITEM hTreeItem = this->HitTest(&tvHitTestInfo);
	if(hTreeItem){
		this->SelectItem(hTreeItem);

		extern HMENU hFileTreeMenuBase;
		if(this->GetRootItem()==hTreeItem)
		{
			TrackPopupMenu(GetSubMenu(hFileTreeMenuBase,0),TPM_LEFTALIGN,pPos->x,pPos->y,0,this->m_hWnd,0);
		}
		else
		{
			TrackPopupMenu(GetSubMenu(hFileTreeMenuBase,1),TPM_LEFTALIGN,pPos->x,pPos->y,0,this->m_hWnd,0);
		}
	}
}

HTREEITEM FileListTreeViewCtrl::Insert( const std::string &str )
{
	return this->InsertItem( str.c_str(), 2, 2, this->GetRootItem(), TVI_SORT );
}

void FileListTreeViewCtrl::Reset( HTREEITEM hParent, ActiveBasic::PM::FM::Folder &folder )
{
	char temporary[MAX_PATH],temp2[MAX_PATH];

	lstrcpy( temporary, folder.GetName().c_str() );

	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.hParent = hParent;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText = temporary;
	HTREEITEM hFolder = this->InsertItem( &tv );

	BOOST_FOREACH( ActiveBasic::PM::FM::Folder &childFolder, folder.folders )
	{
		this->Reset( hFolder, childFolder );
	}

	BOOST_FOREACH( ActiveBasic::PM::FM::File &file, folder.files )
	{
		_splitpath(file.GetRelationalPath().c_str(),0,0,temporary,temp2);
		lstrcat(temporary,temp2);

		TV_INSERTSTRUCT tv;
		tv.hInsertAfter=TVI_SORT;
		tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
		tv.hParent = hFolder;
		tv.item.iImage=2;
		tv.item.iSelectedImage=2;
		tv.item.pszText=temporary;
		file.SetTreeViewHandle( this->InsertItem( &tv ) );
	}
}
void FileListTreeViewCtrl::Reset( ActiveBasic::PM::FM::FileSystem &fileSystem )
{
	this->DeleteAllItems();

	this->Reset( TVI_ROOT, fileSystem.root );
}
