#include "stdafx.h"

#include "Common.h"

using namespace ActiveBasic::IDE;

#if defined(JPN)
//{
#include "pj_msg_jpn.h"
#else
//p
#include "pj_msg_eng.h"
#endif

HWND hProjectViewTab;
HWND hProcedureTreeView,hMaterialTreeView;
HIMAGELIST hProcedureTreeViewImageList,hMaterialTreeViewImageList;
WNDPROC OldProcedureTreeViewProc,OldMaterialTreeViewProc;
WNDPROC OldTabProc;

LRESULT CALLBACK ProcedureTreeViewProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	if(message==WM_CHAR&&wParam==VK_RETURN){
		SendMessage(hProjectViewTab,WM_COMMAND,IDM_PROCEDURETREE_SHOW,0);
		//ftHg̃bZ[Wƃr[vĂ܂̂Ŕ
		return 0;
	}
	else if(message==WM_LBUTTONDBLCLK){
		SendMessage(hProjectViewTab,WM_COMMAND,IDM_PROCEDURETREE_SHOW,0);
		return 0;
	}
	return CallWindowProc(OldProcedureTreeViewProc,hwnd,message,wParam,lParam);
}
LRESULT CALLBACK MaterialTreeViewProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	if(message==WM_CHAR&&wParam==VK_RETURN){
		SendMessage(hProjectViewTab,WM_COMMAND,IDM_MATERIALTREE_OPEN,0);
		//ftHg̃bZ[Wƃr[vĂ܂̂Ŕ
		return 0;
	}
	if(message==WM_KEYDOWN&&wParam==VK_DELETE) SendMessage(hProjectViewTab,WM_COMMAND,IDM_MATERIALTREE_DELETE,0);
	return CallWindowProc(OldMaterialTreeViewProc,hwnd,message,wParam,lParam);
}
LRESULT CALLBACK TabProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	extern LPSTR DefFileFilter;
	int i,i2,WndNum;
	char str[MAX_PATH],temporary[MAX_PATH];
	HWND hTree,hChild;
	HTREEITEM hTreeItem,hTreeItem2;
	TV_HITTESTINFO tvHitTestInfo;
	TVITEM tvItem;

	switch(message){
		case WM_CONTEXTMENU:
			i=TabCtrl_GetCurSel(hwnd);
			if(i==0){
				//t@Cc[
				POINT pos;
				pos.x=LOWORD(lParam);
				pos.y=HIWORD(lParam);
				pobj_FileTree->ContextMenu(&pos);
				return 0;
			}
			else if(i==1) hTree=hProcedureTreeView;
			else if(i==2) hTree=hMaterialTreeView;
			tvHitTestInfo.pt.x=LOWORD(lParam);
			tvHitTestInfo.pt.y=HIWORD(lParam);
			ScreenToClient(hTree,&tvHitTestInfo.pt);
			hTreeItem=TreeView_HitTest(hTree,&tvHitTestInfo);
			if(hTreeItem){
				TreeView_SelectItem(hTree,hTreeItem);
				if(i==1){
					extern HMENU hProcedureTreeMenuBase;
					if(TreeView_GetRoot(hTree)!=hTreeItem)
						TrackPopupMenu(GetSubMenu(hProcedureTreeMenuBase,1),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
				}
				else if(i==2){
					extern HMENU hMaterialTreeMenuBase;
					hTreeItem2=TreeView_GetRoot(hTree);
					for(i2=0;;i2++){
						if(hTreeItem2==hTreeItem) break;
						hTreeItem2=TreeView_GetNextSibling(hTree,hTreeItem2);
						if(!hTreeItem2) break;
					}
					if(hTreeItem2){
						if(i2==0)
							TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,0),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
						else if(i2==1)
							TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,2),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
						else if(i2==2)
							TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,4),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
						else if(i2==3)
							TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,6),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
						else if(i2==4)
							TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,8),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
					}
					else{
						hTreeItem=TreeView_GetNextItem(hTree,hTreeItem,TVGN_PARENT);
						hTreeItem2=TreeView_GetRoot(hTree);
						for(i2=0;;i2++){
							if(hTreeItem2==hTreeItem) break;
							hTreeItem2=TreeView_GetNextSibling(hTree,hTreeItem2);
							if(!hTreeItem2) break;
						}
						if(hTreeItem2){
							if(i2==0)
								TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,1),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
							else if(i2==1)
								TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,3),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
							else if(i2==2)
								TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,5),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
							else if(i2==3)
								TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,7),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
							else if(i2==4)
								TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,9),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
						}
					}
				}
			}
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){

				case IDM_PROCEDURETREE_SHOW:
					extern BOOL bSearchingClasses;
					if(bSearchingClasses){
						pobj_ClassTreeView->bShowSwitch=1;
						break;
					}

					hTreeItem=TreeView_GetSelection(hProcedureTreeView);
					for(i=0;i<pobj_ClassTreeView->NumberOfProcedures;i++){
						if(pobj_ClassTreeView->pProcInfo[i].hTreeItem==hTreeItem){

							if( projectInfo.IsOpened() ){
								// Ώۃt@CJ
								lstrcpy(temporary,
									projectInfo.fileSystem.root.FindFile( pobj_ClassTreeView->pProcInfo[i].hFileTreeItem ).GetRelationalPath().c_str());
								lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );
								hChild=OpenFileWithExtension(temporary);
							}
							else{
								hChild = GetWindow(hClient,GW_CHILD);
							}

							//vV[W̍sI
							//ResetScrollbarĕ`掞ɌĂяôŁAĕ`悷
							WndNum=GetWndNum(hChild);
							InvalidateRect(MdiInfo[WndNum]->pMdiTextEdit->hEdit,NULL,0);
							UpdateWindow(MdiInfo[WndNum]->pMdiTextEdit->hEdit);
							TextEdit_SelectOneLine(WndNum,pobj_ClassTreeView->pProcInfo[i].code_pos,TRUE);

							//^C}[Zbg
							// tH[JXGfB^ɃZbg邽
							// ^C~Ox点SetFocussKv
							SetTimer(hwnd,100,10,NULL);

							break;
						}
					}

					break;

				case IDM_MATERIALTREE_INSERTCURSOR:
					Project_CursorResInsert();
					break;
				case IDM_MATERIALTREE_INSERTBITMAP:
					Project_BitmapResInsert();
					break;
				case IDM_MATERIALTREE_INSERTICON:
					Project_IconResInsert();
					break;
				case IDM_MATERIALTREE_INSERTMENU:
					Project_Menu_Insert();
					break;
				case IDM_MATERIALTREE_INSERTWINDOW:
					Project_Window_Insert();
					break;
				case IDM_MATERIALTREE_OPEN:
					hTreeItem=TreeView_GetSelection(hMaterialTreeView);
					for(i=0;i<static_cast<int>(projectInfo.windowInfos.size());i++){
						if(projectInfo.windowInfos[i]->hTreeItem==hTreeItem){
							NewRadWindow( *projectInfo.windowInfos[i] );
							break;
						}
					}
					for(i=0;i<projectInfo.NumberOfMenu;i++){
						if(projectInfo.pMenuInfo[i].hTreeItem==hTreeItem){
							NewMenuWindow(&projectInfo.pMenuInfo[i]);
							break;
						}
					}
					BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, projectInfo.resourceManager.iconResources )
					{
						if( resourceItem.hTreeItem == hTreeItem )
						{
							NewIconEditWindow(
								projectInfo.GetWorkDir().GetFullPath( resourceItem.filepath ).c_str()
							);
							break;
						}
					}
					break;
				case IDM_MATERIALTREE_DELETE:
					hTreeItem=TreeView_GetSelection(hMaterialTreeView);
					for(i=0;i<static_cast<int>(projectInfo.resourceManager.cursorResources.size());i++){
						if(projectInfo.resourceManager.cursorResources[i].hTreeItem==hTreeItem){

							//"%s J[\vWFNg폜܂B낵łH"
							sprintf(str,STRING_PJ_CHECK_DELETECURSOR,projectInfo.resourceManager.cursorResources[i].idName.c_str());
							if(IDCANCEL==MessageBox(hOwner,str,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

							Project_Cursor_Delete(i);
							break;
						}
					}
					for(i=0;i<static_cast<int>(projectInfo.resourceManager.bitmapResources.size());i++){
						if(projectInfo.resourceManager.bitmapResources[i].hTreeItem==hTreeItem){

							//"%s rbg}bvvWFNg폜܂B낵łH"
							sprintf(str,STRING_PJ_CHECK_DELETEBITMAP,projectInfo.resourceManager.bitmapResources[i].idName.c_str());
							if(IDCANCEL==MessageBox(hOwner,str,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

							Project_Bitmap_Delete(i);
							break;
						}
					}
					for(i=0;i<static_cast<int>(projectInfo.resourceManager.iconResources.size());i++){
						if(projectInfo.resourceManager.iconResources[i].hTreeItem==hTreeItem){

							//"%s ACRvWFNg폜܂B낵łH"
							sprintf(str,STRING_PJ_CHECK_DELETEICON,projectInfo.resourceManager.iconResources[i].idName.c_str());
							if(IDCANCEL==MessageBox(hOwner,str,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

							Project_Icon_Delete(i);
							break;
						}
					}
					for(i=0;i<projectInfo.NumberOfMenu;i++){
						if(projectInfo.pMenuInfo[i].hTreeItem==hTreeItem){

							//"%s j[vWFNg폜܂B낵łH"
							sprintf(str,STRING_PJ_CHECK_DELETEMENU,projectInfo.pMenuInfo[i].IdName);
							if(IDCANCEL==MessageBox(hOwner,str,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

							Project_Menu_Delete(i);
							break;
						}
					}
					for(i=0;i<static_cast<int>(projectInfo.windowInfos.size());i++){
						if(projectInfo.windowInfos[i]->hTreeItem==hTreeItem){

							//"%s EBhEvWFNg폜܂B낵łH"
							sprintf(str,STRING_PJ_CHECK_DELETEWINDOW,projectInfo.windowInfos[i]->GetName().c_str());
							if(IDCANCEL==MessageBox(hOwner,str,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

							Project_Window_Delete(i);
							break;
						}
					}
					break;
				case IDM_MENUTREE_RENAMEID:
					extern char NewIdName[MAX_PATH];
					hTreeItem=TreeView_GetSelection(hMaterialTreeView);
					for(i=0;i<static_cast<int>(projectInfo.resourceManager.cursorResources.size());i++){
						if(projectInfo.resourceManager.cursorResources[i].hTreeItem==hTreeItem){
							Project_Cursor_RenameID(i);
							break;
						}
					}
					for(i=0;i<static_cast<int>(projectInfo.resourceManager.bitmapResources.size());i++){
						if(projectInfo.resourceManager.bitmapResources[i].hTreeItem==hTreeItem){
							Project_Bitmap_RenameID(i);
							break;
						}
					}
					for(i=0;i<static_cast<int>(projectInfo.resourceManager.iconResources.size());i++){
						if(projectInfo.resourceManager.iconResources[i].hTreeItem==hTreeItem){
							Project_Icon_RenameID(i);
						}
					}
					for(i=0;i<projectInfo.NumberOfMenu;i++){
						if(projectInfo.pMenuInfo[i].hTreeItem==hTreeItem){
							if (!ActiveBasic::Resource::DialogBoxAlt(hResInst,IDD_INPUTID, hOwner, DlgProject_MenuID_Input, reinterpret_cast<LPARAM>(projectInfo.pMenuInfo[i].IdName)))
							{
								break;
							}

							//d`FbN
							for(i2=0;i2<projectInfo.NumberOfMenu;i2++){
								if(i2==i) continue;
								if(lstrcmp(NewIdName,projectInfo.pMenuInfo[i2].IdName)==0){
									//"ID \"%s\" ͊ɃvWFNgɑ݂܂B"
									sprintf(temporary,STRING_DUPLICATIONERROR_ID_IN_PROJECT,NewIdName);
									MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
									return 0;
								}
							}

							HeapDefaultFree(projectInfo.pMenuInfo[i].IdName);
							projectInfo.pMenuInfo[i].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(NewIdName)+1);
							lstrcpy(projectInfo.pMenuInfo[i].IdName,NewIdName);

							tvItem.hItem=hTreeItem;
							tvItem.mask=TVIF_TEXT;
							tvItem.pszText=projectInfo.pMenuInfo[i].IdName;
							tvItem.cchTextMax=lstrlen(projectInfo.pMenuInfo[i].IdName)+1;
							TreeView_SetItem(hMaterialTreeView,&tvItem);

							projectInfo.ModifyOfMaterial=1;

							TreeView_SortChildren(hMaterialTreeView,
								TreeView_GetParent(hMaterialTreeView,hTreeItem),
								0);
							break;
						}
					}
					break;
				case IDM_MATERIALTREE_ICON_SETMAIN:
					hTreeItem=TreeView_GetSelection(hMaterialTreeView);
					for(i=0;i<static_cast<int>(projectInfo.resourceManager.iconResources.size());i++){
						if(projectInfo.resourceManager.iconResources[i].hTreeItem==hTreeItem){
							if(i==0) break;

							ActiveBasic::Common::ResourceItem tempItem = projectInfo.resourceManager.iconResources[i];
							Jenga::Common::EraseVectorItem<ActiveBasic::Common::ResourceItems>( projectInfo.resourceManager.iconResources, i );
							projectInfo.resourceManager.iconResources.insert( projectInfo.resourceManager.iconResources.begin(), tempItem );

							tvItem.hItem=projectInfo.resourceManager.iconResources[1].hTreeItem;
							tvItem.mask=TVIF_TEXT;
							lstrcpy( temporary, projectInfo.resourceManager.iconResources[1].idName.c_str() );
							tvItem.pszText = temporary;
							tvItem.cchTextMax=lstrlen(temporary)+1;
							TreeView_SetItem(hMaterialTreeView,&tvItem);

							tvItem.hItem=projectInfo.resourceManager.iconResources[0].hTreeItem;
							tvItem.mask=TVIF_TEXT;
							sprintf(temporary,"%s (Main)",projectInfo.resourceManager.iconResources[0].idName.c_str());
							tvItem.pszText=temporary;
							tvItem.cchTextMax=lstrlen(temporary)+1;
							TreeView_SetItem(hMaterialTreeView,&tvItem);

							projectInfo.ModifuOfResource=1;
							break;
						}
					}
					break;
			}
			break;
		case WM_TIMER:
			KillTimer(hwnd,wParam);

			//tH[JXGfB^ɃZbg
			SetFocus(GetWindow(GetWindow(hClient,GW_CHILD),GW_CHILD));
			break;
		case WM_NOTIFY:
			NMHDR *hdr;
			hdr=(NMHDR *)lParam;
			if(hdr->code==NM_DBLCLK){
				if(hdr->hwndFrom==hProcedureTreeView) SendMessage(hwnd,WM_COMMAND,IDM_PROCEDURETREE_SHOW,0);
				else if(hdr->hwndFrom==hMaterialTreeView) SendMessage(hwnd,WM_COMMAND,IDM_MATERIALTREE_OPEN,0);
			}
			if(hdr->code==TVN_ITEMEXPANDEDW||hdr->code==TVN_ITEMEXPANDED){
				NMTREEVIEW *nmTreeView;
				TVITEM tvItem;
				nmTreeView=(NMTREEVIEW *)lParam;
				tvItem.mask=TVIF_HANDLE|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
				tvItem.hItem=nmTreeView->itemNew.hItem;
				TreeView_GetItem(nmTreeView->hdr.hwndFrom,&tvItem);
				if(tvItem.iImage==0||tvItem.iImage==1){
					if(nmTreeView->action==TVE_EXPAND){
						tvItem.iImage=1;
						tvItem.iSelectedImage=1;
					}
					else if(nmTreeView->action==TVE_COLLAPSE){
						tvItem.iImage=0;
						tvItem.iSelectedImage=0;
					}
					tvItem.hItem=nmTreeView->itemNew.hItem;
					TreeView_SetItem(nmTreeView->hdr.hwndFrom,&tvItem);
				}
			}
			break;
	}
	return CallWindowProc(OldTabProc,hwnd,message,wParam,lParam);
}
void ResizeProjectView_ToolWindow(void){
	extern HWND hProjectView_ToolWindow;
	RECT rect;
	GetClientRect(hProjectView_ToolWindow,&rect);
	SendMessage(hProjectView_ToolWindow,WM_SIZE,0,MAKELONG(rect.right,rect.bottom));
}
LRESULT CALLBACK ProjectView_ToolWindowProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HWND hProjectView;
	switch(message){
		case WM_SIZE:
			MoveWindow(hProjectView,0,0,
				LOWORD(lParam),
				HIWORD(lParam),1);
			return 0;
		case WM_CLOSE:
			SendMessage(hOwner,WM_COMMAND,IDM_PROJECTVIEW,0);
			return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}
void ShowFileView(){
	TabCtrl_SetCurSel(hProjectViewTab,0);
	pobj_FileTree->ShowWindow( SW_SHOW );
	ShowWindow(hProcedureTreeView,SW_HIDE);
	ShowWindow(hMaterialTreeView,SW_HIDE);
}
void ShowClassView(){
	TabCtrl_SetCurSel(hProjectViewTab,1);
	pobj_FileTree->ShowWindow( SW_HIDE );
	ShowWindow(hMaterialTreeView,SW_HIDE);
	ShowWindow(hProcedureTreeView,SW_SHOW);
}
void ShowMaterialView(){
	TabCtrl_SetCurSel(hProjectViewTab,2);
	pobj_FileTree->ShowWindow( SW_HIDE );
	ShowWindow(hProcedureTreeView,SW_HIDE);
	ShowWindow(hMaterialTreeView,SW_SHOW);
}
LRESULT CALLBACK ProjectViewProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HINSTANCE hInst,hResInst;
	extern HWND hTabOfProjectView;
	extern HFONT hStatusFont;
	extern HWND hProjectView_ToolWindow;
	RECT rect;
	HWND hButton;

	switch(message){
		case WM_CREATE:
			hProjectViewTab=CreateWindow(WC_TABCONTROL,NULL,
				WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE,
				0,0,0,0,hwnd,0,hInst,0);
			SendMessage(hProjectViewTab,WM_SETFONT,(long)hStatusFont,0);

			hButton=CreateWindow("BUTTON","",WS_CHILD|WS_VISIBLE,
				0,0,30,13,
				hwnd,(HMENU)IDC_CLIP,hInst,0);
			SendMessage(hButton,WM_SETFONT,(long)hStatusFont,0);

			OldTabProc=(WNDPROC)GetWindowLongPtr(hProjectViewTab,GWLP_WNDPROC);
			SetWindowLongPtr(hProjectViewTab,GWLP_WNDPROC,(long)TabProc);

			//^uݒ
			TC_ITEM tcItem;
			tcItem.mask=TCIF_TEXT;
			tcItem.pszText="File";
			TabCtrl_InsertItem(hProjectViewTab,0,&tcItem);
			tcItem.mask=TCIF_TEXT;
			tcItem.pszText="Class";
			TabCtrl_InsertItem(hProjectViewTab,1,&tcItem);
			tcItem.mask=TCIF_TEXT;
			tcItem.pszText="Material";
			TabCtrl_InsertItem(hProjectViewTab,2,&tcItem);

			//t@Cc[r[쐬
			pobj_FileTree = new FileListTreeViewCtrl( hProjectViewTab );

			//NXc[r[쐬
			hProcedureTreeView=CreateWindowEx(WS_EX_CLIENTEDGE,WC_TREEVIEW,"",
				WS_CHILD|TVS_HASLINES|TVS_HASBUTTONS|TVS_LINESATROOT|TVS_SHOWSELALWAYS,
				0,0,0,0,
				hProjectViewTab,0,hInst,0);
			OldProcedureTreeViewProc=(WNDPROC)GetWindowLongPtr(hProcedureTreeView,GWLP_WNDPROC);
			SetWindowLongPtr(hProcedureTreeView,GWLP_WNDPROC,(long)ProcedureTreeViewProc);
			//C[WXgǂݍ݁Aݒ
			hProcedureTreeViewImageList=ImageList_Create(16,16,ILC_COLOR24|ILC_MASK,8,0);
			ImageList_AddIcon(hProcedureTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_FOLDER_CLOSE));
			ImageList_AddIcon(hProcedureTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_FOLDER_OPEN));
			ImageList_AddIcon(hProcedureTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_PROCEDURE));
			ImageList_AddIcon(hProcedureTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_PROGRAM_FOLDER));
			ImageList_AddIcon(hProcedureTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_MEMBER_PUBLIC_VARIABLE));
			ImageList_AddIcon(hProcedureTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_MEMBER_PUBLIC_FUNCTION));
			ImageList_AddIcon(hProcedureTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_MEMBER_PRIVATE_VARIABLE));
			ImageList_AddIcon(hProcedureTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_MEMBER_PRIVATE_FUNCTION));
			TreeView_SetImageList(hProcedureTreeView,hProcedureTreeViewImageList,TVSIL_NORMAL);

			//}eAc[r[쐬
			hMaterialTreeView=CreateWindowEx(WS_EX_CLIENTEDGE,WC_TREEVIEW,"",
				WS_CHILD|TVS_HASLINES|TVS_HASBUTTONS|TVS_LINESATROOT|TVS_SHOWSELALWAYS,
				0,0,0,0,
				hProjectViewTab,0,hInst,0);
			OldMaterialTreeViewProc=(WNDPROC)GetWindowLongPtr(hMaterialTreeView,GWLP_WNDPROC);
			SetWindowLongPtr(hMaterialTreeView,GWLP_WNDPROC,(long)MaterialTreeViewProc);
			//C[WXgǂݍ݁Aݒ
			hMaterialTreeViewImageList=ImageList_Create(16,16,ILC_COLOR24|ILC_MASK,3,0);
			ImageList_AddIcon(hMaterialTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_FOLDER_CLOSE));
			ImageList_AddIcon(hMaterialTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_FOLDER_OPEN));
			ImageList_AddIcon(hMaterialTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_WINDOW));
			ImageList_AddIcon(hMaterialTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_MENU));
			ImageList_AddIcon(hMaterialTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_FILE_ICON));
			ImageList_AddIcon(hMaterialTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_FILE_BMP));
			ImageList_AddIcon(hMaterialTreeViewImageList, ActiveBasic::Resource::LoadIconAlt(hResInst, IDI_FILE_CURSOR));
			TreeView_SetImageList(hMaterialTreeView,hMaterialTreeViewImageList,TVSIL_NORMAL);

			pobj_FileTree->ShowWindow( SW_SHOW );
			GetClientRect(hwnd,&rect);
			SendMessage(hwnd,WM_SIZE,0,MAKELONG(rect.right,rect.bottom));
			return 0;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_CLIP:
					if(pobj_nv->bClipProjectView==0){
						pobj_nv->bClipProjectView=1;

						SetWindowLongPtr(hwnd,GWL_EXSTYLE,WS_EX_STATICEDGE);
						SetParent(hwnd,hOwner);
						ActiveBasic::IDE::Program::mainFrame.Resized();

						ShowWindow(hProjectView_ToolWindow,SW_HIDE);
					}
					else{
						pobj_nv->bClipProjectView=0;

						SetWindowLongPtr(hwnd,GWL_EXSTYLE,0);

						SetParent(hwnd,hProjectView_ToolWindow);

						ActiveBasic::IDE::Program::mainFrame.Resized();
						ResizeProjectView_ToolWindow();

						ShowWindow(hProjectView_ToolWindow,SW_SHOW);
					}
					return 0;
			}
			break;
		case WM_NOTIFY:
			NMHDR *hdr;
			hdr=(NMHDR *)lParam;
			if(hdr->hwndFrom==hProjectViewTab&&hdr->code==TCN_SELCHANGE){
				switch( TabCtrl_GetCurSel(hProjectViewTab) ){
					case 0:
						ShowFileView();
						break;
					case 1:
						ShowClassView();
						break;
					case 2:
						ShowMaterialView();
						break;
				}
			}
			return 0;
		case WM_PAINT:
			PAINTSTRUCT ps;
			HDC hdc;
			HFONT hOldFont;
			SIZE size;
			HBRUSH hBrush,hOldBrush;
			HPEN hPen,hOldPen;
			char temporary[MAX_PATH];

			if(pobj_nv->bClipProjectView==0) break;

			hBrush=CreateSolidBrush(GetSysColor(COLOR_3DSHADOW));
			hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DSHADOW));

			hdc=BeginPaint(hwnd,&ps);

			hOldFont=(HFONT)SelectObject(hdc,hStatusFont);
			if( projectInfo.IsOpened() ){
				sprintf(temporary,"%s \'%s\'",STRING_PROJECT,projectInfo.GetName().c_str());
			}
			else{
				lstrcpy( temporary, "݂̃hLg" );
			}

			GetTextExtentPoint32(hdc,temporary,lstrlen(temporary),&size);
			GetClientRect(hwnd,&rect);
			rect.left++;
			rect.top++;
			rect.right--;
			rect.bottom=size.cy+2;

			hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);
			hOldPen=(HPEN)SelectObject(hdc,hPen);
			Rectangle(hdc,rect.left,rect.top,rect.right,rect.bottom);
			SelectObject(hdc,hOldBrush);
			SelectObject(hdc,hPen);

			rect.top++;
			rect.bottom--;
			SetBkMode(hdc,OPAQUE);
			SetBkColor(hdc,GetSysColor(COLOR_3DSHADOW));
			SetTextColor(hdc,GetSysColor(COLOR_3DHILIGHT));
			DrawText(hdc,temporary,lstrlen(temporary),&rect,DT_CENTER|DT_VCENTER|DT_SINGLELINE);

			EndPaint(hwnd,&ps);

			DeleteObject(hBrush);
			DeleteObject(hPen);
			return 0;
		case WM_SIZE:
			if(pobj_nv->bClipProjectView){
				MoveWindow(hProjectViewTab,
					LEVER_THICK,
					LEVER_THICK+11,
					LOWORD(lParam)-LEVER_THICK*2,
					HIWORD(lParam)-LEVER_THICK*2-21,1);

				GetClientRect(hProjectViewTab,&rect);
				TabCtrl_AdjustRect(hProjectViewTab,FALSE,&rect);
				rect.left-=2;
				rect.right++;
				rect.bottom++;

				pobj_FileTree->MoveWindow(rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top);
				MoveWindow(hProcedureTreeView,
					rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,1);
				MoveWindow(hMaterialTreeView,
					rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,1);

				GetClientRect(GetDlgItem(hwnd,IDC_CLIP),&rect);
				MoveWindow(GetDlgItem(hwnd,IDC_CLIP),LOWORD(lParam)-rect.right,HIWORD(lParam)-rect.bottom,rect.right,rect.bottom,1);
				InvalidateRect(GetDlgItem(hwnd,IDC_CLIP),NULL,0);
			}
			else{
				MoveWindow(hProjectViewTab,0,0,
					LOWORD(lParam),
					HIWORD(lParam)-15,1);

				GetClientRect(hProjectViewTab,&rect);
				TabCtrl_AdjustRect(hProjectViewTab,FALSE,&rect);

				pobj_FileTree->MoveWindow(rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top);
				MoveWindow(hProcedureTreeView,
					rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,1);
				MoveWindow(hMaterialTreeView,
					rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,1);

				GetClientRect(GetDlgItem(hwnd,IDC_CLIP),&rect);
				MoveWindow(GetDlgItem(hwnd,IDC_CLIP),LOWORD(lParam)-rect.right,HIWORD(lParam)-rect.bottom,rect.right,rect.bottom,1);
			}
			return 0;
		case WM_CLOSE:
			SendMessage(hOwner,WM_COMMAND,IDM_PROJECTVIEW,0);
			return 0;
		case WM_DESTROY:
			delete pobj_FileTree;
			ImageList_Destroy(hProcedureTreeViewImageList);
			ImageList_Destroy(hMaterialTreeViewImageList);
			return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}

void Project_File_Insert(char *path){
	extern HANDLE hHeap;
	char temporary[MAX_PATH],temp2[MAX_PATH];

	lstrcpy( path, projectInfo.GetWorkDir().GetRelationalPath( path ).c_str() );

	//d`FbN
	if( projectInfo.fileSystem.root.IsExistFile( path ) )
	{
		//"\"%s\" t@C͊ɃvWFNgɑ݂܂B"
		sprintf(temporary,STRING_DUPLICATIONERROR_FILE_IN_PROJECT,path);
		MessageBox(hOwner,temporary,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
		return;
	}


	//////////////////////
	//c[r[ɒǉ
	HTREEITEM hTreeItem;
	_splitpath(path,0,0,temporary,temp2);
	lstrcat(temporary,temp2);
	hTreeItem=pobj_FileTree->Insert( temporary );


	//projectInfo.ppobj_DBFileInfoIuWFNgɒǉ
	projectInfo.fileSystem.root.files.push_back( ActiveBasic::PM::FM::File( path, hTreeItem ) );


	projectInfo.modify=1;

	//t@CɂNXr[̍ĕ\
	ResetClassTree((HTREEITEM)-1);
}
void Project_File_Delete(HTREEITEM hTreeItem){
	extern HANDLE hHeap;

	/*if(projectInfo.pobj_DBFileInfo->IsMainFile(hTreeItem)){
		//"̃t@C̓vWFNg̃C t@CłBvWFNg폜邱Ƃ͂ł܂B"
		MessageBox(hOwner,STRING_ERROR_CANT_MAINFILE,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
		return;
	}*/

	//c[r[폜
	pobj_FileTree->DeleteItem( hTreeItem );

	// IuWFNg폜
	projectInfo.fileSystem.root.Remove( hTreeItem );

	projectInfo.modify=1;

	//t@CɂNXr[̍ĕ\
	ResetClassTree((HTREEITEM)-1);
}

void MakeNewProject(){
	extern HANDLE hHeap;
	extern NEWPROJECTINFO NewProjectInfo;
	int i;
	char buffer[GENERAL_SIZE],dir[MAX_PATH],temporary[MAX_PATH],*pTemp;
	HANDLE hFind;
	WIN32_FIND_DATA wfd;

	//ɃvWFNgJĂꍇ͕
	if( projectInfo.IsOpened() ){
		if(!projectInfo.Close()) return;
	}

	//[NfBNg쐬
	i=lstrlen(pobj_nv->ProjectSaveDir);
	if(pobj_nv->ProjectSaveDir[i-1]=='\\'&&pobj_nv->ProjectSaveDir[i-2]!=':') pobj_nv->ProjectSaveDir[i-1]=0;
	sprintf(dir,"%s\\%s\\",pobj_nv->ProjectSaveDir,NewProjectInfo.name);
	i=0;
	while(!(dir[i]==':'||(dir[i-1]=='\\'&&dir[i]=='\\'))) i++;
	if(dir[i]==':') i++;
	else{
		i++;
		while(dir[i]!='\\') i++;
	}
	for(i++;;i++){
		if(dir[i]=='\\'){
			lstrcpy(temporary,dir);
			temporary[i]=0;
			hFind=FindFirstFile(temporary,&wfd);
			if(hFind==INVALID_HANDLE_VALUE){
				if(!CreateDirectory(temporary,NULL)){
					MessageBox(hOwner,"fBNg쐬ł܂ł",APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
					return;
				}
			}
			else FindClose(hFind);
		}
		if(dir[i]=='\0') break;
	}


	//////////////////////////////////////
	// vWFNgt@Ci*.pjj쐬
	//////////////////////////////////////

	// o͐gq
	const std::string outputFileExt
		= ( NewProjectInfo.dwTypeID == IDC_DLL ) ? ".dll"
		: ( NewProjectInfo.dwTypeID == IDC_SLL ) ? ".lib"
		: ".exe";

	//擪̒
	lstrcpy(buffer,"\' ActiveBasic Project file.\r\n\r\n");
	i=lstrlen(buffer);

	//vWFNg̃tH[}bgo[W
	sprintf(buffer+i,"#VERSION=%d\r\n\r\n",PROJECT_VERSION);
	i+=lstrlen(buffer+i);

	//W[^CviEXEȂ0ADLLȂ1j
	ActiveBasic::Common::TargetModuleType::EnumType moduleType
		= ( NewProjectInfo.dwTypeID == IDC_DLL ) ? ActiveBasic::Common::TargetModuleType::Dll
		: ( NewProjectInfo.dwTypeID == IDC_SLL ) ? ActiveBasic::Common::TargetModuleType::Sll
		: ActiveBasic::Common::TargetModuleType::Exe;
	lstrcpy(buffer+i,( (std::string)"#MODULETYPE=" + Jenga::Common::ToString( static_cast<int>(moduleType) ) + "\r\n\r\n" ).c_str());
	i+=lstrlen(buffer+i);

	//vWFNg
	sprintf(buffer+i,"#NAME=%s\r\n\r\n",NewProjectInfo.name);
	i+=lstrlen(buffer+i);

	lstrcpy(buffer+i,"#PLATFORM=32\r\n\r\n");
	i+=lstrlen(buffer+i);

	//RADEBhE̐
	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE||
		NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX)
		lstrcpy(buffer+i,"#USEWINDOW=1\r\n\r\n");
	else lstrcpy(buffer+i,"#USEWINDOW=0\r\n\r\n");
	i+=lstrlen(buffer+i);

	//vWFNgIvV
	sprintf(buffer+i,"#OPTION=&H%08x\r\n\r\n",NewProjectInfo.dwOption);
	i+=lstrlen(buffer+i);

	//o͐iReleasej
	sprintf(buffer+i,"#OUTPUT_RELEASE=.\\%s%s\r\n\r\n",NewProjectInfo.name, outputFileExt.c_str());
	i+=lstrlen(buffer+i);

	//o͐iDebugj
	sprintf(buffer+i,"#OUTPUT_DEBUG=.\\%s_debug%s\r\n\r\n",NewProjectInfo.name, outputFileExt.c_str());
	i+=lstrlen(buffer+i);

	//}jtFXg
	sprintf(buffer+i,"#MANIFEST=%s.manifest.xml\r\n\r\n",NewProjectInfo.name);
	i+=lstrlen(buffer+i);

	//fobOpiR}hCj
	lstrcpy(buffer+i,"#DEBUG_CMD_LINE=\r\n\r\n");
	i+=lstrlen(buffer+i);

	//fobOpiDLLp̎st@Cj
	lstrcpy(buffer+i,"#DEBUG_EXE_PATH=\r\n\r\n");
	i+=lstrlen(buffer+i);

	//\[Xt@C
	lstrcpy(buffer+i,"#RESOURCE=0\r\n\r\n");
	i+=lstrlen(buffer+i);

	//\[Xt@C
	sprintf(buffer+i,"#SOURCE\r\n%s.ab\r\n",NewProjectInfo.name);
	i+=lstrlen(buffer+i);
	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE||
		NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		lstrcpy(buffer+i,"MainWnd.ab\r\n");
		i+=lstrlen(buffer+i);
	}
	if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		lstrcpy(buffer+i,"dx_graphics.sbp\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"dx_input.sbp\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"dx_music.sbp\r\n");
		i+=lstrlen(buffer+i);
	}

	//ۑ
	sprintf(temporary,"%s%s.pj",dir,NewProjectInfo.name);
	hFind=FindFirstFile(temporary,&wfd);
	if(hFind!=INVALID_HANDLE_VALUE){
		FindClose(hFind);

		//"w肵fBNgɂ͂łɃvWFNg݂܂B㏑܂H"
		if(MessageBox(hOwner,STRING_ERROR_PROJECT_OVERWRITE,APPLICATION_NAME,MB_YESNO|MB_ICONEXCLAMATION)==IDNO) return;
	}
	if(!WriteBuffer(temporary,buffer,i)) return;


	///////////////////////////////////////////
	//CvOt@Ci*.abj쐬
	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE){
		sprintf(buffer,"#include \"%s.idx\"\r\n\r\n",NewProjectInfo.name);
		i=lstrlen(buffer);
		lstrcpy(buffer+i,"'---------------------------\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'  Window Message Loop\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'---------------------------\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"Dim msgMain As MSG, iResult As Long\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"Do\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tiResult=GetMessage(msgMain,0,0,0)\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tIf iResult=0 or iResult=-1 Then Exit Do\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tTranslateMessage(msgMain)\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tDispatchMessage(msgMain)\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"Loop\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"' Call destructores and exit process\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"End\r\n");
		i+=lstrlen(buffer+i);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_PROMPTBASE){
		sprintf(buffer,"#include \"%s.idx\"\r\n\r\n",NewProjectInfo.name);
		i=lstrlen(buffer);
		lstrcpy(buffer+i,"#N88BASIC\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'  vOs܂\r\n\r\n");
		i+=lstrlen(buffer+i);
		if(NewProjectInfo.ShowHelloWorld){
			lstrcpy(buffer+i,"Print \"Hello World!\"\r\n");
			i+=lstrlen(buffer+i);
		}
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_DOSPROMPTBASE){
		sprintf(buffer,"#include \"%s.idx\"\r\n\r\n",NewProjectInfo.name);
		i=lstrlen(buffer);
		lstrcpy(buffer+i,"#console\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'  vOs܂\r\n\r\n");
		i+=lstrlen(buffer+i);
		if(NewProjectInfo.ShowHelloWorld){
			lstrcpy(buffer+i,"Print \"Hello World!\"\r\n");
			i+=lstrlen(buffer+i);
		}
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_NOBASE){
		sprintf(buffer,"#include \"%s.idx\"\r\n\r\n",NewProjectInfo.name);
		i=lstrlen(buffer);
		lstrcpy(buffer+i,"'  vOs܂\r\n\r\n");
		i+=lstrlen(buffer+i);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		const std::string mainExeDirectXAbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\dx\\main_exe_directx.abp";
		pTemp = ReadBuffer( mainExeDirectXAbpPath );

		//#name#vWFNgɒu
		pTemp=PermutationWndPgmTemplate(pTemp,NewProjectInfo.name,0,0,0);
	}
	else if(NewProjectInfo.dwTypeID==IDC_DLL){
		sprintf(buffer,"#include \"%s.idx\"\r\n\r\n",NewProjectInfo.name);
		i=lstrlen(buffer);
		lstrcpy(buffer+i,"'-------------------------------------------------------------------\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'  - ̃t@Cɂ́ADLL̍\vfLq܂B\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'        iF֐`AO[oϐA萔`Ȃǁj\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'        GNX|[gKvȊ֐ɂ́A\"Export\" Cqw肵܂B\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'        iFFunction Export FuncName() As Longj\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'-------------------------------------------------------------------\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"Function Export DllMain(hinstDLL As HINSTANCE, fdwReason As DWord, lpvReserved As VoidPtr) As Long\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t'DLLGg|Cg\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tSelect Case fdwReason\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\tCase DLL_PROCESS_ATTACH\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\t\t'DLLvZXԂɃ[hꂽɎs܂B\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\t\t_System_StartupProgram()\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\t\tDllMain=1\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\tCase DLL_PROCESS_DETACH\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\t\t_System_Call_Destructor_of_GlobalObject()\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tEnd Select\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"End Function\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\r\n");
		i+=lstrlen(buffer+i);
	}
	else if( NewProjectInfo.dwTypeID == IDC_SLL )
	{
		buffer[0] = 0;
	}

	//ۑ
	if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		sprintf(temporary,"%s%s.ab",dir,NewProjectInfo.name);
		WriteBuffer(temporary,pTemp,lstrlen(pTemp));

		HeapDefaultFree(pTemp);
	}
	else{
		sprintf(temporary,"%s%s.ab",dir,NewProjectInfo.name);
		if(!WriteBuffer(temporary,buffer,lstrlen(buffer))) return;
	}


	/////////////////////
	// MainWnd.ab쐬
	/////////////////////

	std::string mainWndSbpPath = "";
	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE)
	{
		mainWndSbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\MainWnd_exe_windowbase.sbp";
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX)
	{
		mainWndSbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\MainWnd_exe_directx.sbp";
	}

	if( !mainWndSbpPath.empty() ){
		pTemp = ReadBuffer( mainWndSbpPath );

		//#name#vWFNgɒu
		pTemp=PermutationWndPgmTemplate(pTemp,
			NewProjectInfo.name,
			"MainWnd",
			"hMainWnd",
			"MainWndProc");

		if(NewProjectInfo.ShowHelloWorld){
			//Hello World!\
			i=0;
			lstrcpy(buffer+i,"\r\nSub MainWnd_Paint(hDC As HDC)\r\n");
			i+=lstrlen(buffer+i);
			lstrcpy(buffer+i,"\tDim rect As RECT\r\n");
			i+=lstrlen(buffer+i);
			lstrcpy(buffer+i,"\tGetClientRect(hMainWnd,rect)\r\n");
			i+=lstrlen(buffer+i);
			lstrcpy(buffer+i,"\tDrawText(hDC,\"Hello World!\",-1,rect,DT_CENTER or DT_VCENTER or DT_SINGLELINE)\r\n");
			i+=lstrlen(buffer+i);
			lstrcpy(buffer+i,"End Sub\r\n");
			i+=lstrlen(buffer+i);

			pTemp=(char *)HeapReAlloc(hHeap,0,pTemp,lstrlen(pTemp)+lstrlen(buffer)+1);
			lstrcat(pTemp,buffer);
		}

		sprintf(temporary,"%sMainWnd.ab",dir,NewProjectInfo.name);
		WriteBuffer(temporary,pTemp,lstrlen(pTemp));

		HeapDefaultFree(pTemp);
	}


	if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		///////////////////////////
		// DirextXΉAv̂Ƃ
		///////////////////////////

		//dx_graphics.sbpRs[
		const std::string dxGraphicsSbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\dx\\dx_graphics.sbp";
		pTemp = ReadBuffer( dxGraphicsSbpPath );
		sprintf(temporary,"%sdx_graphics.sbp",dir,NewProjectInfo.name);
		WriteBuffer(temporary,pTemp,lstrlen(pTemp));
		HeapDefaultFree(pTemp);

		//dx_input.sbpRs[
		const std::string dxInputSbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\dx\\dx_input.sbp";
		pTemp = ReadBuffer( dxInputSbpPath );
		sprintf(temporary,"%sdx_input.sbp",dir,NewProjectInfo.name);
		WriteBuffer(temporary,pTemp,lstrlen(pTemp));
		HeapDefaultFree(pTemp);

		//dx_music.sbpRs[
		const std::string dxMusicSbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\dx\\dx_music.sbp";
		pTemp = ReadBuffer( dxMusicSbpPath );
		sprintf(temporary,"%sdx_music.sbp",dir,NewProjectInfo.name);
		WriteBuffer(temporary,pTemp,lstrlen(pTemp));
		HeapDefaultFree(pTemp);

		//dx9abm.dllRs[
		sprintf(temporary,"%sRuntime\\dx9abm.dll",pj_editor_Dir);
		sprintf(buffer,"%sdx9abm.dll",dir,NewProjectInfo.name);
		CopyFile(temporary,buffer,0);
	}


	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE||
		NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		/////////////////////////////////////////
		// EBhE`t@Ci*.wndj쐬
		/////////////////////////////////////////
		ActiveBasic::PM::WindowInfos windowInfos;
		windowInfos.push_back( new ActiveBasic::PM::WindowInfo() );
		windowInfos.back()->SetName( "MainWnd" );
		windowInfos.back()->pos.x=CW_USEDEFAULT;
		windowInfos.back()->pos.y=CW_USEDEFAULT;
		windowInfos.back()->size.cx=480;
		windowInfos.back()->size.cy=360;
		windowInfos.back()->SetCaption( NewProjectInfo.name );
		if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE)
		{
			windowInfos.back()->SetStyle( WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_MINIMIZEBOX|WS_MAXIMIZEBOX|WS_VISIBLE );
		}
		else if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX)
		{
			windowInfos.back()->SetStyle( WS_OVERLAPPED|WS_THICKFRAME|WS_SYSMENU );
		}
		windowInfos.back()->SetExStyle( 0 );
		windowInfos.back()->SetMenuIdName( "" );
		windowInfos.back()->SetBackgroundColor( COLOR_3DFACE );
		GetDefaultWindowFont(&windowInfos.back()->LogFont);
		windowInfos.back()->SetIconResourceName( "" );
		windowInfos.back()->SetClassName( "NORMAL" );
		windowInfos.back()->SetType( ActiveBasic::PM::WindowType::Default );
		sprintf(temporary,"%s%s.wnd",dir,NewProjectInfo.name);

		projectInfo.NumberOfMenu=0;
		SaveWindowFile( temporary, windowInfos );

		windowInfos.Clear();
	}


	////////////////////////
	// [Nt@C쐬
	////////////////////////
	lstrcpy(buffer,"case4\r\n\r\n");
	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE){
		lstrcat(buffer,"rad,MainWnd\r\n\r\n");
	}
	else{
		sprintf(buffer+lstrlen(buffer),"text,\"%s.ab\",0,0,0,0\r\n\r\n",NewProjectInfo.name);
	}
	lstrcat(buffer,"0\r\n0\r\n0\r\n0,0");
	//ۑ
	sprintf(temporary,"%s%s.wrk",dir,NewProjectInfo.name);
	if(!WriteBuffer(temporary,buffer,lstrlen(buffer))) return;


	//}jtFXg쐬
	char temp2[MAX_PATH];
	const std::string manifestTempXmlPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\manifest_temp.xml";
	sprintf(temp2,"%s%s.manifest.xml",dir,NewProjectInfo.name);
	CopyFile( manifestTempXmlPath.c_str(), temp2, 0 );


	sprintf(temporary,"%s%s.pj",dir,NewProjectInfo.name);
	projectInfo.Load(temporary);
	projectInfo.Save();
}
void SetTreeViewForProjectInfo(){
	extern HANDLE hHeap;
	extern HWND hProjectView;
	int i;
	char temporary[MAX_PATH];
	TV_INSERTSTRUCT tv;

	sprintf(temporary,"%s ",projectInfo.GetName().c_str());
	lstrcat(temporary,STRING_PROJECT);
	SetWindowText(hProjectView,temporary);

	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;

	//t@C c[
	pobj_FileTree->Reset( projectInfo.fileSystem );

	//֐c[
	ResetClassTree((HTREEITEM)-1);

	/////////////////////
	// }eA c[

	//Cursor\[X tH_
	sprintf(temporary,"Cursor %s",STRING_RESOURCE);
	tv.hParent=TVI_ROOT;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText=temporary;
	tv.hParent=TreeView_InsertItem(hMaterialTreeView,&tv);
	hCursorTreeItemForProjectView = tv.hParent;
	BOOST_FOREACH( ActiveBasic::Common::ResourceItem &resourceItem, projectInfo.resourceManager.cursorResources )
	{
		tv.item.iImage=6;
		tv.item.iSelectedImage=6;
		lstrcpy( temporary, resourceItem.idName.c_str() );
		tv.item.pszText=temporary;
		resourceItem.hTreeItem = TreeView_InsertItem(hMaterialTreeView,&tv);
	}

	//Bitmap\[X tH_
	sprintf(temporary,"Bitmap %s",STRING_RESOURCE);
	tv.hParent=TVI_ROOT;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText=temporary;
	tv.hParent=TreeView_InsertItem(hMaterialTreeView,&tv);
	hBitmapTreeItemForProjectView = tv.hParent;
	BOOST_FOREACH( ActiveBasic::Common::ResourceItem &resourceItem, projectInfo.resourceManager.bitmapResources )
	{
		tv.item.iImage=5;
		tv.item.iSelectedImage=5;
		lstrcpy( temporary, resourceItem.idName.c_str() );
		tv.item.pszText=temporary;
		resourceItem.hTreeItem = TreeView_InsertItem(hMaterialTreeView,&tv);
	}

	//Icon\[X tH_
	sprintf(temporary,"Icon %s",STRING_RESOURCE);
	tv.hParent=TVI_ROOT;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText=temporary;
	tv.hParent=TreeView_InsertItem(hMaterialTreeView,&tv);
	hIconTreeItemForProjectView = tv.hParent;
	for(i=0;i<static_cast<int>(projectInfo.resourceManager.iconResources.size());i++){
		tv.item.iImage=4;
		tv.item.iSelectedImage=4;
		if(i==0){
			sprintf(temporary,"%s (Main)",projectInfo.resourceManager.iconResources[i].idName.c_str());
		}
		else
		{
			sprintf(temporary,"%s",projectInfo.resourceManager.iconResources[i].idName.c_str());
		}
		tv.item.pszText=temporary;
		projectInfo.resourceManager.iconResources[i].hTreeItem=TreeView_InsertItem(hMaterialTreeView,&tv);
	}

	//MenutH_
	tv.hParent=TVI_ROOT;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText="Menu";
	tv.hParent=TreeView_InsertItem(hMaterialTreeView,&tv);
	projectInfo.hMenuTreeItem=tv.hParent;
	for(i=0;i<projectInfo.NumberOfMenu;i++){
		tv.item.iImage=3;
		tv.item.iSelectedImage=3;
		tv.item.pszText=projectInfo.pMenuInfo[i].IdName;
		projectInfo.pMenuInfo[i].hTreeItem=TreeView_InsertItem(hMaterialTreeView,&tv);
	}

	//WindowtH_
	tv.hParent=TVI_ROOT;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText="Window";
	tv.hParent=TreeView_InsertItem(hMaterialTreeView,&tv);
	projectInfo.hWindowTreeItem=tv.hParent;
	BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
	{
		tv.item.iImage=2;
		tv.item.iSelectedImage=2;
		char temporary[1024];
		lstrcpy( temporary, pWindowInfo->GetName().c_str() );
		tv.item.pszText = temporary;
		pWindowInfo->hTreeItem=TreeView_InsertItem(hMaterialTreeView,&tv);
	}
}
void OpenWorkfile( const std::string &path )
{
	extern HANDLE hHeap;
	int i,i2,i3;
	char *buffer,temporary[MAX_PATH],temp2[MAX_PATH];

	//vWFNg r[ݒA\
	extern HWND hProjectView;
	SetTreeViewForProjectInfo();
	if(!IsWindowVisible(hProjectView)) SendMessage(hOwner,WM_COMMAND,IDM_PROJECTVIEW,0);


	//j[Ԃݒ
	ResetState_DocMenu();


	//////////////////////////////////////////
	//[Nt@Ci*.wrkjI[v
	HTREEITEM hTreeItem;
	HANDLE hFind;
	WIN32_FIND_DATA wfd;
	HWND hChild;
	int WndNum;
	hFind=FindFirstFile(path.c_str(),&wfd);
	if(hFind!=INVALID_HANDLE_VALUE){
		FindClose(hFind);
		buffer=ReadBuffer(path);
		if(!buffer) return;

		//́Af
		memcpy(temporary,buffer,5);
		temporary[5]=0;
		if(lstrcmp(temporary,"case4")==0){

			LockWindowUpdate(hOwner);
			for(i=9,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					if(i2!=0){
						temporary[i2]=0;
						for(i3=0;;i3++){
							if(temporary[i3]==','||temporary[i3]=='\0') break;
						}
						if(temporary[i3]=='\0') goto EndToSetWorkFile;
						lstrcpy(temp2,temporary+i3+1);
						temporary[i3]=0;
						if(lstrcmpi(temporary,"text")==0){
							if(temp2[0]!='\"') goto EndToSetWorkFile;

							//t@CJ
							i2=1;
							for(i3=0;;i2++,i3++){
								if(temp2[i2]=='\"'||temp2[i2]=='\0'){
									temporary[i3]=0;
									break;
								}
								temporary[i3]=temp2[i2];
							}
							lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );
							hChild=OpenFileWithExtension(temporary);
							WndNum=GetWndNum(hChild);
							if(WndNum==-1){
								goto EndToSetWorkFile;
							}

							//ResetScrollbarĕ`掞ɌĂяôŁAĕ`悷
							InvalidateRect(MdiInfo[WndNum]->pMdiTextEdit->hEdit,NULL,0);
							UpdateWindow(MdiInfo[WndNum]->pMdiTextEdit->hEdit);

							if(temp2[i2]=='\0') goto EndToSetWorkFile;
							if(temp2[i2+1]!=',') goto EndToSetWorkFile;

							//ȑÕXN[ʒu𕜌
							SCROLLINFO si;
							POINT pos;
							for(i2+=2,i3=0;;i2++,i3++){
								if(temp2[i2]==','||temp2[i2]=='\0'){
									temporary[i3]=0;
									break;
								}
								temporary[i3]=temp2[i2];
							}
							sscanf(temporary,"%d",&pos.x);
							if(temp2[i2]=='\0') goto EndToSetWorkFile;
							for(i2++,i3=0;;i2++,i3++){
								if(temp2[i2]==','||temp2[i2]=='\0'){
									temporary[i3]=0;
									break;
								}
								temporary[i3]=temp2[i2];
							}
							sscanf(temporary,"%d",&pos.y);
							si.cbSize=sizeof(SCROLLINFO);
							si.fMask=SIF_POS;
							si.nPos=pos.x;
							SetScrollInfo(MdiInfo[WndNum]->pMdiTextEdit->hEdit,SB_HORZ,&si,1);
							si.nPos=pos.y;
							SetScrollInfo(MdiInfo[WndNum]->pMdiTextEdit->hEdit,SB_VERT,&si,1);

							if(temp2[i2]=='\0') goto EndToSetWorkFile;

							//LbgʒuZbg
							for(i2++,i3=0;;i2++,i3++){
								if(temp2[i2]==','||temp2[i2]=='\0'){
									temporary[i3]=0;
									break;
								}
								temporary[i3]=temp2[i2];
							}
							sscanf(temporary,"%d",&pos.x);
							if(temp2[i2]=='\0') goto EndToSetWorkFile;
							for(i2++,i3=0;;i2++,i3++){
								if(temp2[i2]==','||temp2[i2]=='\0'){
									temporary[i3]=0;
									break;
								}
								temporary[i3]=temp2[i2];
							}
							sscanf(temporary,"%d",&pos.y);
							TextEdit_SetSel(WndNum,pos.x,pos.y);
						}
						else if(lstrcmpi(temporary,"rad")==0){
							for(i3=0;i3<static_cast<int>(projectInfo.windowInfos.size());i3++){
								if(lstrcmpi(projectInfo.windowInfos[i3]->GetName().c_str(),temp2)==0){
									NewRadWindow( *projectInfo.windowInfos[i3] );
									break;
								}
							}
						}
						else if(lstrcmpi(temporary,"menu")==0){
							for(i3=0;i3<projectInfo.NumberOfMenu;i3++){
								if(lstrcmpi(projectInfo.pMenuInfo[i3].IdName,temp2)==0){
									NewMenuWindow(&projectInfo.pMenuInfo[i3]);
									break;
								}
							}
						}
						else if(lstrcmpi(temporary,"icon")==0)
						{
							BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, projectInfo.resourceManager.iconResources )
							{
								if(lstrcmpi(resourceItem.filepath.c_str(),temp2)==0){
									NewIconEditWindow( projectInfo.GetWorkDir().GetFullPath( temp2 ).c_str() );
									break;
								}
							}
						}
						i++;
						i2=-1;
						continue;
					}
					else break;
				}
				temporary[i2]=buffer[i];
			}

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			sscanf(temporary,"%d",&i2);

			switch( i2 ){
				case 0:
					ShowFileView();
					break;
				case 1:
					ShowClassView();
					break;
				case 2:
					ShowMaterialView();
					break;
			}

			if(buffer[i]=='\0') goto EndToSetWorkFile;

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(temporary[0]=='1')
			{
				pobj_FileTree->Expand( pobj_FileTree->GetRootItem(), TVE_EXPAND );
			}

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(temporary[0]=='1') TreeView_Expand(hProcedureTreeView,TreeView_GetRoot(hProcedureTreeView),TVE_EXPAND);

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			hTreeItem=TreeView_GetRoot(hMaterialTreeView);
			i2=0;
			while(hTreeItem){
				i2=GetOneParameter(temporary,i2,temp2);
				if(GetValue(temp2)) TreeView_Expand(hMaterialTreeView,hTreeItem,TVE_EXPAND);
				hTreeItem=TreeView_GetNextSibling(hMaterialTreeView,hTreeItem);
			}
		}
		else if(lstrcmp(temporary,"case3")==0){
			////////////////////////////////////////
			// ÂtH[}bg̃[Nt@C

			LockWindowUpdate(hOwner);
			for(i=9,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					if(i2!=0){
						temporary[i2]=0;
						for(i3=0;;i3++){
							if(temporary[i3]==','||temporary[i3]=='\0') break;
						}
						if(temporary[i3]=='\0') goto EndToSetWorkFile;
						lstrcpy(temp2,temporary+i3+1);
						temporary[i3]=0;
						if(lstrcmpi(temporary,"text")==0){
							for(i3=0;;i3++){
								if(temp2[i3]==','||temp2[i3]=='\0') break;
							}
							if(temp2[i3]=='\0') goto EndToSetWorkFile;
							lstrcpy(temporary,temp2+i3+1);
							temp2[i3]=0;
							lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );
							sscanf(temp2,"%d",&i3);

							//t@CJ
							hChild=OpenFileWithExtension(temporary);
							WndNum=GetWndNum(hChild);

							//LbgʒuZbg
							TextEdit_SetSel(WndNum,i3,i3);
						}
						else if(lstrcmpi(temporary,"rad")==0){
							for(i3=0;i3<static_cast<int>(projectInfo.windowInfos.size());i3++){
								if(lstrcmpi(projectInfo.windowInfos[i3]->GetName().c_str(),temp2)==0){
									NewRadWindow( *projectInfo.windowInfos[i3] );
									break;
								}
							}
						}
						else if(lstrcmpi(temporary,"menu")==0){
							for(i3=0;i3<projectInfo.NumberOfMenu;i3++){
								if(lstrcmpi(projectInfo.pMenuInfo[i3].IdName,temp2)==0){
									NewMenuWindow(&projectInfo.pMenuInfo[i3]);
									break;
								}
							}
						}
						else if(lstrcmpi(temporary,"icon")==0){
							BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, projectInfo.resourceManager.iconResources )
							{
								if(lstrcmpi(resourceItem.filepath.c_str(),temp2)==0){
									NewIconEditWindow( projectInfo.GetWorkDir().GetFullPath( temp2 ).c_str() );
									break;
								}
							}
						}
						i++;
						i2=-1;
						continue;
					}
					else break;
				}
				temporary[i2]=buffer[i];
			}

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			sscanf(temporary,"%d",&i2);

			switch( i2 ){
				case 0:
					ShowFileView();
					break;
				case 1:
					ShowClassView();
					break;
				case 2:
					ShowMaterialView();
					break;
			}

			if(buffer[i]=='\0') goto EndToSetWorkFile;

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(temporary[0]=='1')
			{
				pobj_FileTree->Expand( pobj_FileTree->GetRootItem(), TVE_EXPAND );
			}

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(temporary[0]=='1') TreeView_Expand(hProcedureTreeView,TreeView_GetRoot(hProcedureTreeView),TVE_EXPAND);

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			hTreeItem=TreeView_GetRoot(hMaterialTreeView);
			i2=0;
			while(hTreeItem){
				i2=GetOneParameter(temporary,i2,temp2);
				if(GetValue(temp2)) TreeView_Expand(hMaterialTreeView,hTreeItem,TVE_EXPAND);
				hTreeItem=TreeView_GetNextSibling(hMaterialTreeView,hTreeItem);
			}
		}
EndToSetWorkFile:
		LockWindowUpdate(NULL);
		HeapDefaultFree(buffer);
	}


	//EBhE ^CgύX
	sprintf(temporary,"%s - %s",projectInfo.GetName().c_str(),APPLICATION_NAME);
	SetWindowText(hOwner,temporary);
}
BOOL ProjectModifyCheck(BOOL bRun){
	int i,WndNum,sw;
	HWND hChild;
	char temporary[MAX_PATH];
	if(projectInfo.modify||projectInfo.ModifyOfMaterial||projectInfo.ModifuOfResource){
		if(bRun==0||pobj_nv->bSaveCheckProject){
			//"\"%s\" vWFNg͕ύXĂ܂Bۑ܂H"
			sprintf(temporary,STRING_MODIFYCHECK_PROJECT,projectInfo.GetName().c_str());
			i=MessageBox(hOwner,temporary,APPLICATION_NAME,MB_YESNOCANCEL|MB_ICONEXCLAMATION);

			if(i==IDCANCEL) return 0;
			if(i==IDYES)
			{
				projectInfo.Save();
			}
		}
		else
		{
			projectInfo.Save();
		}
		return 1;
	}
	hChild=GetWindow(hClient,GW_CHILD);
	while(hChild){
		WndNum=GetWndNum(hChild);
		sw=0;
		if(IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType)){
			if( MdiInfo[WndNum]->pMdiTextEdit->IsModified() ){
				sw = projectInfo.fileSystem.root.IsExistFile( MdiInfo[WndNum]->path );
			}
		}
		else if(MdiInfo[WndNum]->DocType==WNDTYPE_ICONEDIT){
			if(MdiInfo[WndNum]->MdiIconEditInfo->bModify){
				BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, projectInfo.resourceManager.iconResources )
				{
					lstrcpy(temporary,resourceItem.filepath.c_str());
					lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );
					if(lstrcmpi(MdiInfo[WndNum]->path.c_str(),temporary)==0) sw=1;
				}
			}
		}

		if(sw){
			if(bRun==0||pobj_nv->bSaveCheckProject){
				//"\"%s\" vWFNg͕ύXĂ܂Bۑ܂H"
				sprintf(temporary,STRING_MODIFYCHECK_PROJECT,projectInfo.GetName().c_str());
				i=MessageBox(hOwner,temporary,APPLICATION_NAME,MB_YESNOCANCEL|MB_ICONEXCLAMATION);

				if(i==IDCANCEL) return 0;
				if(i==IDYES)
				{
					projectInfo.Save();
				}
			}
			else
			{
				projectInfo.Save();
			}
			return 1;
		}
		hChild=GetNextWindow(hChild,GW_HWNDNEXT);
	}
	return 2;
}

void MakeTextMdiWindowBuffer( ActiveBasic::PM::FM::Folder &folder, int WndNum, char *buffer )
{
	BOOST_FOREACH( ActiveBasic::PM::FM::Folder &childFolder, folder.folders )
	{
		MakeTextMdiWindowBuffer( childFolder, WndNum, buffer );
	}

	BOOST_FOREACH( ActiveBasic::PM::FM::File &file, folder.files )
	{
		if(lstrcmpi(MdiInfo[WndNum]->path.c_str(),file.GetFullPath().c_str())==0){
			CHARRANGE CharRange;
			TextEdit_GetSel(WndNum,&CharRange);

			SCROLLINFO si;
			POINT pos;
			si.cbSize=sizeof(SCROLLINFO);
			si.fMask=SIF_POS;
			GetScrollInfo(MdiInfo[WndNum]->pMdiTextEdit->hEdit,SB_HORZ,&si);
			pos.x=si.nPos;
			GetScrollInfo(MdiInfo[WndNum]->pMdiTextEdit->hEdit,SB_VERT,&si);
			pos.y=si.nPos;

			char temporary[1024];
			sprintf(temporary,"text,\"%s\",%d,%d,%d,%d\r\n",
				file.GetRelationalPath().c_str(),
				pos.x,
				pos.y,
				CharRange.cpMin,
				CharRange.cpMax);

			lstrcat( buffer, temporary );
			break;
		}
	}
}

void MakeWorkFile(void){
	int i,i2,WndNum;
	char temporary[MAX_PATH],buffer[32767];
	HWND hChild;

	//[Nt@Ci*.wrkj쐬
	lstrcpy(buffer,"case4\r\n\r\n");
	i2=lstrlen(buffer);


	///////////////////////
	//MDIEBhE̕
	hChild=GetWindow(GetWindow(hClient,GW_CHILD),GW_HWNDLAST);
	while(hChild){
		WndNum=GetWndNum(hChild);
		if(IS_DOCUMENT_TEXT(MdiInfo[WndNum]->DocType)){
			MakeTextMdiWindowBuffer( projectInfo.fileSystem.root, WndNum, buffer );
			i2 = lstrlen( buffer );
		}
		else if(MdiInfo[WndNum]->DocType==WNDTYPE_RAD){
			BOOST_FOREACH( ActiveBasic::PM::WindowInfo *pWindowInfo, projectInfo.windowInfos )
			{
				if(lstrcmpi(MdiInfo[WndNum]->path.c_str(),pWindowInfo->GetName().c_str())==0){
					sprintf(buffer+i2,"rad,%s\r\n",MdiInfo[WndNum]->path.c_str());
					i2+=lstrlen(buffer+i2);
					break;
				}
			}
		}
		else if(MdiInfo[WndNum]->DocType==WNDTYPE_MENU){
			for(i=0;i<projectInfo.NumberOfMenu;i++){
				if(lstrcmpi(MdiInfo[WndNum]->path.c_str(),projectInfo.pMenuInfo[i].IdName)==0){
					sprintf(buffer+i2,"menu,%s\r\n",MdiInfo[WndNum]->path.c_str());
					i2+=lstrlen(buffer+i2);
					break;
				}
			}
		}
		else if(MdiInfo[WndNum]->DocType==WNDTYPE_ICONEDIT){
			BOOST_FOREACH( const ActiveBasic::Common::ResourceItem &resourceItem, projectInfo.resourceManager.iconResources )
			{
				lstrcpy(temporary,resourceItem.filepath.c_str());
				lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );
				if(lstrcmpi(MdiInfo[WndNum]->path.c_str(),temporary)==0){
					sprintf(buffer+i2,"icon,%s\r\n",resourceItem.filepath.c_str());
					i2+=lstrlen(buffer+i2);
					break;
				}
			}
		}
		hChild=GetNextWindow(hChild,GW_HWNDPREV);
	}
	lstrcpy(buffer+i2,"\r\n");
	i2+=2;


	//////////////////////////
	//c[r[̓WJ
	sprintf(buffer+i2,"%d\r\n",TabCtrl_GetCurSel(hProjectViewTab));
	i2+=lstrlen(buffer+i2);
	TVITEM tvItem;
	memset(&tvItem,0,sizeof(TVITEM));
	tvItem.mask=TVIF_HANDLE|TVIF_STATE;
	tvItem.hItem = pobj_FileTree->GetRootItem();
	pobj_FileTree->GetItem( &tvItem );
	if(tvItem.state&TVIS_EXPANDED) i=1;
	else i=0;
	sprintf(buffer+i2,"%d\r\n",i);
	i2+=lstrlen(buffer+i2);

	tvItem.hItem=TreeView_GetRoot(hProcedureTreeView);
	TreeView_GetItem(hProcedureTreeView,&tvItem);
	if(tvItem.state&TVIS_EXPANDED) i=1;
	else i=0;
	sprintf(buffer+i2,"%d\r\n",i);
	i2+=lstrlen(buffer+i2);

	tvItem.hItem=TreeView_GetRoot(hMaterialTreeView);
	while(tvItem.hItem){
		TreeView_GetItem(hMaterialTreeView,&tvItem);
		if(tvItem.state&TVIS_EXPANDED) i=1;
		else i=0;
		sprintf(buffer+i2,"%d",i);
		i2+=lstrlen(buffer+i2);

		tvItem.hItem=TreeView_GetNextSibling(hMaterialTreeView,tvItem.hItem);
		if(tvItem.hItem){
			lstrcpy(buffer+i2,",");
			i2+=lstrlen(buffer+i2);
		}
	}


	//ۑ
	sprintf(temporary,"%s%s.wrk",projectInfo.GetWorkDir().GetPath().c_str(),projectInfo.GetName().c_str());
	WriteBuffer(temporary,buffer,i2);
}

BOOL SetProjectToRun(void){
	HANDLE hFind;
	WIN32_FIND_DATA wfd;

	if( projectInfo.fileSystem.root.IsEmpty() )
	{
		//"vO t@CvWFNgɑ݂܂B"
		MessageBox(hOwner,STRING_ERROR_NOFILE,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
		return 0;
	}

	extern ActiveBasic::Common::Platform::EnumType selectingPlatform;
	hFind=FindFirstFile( ActiveBasic::Common::Environment::GetCompilerExePath( selectingPlatform ).c_str(), &wfd );
	if(hFind==INVALID_HANDLE_VALUE){
		//"BasicCompiler.exe ܂"
		MessageBox(hOwner,STRING_ERROR_NOBASICCOMPILER,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
		return 0;
	}
	FindClose(hFind);

	//vWFNg\̃o[WႤ́Aĕۑ
	if(projectInfo.dwVersion<PROJECT_VERSION)
		projectInfo.ModifyOfMaterial=1;

	//ۑmF
	if(!ProjectModifyCheck(1)) return 0;

	return 1;
}
bool IsNeedCompileForProject( const ActiveBasic::PM::FM::Folder &folder, const FILETIME &exeTime )
{
	BOOST_FOREACH( const ActiveBasic::PM::FM::Folder &childFolder, folder.folders )
	{
		if( IsNeedCompileForProject( childFolder, exeTime ) )
		{
			return true;
		}
	}

	BOOST_FOREACH( const ActiveBasic::PM::FM::File &file, folder.files )
	{
		FILETIME sourceTime;
		{
			ATL::CHandle hFile(CreateFile(file.GetFullPath().c_str(),GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL));
			GetFileTime(hFile,NULL,NULL,&sourceTime);
		}

		if(sourceTime.dwHighDateTime>exeTime.dwHighDateTime||
			sourceTime.dwHighDateTime==exeTime.dwHighDateTime&&
			sourceTime.dwLowDateTime>exeTime.dwLowDateTime) return true;
	}

	return false;
}

BOOL IsNeedCompileForProject(BOOL bDebug){
	char temporary[MAX_PATH];
	HANDLE hFind;
	WIN32_FIND_DATA wfd;
	FILETIME SourceTime,ExeTime;

	if(bDebug) lstrcpy(temporary,projectInfo.lpszOutput_Debug);
	else lstrcpy(temporary,projectInfo.lpszOutput_Release);
	lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );

	hFind=FindFirstFile(temporary,&wfd);
	if(hFind==INVALID_HANDLE_VALUE) return 1;
	FindClose(hFind);

	{
		ATL::CHandle hFile(CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL));
		GetFileTime(hFile,NULL,NULL,&ExeTime);
	}

	if( IsNeedCompileForProject( projectInfo.fileSystem.root, ExeTime ) )
	{
		return 1;
	}
	if( !projectInfo.windowInfos.empty() )
	{
		//CallBack.wbp
		lstrcpy(temporary,"CallBack.wbp");
		lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );
		{
			ATL::CHandle hFile(CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL));
			GetFileTime(hFile,NULL,NULL,&SourceTime);
		}
		if(SourceTime.dwHighDateTime>ExeTime.dwHighDateTime||
			SourceTime.dwHighDateTime==ExeTime.dwHighDateTime&&
			SourceTime.dwLowDateTime>ExeTime.dwLowDateTime) return 1;

		//MakeWindow.wbp
		lstrcpy(temporary,"MakeWindow.wbp");
		lstrcpy( temporary, projectInfo.GetWorkDir().GetFullPath( temporary ).c_str() );
		{
			ATL::CHandle hFile(CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL));
			GetFileTime(hFile,NULL,NULL,&SourceTime);
		}
		if(SourceTime.dwHighDateTime>ExeTime.dwHighDateTime||
			SourceTime.dwHighDateTime==ExeTime.dwHighDateTime&&
			SourceTime.dwLowDateTime>ExeTime.dwLowDateTime) return 1;
	}
	return 0;
}
