#pragma once

#include <memory>
#include <windows.h>
#include <boost/optional.hpp>

namespace ActiveBasic { namespace Resource {

HICON LoadIcon(HINSTANCE hinst, USHORT id, int cxDesired, int cyDesired, UINT load = 0);
HICON LoadIcon(HINSTANCE hinst, USHORT id);

HCURSOR LoadCursor(HINSTANCE hinst, USHORT id);

boost::optional<std::wstring> LoadString(HINSTANCE hinst, USHORT id);

HACCEL LoadAccelerators(HINSTANCE hinst, USHORT id);

struct IconDeleter
{
	typedef HICON pointer;

	void operator ()(HICON hicon) const
	{
		::DestroyIcon(hicon);
	}
};

typedef std::unique_ptr<HICON, IconDeleter> UniqueHIcon;

}}
