#pragma once

class CClass;

class Type{
	int basicType;
	union{
		LONG_PTR index;
		CClass *pClass;
	};

public:
	static int GetBasicSize( int basicType );

	Type():
	  basicType( DEF_NON ),
	  index( -1 ){}
	Type( int basicType ):
	  basicType( basicType ),
	  index( -1 ){}

	Type( int basicType, LONG_PTR index ):
	  basicType( basicType ),
	  index( index ){}

	Type( int basicType, const CClass &objClass ):
	  basicType( basicType ),
	  index( (LONG_PTR)&objClass ){}

	Type( const Type &type ):
	  basicType( type.basicType ),
	  index( type.index ){}

	__inline int GetBasicType() const
	{
		return basicType;
	}
	LONG_PTR GetIndex() const
	{
		return index;
	}
	const CClass &GetClass() const
	{
		return *pClass;
	}

	void SetBasicType( int basicType ){
		this->basicType = basicType;
	}
	void SetIndex( LONG_PTR index ){
		this->index = index;
	}
	void SetNull(){
		SetBasicType( DEF_NON );
		SetIndex( -1 );
	}
	void SetType( int basicType, LONG_PTR index ){
		SetBasicType( basicType );
		SetIndex( index );
	}
	void SetType( int basicType, CClass *pClass ){
		SetBasicType( basicType );
		this->pClass = pClass;
	}

	int PtrLevel() const
	{
		return PTR_LEVEL( basicType );
	}
	void PtrLevelUp(){
		PTR_LEVEL_UP( basicType );
	}
	void PtrLevelDown(){
		PTR_LEVEL_DOWN( basicType );
	}

	bool Equals( const Type &type ) const;

	int GetBasicSize() const;
	int GetSize() const;

	bool IsNull() const;

	bool IsByte() const;
	bool IsSByte() const;
	bool IsWord() const;
	bool IsInteger() const;
	bool IsDWord() const;
	bool IsLong() const;
	bool IsQWord() const;
	bool IsInt64() const;
	bool IsSingle() const;
	bool IsDouble() const;
	bool IsBoolean() const;

	bool IsPointer() const;
	bool IsSigned() const;
	bool IsNaturalWhole() const;
	bool IsWhole() const;
	bool IsReal() const;
	bool Is64() const;
	bool IsProcPtr() const;
	bool IsStruct() const;
	bool IsStructPtr() const;
	bool IsObject() const;
	bool IsObjectPtr() const;
	bool IsStringObject() const;
	bool IsVoidPtr() const;
	bool IsAny() const;

	const string ToString() const;

	void operator= ( const Type &type ){
		basicType = type.basicType;
		index = type.index;
	}

	static Type String();


private:
	static const int basicTypeList[];
	static const string basicTypeNameList[];
public:
	static bool StringToBasicType( const string &typeName, int &basicType );
	static bool StringToType( const string &typeName, Type &type );
};
