#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

#define MDLFILE_VER	0x70000003


void SetLpIndex_DebugFile(char *buffer,int *p,const Type &type){
	if(NATURAL_TYPE(type.GetBasicType())==DEF_OBJECT || NATURAL_TYPE(type.GetBasicType())==DEF_STRUCT){
		lstrcpy(buffer+(*p),type.GetClass().name);
		(*p)+=lstrlen(buffer+(*p))+1;
	}
	else{
		*(LONG_PTR *)(buffer+(*p))=type.GetIndex();
		(*p)+=sizeof(LONG_PTR);
	}
}


void GetLpIndex_DebugFile(char *buffer,int *p,Type &type){
	if(NATURAL_TYPE(type.GetBasicType())==DEF_OBJECT || NATURAL_TYPE(type.GetBasicType())==DEF_STRUCT){
		char szClassName[VN_SIZE];
		lstrcpy(szClassName,buffer+(*p));
		(*p)+=lstrlen(buffer+(*p))+1;

		type.SetIndex( (LONG_PTR)pobj_DBClass->check(szClassName) );
	}
	else{
		type.SetIndex( *(LONG_PTR *)(buffer+(*p)) );
		(*p)+=sizeof(LONG_PTR);
	}
}



CDebugSection::CDebugSection(){
	memset(this,0,sizeof(CDebugSection));
}
CDebugSection::~CDebugSection(){
	if(pobj_DBClass) DeleteDebugInfo();
	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}
}
void CDebugSection::make(void){
	extern INCLUDEFILEINFO IncludeFileInfo;
	int i2,i3,i4,i5,BufferSize;

	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}

	i2=0;

	extern char *basbuf;
	i3=lstrlen(basbuf);

	BufferSize=lstrlen(basbuf)+65535;
	buffer=(char *)HeapAlloc(hHeap,0,BufferSize);

	//fobOpt@C̃o[W
	*(long *)(buffer+i2)=MDLFILE_VER;
	i2+=sizeof(long);

	//vbgtH[̃rbg
	*(long *)(buffer+i2)=PLATFORM;
	i2+=sizeof(long);

	//CN[h
	*(long *)(buffer+i2)=IncludeFileInfo.FilesNum;
	i2+=sizeof(long);
	for(i3=0;i3<IncludeFileInfo.FilesNum;i3++){
		lstrcpy(buffer+i2,IncludeFileInfo.ppFileNames[i3]);
		i2+=lstrlen(buffer+i2)+1;
	}
	buffer[i2++]=0;
	for(i3=0;;i3++){
		buffer[i2++]=(char)IncludeFileInfo.LineOfFile[i3];
		if(IncludeFileInfo.LineOfFile[i3]==-1) break;
	}

	//\[XR[h
	lstrcpy(buffer+i2,basbuf);
	i2+=lstrlen(buffer+i2)+1;


	////////////////////////
	// R[hƍsԍ̊֌W
	////////////////////////
	extern int MaxLineInfoNum;
	extern LINEINFO *pLineInfo;

	//obt@Ȃꍇ͍Ċm
	if(MaxLineInfoNum*sizeof(LINEINFO)<32768) i3=32768;
	else i3=MaxLineInfoNum*sizeof(LINEINFO)+32768;
	if(BufferSize<i2+i3){
		BufferSize+=i3;
		buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
	}

	*(long *)(buffer+i2)=MaxLineInfoNum;
	i2+=sizeof(long);
	memcpy(buffer+i2,pLineInfo,MaxLineInfoNum*sizeof(LINEINFO));
	i2+=MaxLineInfoNum*sizeof(LINEINFO);



	////////////////////////////////////////////
	// NXiÔ݁Bڍׂ͌ŕۑj
	////////////////////////////////////////////

	//Ce[^Zbg
	extern CDBClass *pobj_DBClass;
	pobj_DBClass->Iterator_Reset();

	//
	*(long *)(buffer+i2)=pobj_DBClass->Iterator_GetMaxCount();
	i2+=sizeof(long);

	while(pobj_DBClass->Iterator_HasNext()){
		CClass *pobj_c;
		pobj_c=pobj_DBClass->Iterator_GetNext();

		//NX
		lstrcpy(buffer+i2,pobj_c->name);
		i2+=lstrlen(buffer+i2)+1;
	}



	//////////////////
	// TypeDef
	//////////////////
	*(long *)(buffer+i2)=(int)House::typeDefs.size();
	i2+=sizeof(long);
	for(i3=0;i3<(int)House::typeDefs.size();i3++){
		lstrcpy(buffer+i2,House::typeDefs[i3].GetNewName().c_str() );
		i2+=lstrlen(buffer+i2)+1;

		lstrcpy(buffer+i2,House::typeDefs[i3].GetBaseName().c_str() );
		i2+=lstrlen(buffer+i2)+1;

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}


	//O[oϐ
	*(long *)(buffer+i2)=(int)::globalVars.size();
	i2+=sizeof(long);
	foreach( Variable *pVar, ::globalVars ){
		//ϐ
		lstrcpy(buffer+i2,pVar->GetName().c_str());
		i2+=lstrlen(buffer+i2)+1;

		//^
		*(long *)(buffer+i2)=pVar->GetBasicType();
		i2+=sizeof(long);

		//^̊g
		SetLpIndex_DebugFile(buffer,&i2,*pVar);

		buffer[i2++] = pVar->IsRef() ? 1 : 0;

		buffer[i2++] = pVar->IsArray() ? 1 : 0;

		if(pVar->IsArray()){
			for(i5=0;;i5++){
				*(long *)(buffer+i2)=pVar->GetSubScriptsPtr()[i5];
				i2+=sizeof(long);
				if(pVar->GetSubScriptsPtr()[i5]==-1) break;
			}
		}

		//LVJXR[v
		*(long *)(buffer+i2)=pVar->ScopeStartAddress;
		i2+=sizeof(long);
		*(long *)(buffer+i2)=pVar->ScopeEndAddress;
		i2+=sizeof(long);
		*(long *)(buffer+i2)=pVar->ScopeLevel;
		i2+=sizeof(long);

		//ʒu
		*(long *)(buffer+i2)=pVar->offset;
		i2+=sizeof(long);

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}

	//O[os̈̃TCY
	extern int GlobalOpBufferSize;
	*(long *)(buffer+i2)=GlobalOpBufferSize;
	i2+=sizeof(long);

	//vV[W
	extern UserProc **ppSubHash;
	extern int SubNum;
	UserProc *pUserProc;
	*(long *)(buffer+i2)=SubNum;
	i2+=sizeof(long);
	for(i3=0;i3<MAX_HASH;i3++){
		pUserProc=ppSubHash[i3];
		while(pUserProc){
			if(pUserProc->GetParentClassPtr()){
				lstrcpy(buffer+i2,pUserProc->GetParentClassPtr()->name);
				i2+=lstrlen(buffer+i2)+1;
			}
			else{
				lstrcpy(buffer+i2,"");
				i2+=lstrlen(buffer+i2)+1;
			}

			//ID
			*(long *)(buffer+i2)=pUserProc->id;
			i2+=sizeof(long);

			//֐
			lstrcpy(buffer+i2,pUserProc->GetName().c_str());
			i2+=lstrlen(buffer+i2)+1;

			*(long *)(buffer+i2)=pUserProc->beginOpAddress;
			i2+=sizeof(long);
			*(long *)(buffer+i2)=pUserProc->endOpAddress;
			i2+=sizeof(long);

			//[Jϐ
			*(long *)(buffer+i2)=(int)pUserProc->localVars.size();
			i2+=sizeof(long);

			//obt@Ȃꍇ͍Ċm
			if(BufferSize<i2+32768){
				BufferSize+=32768;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
			}

			foreach( Variable *pVar, pUserProc->localVars ){
				lstrcpy(buffer+i2,pVar->GetName().c_str());
				i2+=lstrlen(buffer+i2)+1;

				//^
				*(long *)(buffer+i2)=pVar->GetBasicType();
				i2+=sizeof(long);

				//^̊g
				SetLpIndex_DebugFile(buffer,&i2,*pVar);

				//Qƌ^p[^ǂ
				buffer[i2++] = pVar->IsRef() ? 1 : 0;

				//z񂩂ǂ
				buffer[i2++] = pVar->IsArray() ? 1 : 0;

				//zvf
				if(pVar->IsArray()){
					for(i5=0;;i5++){
						*(long *)(buffer+i2)=pVar->GetSubScriptsPtr()[i5];
						i2+=sizeof(long);
						if(pVar->GetSubScriptsPtr()[i5]==-1) break;
					}
				}

				//LVJXR[v
				*(long *)(buffer+i2)=pVar->ScopeStartAddress;
				i2+=sizeof(long);
				*(long *)(buffer+i2)=pVar->ScopeEndAddress;
				i2+=sizeof(long);
				*(long *)(buffer+i2)=pVar->ScopeLevel;
				i2+=sizeof(long);

				//ʒu
				*(long *)(buffer+i2)=pVar->offset;
				i2+=sizeof(long);




				//obt@Ȃꍇ͍Ċm
				if(BufferSize<i2+32768){
					BufferSize+=32768;
					buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
				}
			}

			pUserProc=pUserProc->pNextData;
		}
	}



	///////////////////
	// NX
	///////////////////

	//Ce[^Zbg
	pobj_DBClass->Iterator_Reset();

	while(pobj_DBClass->Iterator_HasNext()){
		CClass *pobj_c;
		pobj_c=pobj_DBClass->Iterator_GetNext();


		//NX
		lstrcpy(buffer+i2,pobj_c->name);
		i2+=lstrlen(buffer+i2)+1;

		//z֐̐
		*(long *)(buffer+i2)=pobj_c->vtbl_num;
		i2+=sizeof(long);

		//ACg
		*(long *)(buffer+i2)=pobj_c->iAlign;
		i2+=sizeof(long);

		//o
		*(long *)(buffer+i2)=pobj_c->iMemberNum;
		i2+=sizeof(long);
		for(i4=0;i4<pobj_c->iMemberNum;i4++){
			lstrcpy(buffer+i2,pobj_c->ppobj_Member[i4]->name);
			i2+=lstrlen(buffer+i2)+1;

			memcpy(buffer+i2,pobj_c->ppobj_Member[i4]->SubScripts,sizeof(int)*MAX_ARRAYDIM);
			i2+=sizeof(int)*MAX_ARRAYDIM;

			//^
			*(long *)(buffer+i2)=pobj_c->ppobj_Member[i4]->GetBasicType();
			i2+=sizeof(long);

			//^̊g
			SetLpIndex_DebugFile(buffer,&i2,*pobj_c->ppobj_Member[i4]);

			*(long *)(buffer+i2)=pobj_c->ppobj_Member[i4]->dwAccess;
			i2+=sizeof(long);

			//obt@Ȃꍇ͍Ċm
			if(BufferSize<i2+32768){
				BufferSize+=32768;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
			}
		}

		//\bh
		*(long *)(buffer+i2)=(long)pobj_c->methods.size();
		i2+=sizeof(long);
		foreach( CMethod *method, pobj_c->methods ){
			*(long *)(buffer+i2)=method->dwAccess;
			i2+=sizeof(long);
			if(method->pobj_InheritsClass){
				lstrcpy(buffer+i2,method->pobj_InheritsClass->name);
				i2+=lstrlen(buffer+i2)+1;
			}
			else{
				lstrcpy(buffer+i2,"");
				i2+=lstrlen(buffer+i2)+1;
			}
			lstrcpy(buffer+i2,method->pUserProc->GetName().c_str());
			i2+=lstrlen(buffer+i2)+1;
		}

		//ÓIo
		*(long *)(buffer+i2)=(long)pobj_c->staticMembers.size();
		i2+=sizeof(long);
		foreach( CMember *member, pobj_c->staticMembers ){
			lstrcpy(buffer+i2,member->name);
			i2+=lstrlen(buffer+i2)+1;

			memcpy(buffer+i2,member->SubScripts,sizeof(int)*MAX_ARRAYDIM);
			i2+=sizeof(int)*MAX_ARRAYDIM;

			//^
			*(long *)(buffer+i2)=member->GetBasicType();
			i2+=sizeof(long);

			//^̊g
			SetLpIndex_DebugFile(buffer,&i2,*member);

			*(long *)(buffer+i2)=member->dwAccess;
			i2+=sizeof(long);

			//obt@Ȃꍇ͍Ċm
			if(BufferSize<i2+32768){
				BufferSize+=32768;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
			}
		}

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}

	length=i2;
}

char *CDebugSection::MakeSingleStepCode(void){
	char *buffer;
	buffer=(char *)HeapAlloc(hHeap,0,SizeOf_CodeSection);

	memcpy(buffer,OpBuffer,SizeOf_CodeSection);

	int i2;
	for(i2=0;i2<MaxLineInfoNum;i2++){
		if(!(
			pLineInfo[i2].dwCodeType&CODETYPE_SYSTEMPROC||
			pLineInfo[i2].dwCodeType&CODETYPE_DEBUGPROC
			)){
			//int 3
			buffer[pLineInfo[i2].TopObp]=(char)0xCC;
		}
	}

	return buffer;
}
BOOL CDebugSection::__load(void){
	int i2,i3,i4,i5,num;
	char temp2[MAX_PATH],*temp5;

	extern CClass *pobj_CompilingClass;
	pobj_CompilingClass=0;

	i2=0;

	//fobOpt@C̃o[W`FbN
	if(*(long *)(buffer+i2)<MDLFILE_VER){
		HeapDefaultFree(buffer);
		return 0;
	}
	i2+=sizeof(long);

	//vbgtH[̃rbg`FbN
	if(*(long *)(buffer+i2)!=PLATFORM){
		HeapDefaultFree(buffer);
		return 0;
	}
	i2+=sizeof(long);

	//CN[h
	IncludeFileInfo.FilesNum=*(long *)(buffer+i2);
	i2+=sizeof(long);
	IncludeFileInfo.ppFileNames=(char **)HeapAlloc(hHeap,0,IncludeFileInfo.FilesNum*sizeof(char *));
	for(i3=0;i3<IncludeFileInfo.FilesNum;i3++){
		if(buffer[i2]=='\0') break;
		IncludeFileInfo.ppFileNames[i3]=(char *)HeapAlloc(hHeap,0,lstrlen(buffer+i2)+1);
		lstrcpy(IncludeFileInfo.ppFileNames[i3],buffer+i2);
		i2+=lstrlen(buffer+i2)+1;
	}
	for(i2++,i3=0;;i2++,i3++){
		IncludeFileInfo.LineOfFile[i3]=(long)buffer[i2];
		if(IncludeFileInfo.LineOfFile[i3]==-1) break;
	}

	//\[XR[h
	i2++;
	pBaseBuffer=(char *)HeapAlloc(hHeap,0,lstrlen(buffer+i2)+3);
	basbuf=pBaseBuffer+2;
	lstrcpy(basbuf,buffer+i2);
	i2+=lstrlen(buffer+i2)+1;
	extern char *basbuf;
	basbuf=this->basbuf;

	//R[hƍsԍ̊֌W
	MaxLineInfoNum=*(long *)(buffer+i2);
	i2+=sizeof(long);
	pLineInfo=(LINEINFO *)HeapAlloc(hHeap,0,MaxLineInfoNum*sizeof(LINEINFO)+1);
	memcpy(pLineInfo,buffer+i2,MaxLineInfoNum*sizeof(LINEINFO));
	i2+=MaxLineInfoNum*sizeof(LINEINFO);


	///////////////////////////////////////////
	// NXiÔ݁Bڍׂ͌Ŏ擾j
	///////////////////////////////////////////

	this->pobj_DBClass=new CDBClass();

	int iMaxClassCount;
	iMaxClassCount=*(long *)(buffer+i2);
	i2+=sizeof(long);
	for(i3=0;i3<iMaxClassCount;i3++){
		//NX
		pobj_DBClass->AddClass(buffer+i2,0);
		i2+=lstrlen(buffer+i2)+1;
	}

	extern CDBClass *pobj_DBClass;
	pobj_DBClass=this->pobj_DBClass;


	//////////////////
	// TypeDef
	//////////////////

	//
	House::typeDefs.clear();

	//擾
	num=*(long *)(buffer+i2);
	i2+=sizeof(long);
	for(i3=0;i3<num;i3++){
		temp5=buffer+i2;
		i2+=lstrlen(buffer+i2)+1;

		House::typeDefs.push_back( TypeDef( temp5, buffer+i2 ) );

		i2+=lstrlen(buffer+i2)+1;
	}

	//萔擾
	GetConstInfo();
	extern CONSTINFO **ppConstHash;
	this->ppConstHash=ppConstHash;


	//O[oϐ
	globalVars.clear();
	int maxGlobalVars=*(long *)(buffer+i2);
	i2+=sizeof(long);
	for(i3=0;i3<maxGlobalVars;i3++){

		//ϐ
		char *name = buffer+i2;
		i2+=lstrlen(buffer+i2)+1;

		int basicType = *(long *)(buffer+i2);
		i2+=sizeof(long);

		Type type( basicType );
		GetLpIndex_DebugFile(buffer,&i2,type);

		bool isRef = (buffer[i2++]) ? true:false;

		bool isArray = (buffer[i2++]) ? true:false;

		Variable *pVar = new Variable( name, type, false, isRef );

		if(isArray){
			int SubScripts[MAX_ARRAYDIM];
			for(i4=0;;i4++){
				SubScripts[i4]=*(long *)(buffer+i2);
				i2+=sizeof(long);

				if(SubScripts[i4]==-1) break;
			}

			pVar->SetArray( SubScripts );
		}

		//LVJXR[v
		pVar->ScopeStartAddress=*(long *)(buffer+i2);
		i2+=sizeof(long);
		pVar->ScopeEndAddress=*(long *)(buffer+i2);
		i2+=sizeof(long);
		pVar->ScopeLevel=*(long *)(buffer+i2);
		i2+=sizeof(long);

		//ʒu
		pVar->offset=*(long *)(buffer+i2);
		i2+=sizeof(long);

		//ϐǉ
		globalVars.push_back( pVar );
	}

	//O[os̈̃TCY
	GlobalOpBufferSize=*(long *)(buffer+i2);
	i2+=sizeof(long);

	//vV[W
	UserProc *pUserProc;
	SubNum=*(long *)(buffer+i2);
	i2+=sizeof(long);
	ppSubHash=(UserProc **)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,MAX_HASH*sizeof(UserProc *));
	for(int i6=0;i6<SubNum;i6++){
		char szParentClassName[VN_SIZE];
		lstrcpy(szParentClassName,buffer+i2);
		i2+=lstrlen(buffer+i2)+1;

		CClass *pClass = NULL;
		if(szParentClassName[0])
			pClass=pobj_DBClass->check(szParentClassName);

		//ID
		int id=*(long *)(buffer+i2);
		i2+=sizeof(long);

		//O
		char *name = buffer+i2;
		i2+=lstrlen(buffer+i2)+1;

		// IuWFNg𐶐
		pUserProc = new UserProc( name, UserProc::Function, false, false, false );
		pUserProc->pNextData=0;
		pUserProc->id=id;
		pUserProc->SetParentClass( pClass );

		pUserProc->beginOpAddress=*(long *)(buffer+i2);
		i2+=sizeof(long);
		pUserProc->endOpAddress=*(long *)(buffer+i2);
		i2+=sizeof(long);

		pUserProc->CompleteCompile();

		//[Jϐ
		pUserProc->localVars.clear();
		int maxLocalVar=*(long *)(buffer+i2);
		i2+=sizeof(long);
		for(i3=0;i3<maxLocalVar;i3++){
			//ϐ
			char *name = buffer+i2;
			i2+=lstrlen(buffer+i2)+1;

			int basicType = *(long *)(buffer+i2);
			i2+=sizeof(long);

			Type type( basicType );
			GetLpIndex_DebugFile(buffer,&i2,type);

			bool isRef = (buffer[i2++]) ? true:false;

			bool isArray = (buffer[i2++]) ? true:false;

			Variable *pVar = new Variable( name, type, false, isRef );

			if(isArray){
				int SubScripts[MAX_ARRAYDIM];
				for(i4=0;;i4++){
					SubScripts[i4]=*(long *)(buffer+i2);
					i2+=sizeof(long);

					if(SubScripts[i4]==-1) break;
				}

				pVar->SetArray( SubScripts );
			}

			//LVJXR[v
			pVar->ScopeStartAddress=*(long *)(buffer+i2);
			i2+=sizeof(long);
			pVar->ScopeEndAddress=*(long *)(buffer+i2);
			i2+=sizeof(long);
			pVar->ScopeLevel=*(long *)(buffer+i2);
			i2+=sizeof(long);

			//ʒu
			pVar->offset=*(long *)(buffer+i2);
			i2+=sizeof(long);

			//ϐǉ
			pUserProc->localVars.push_back( pVar );
		}


		/////////////////////////////////
		// i[ʒuvZpUserProcZbg
		/////////////////////////////////

		i4=hash_default(pUserProc->GetName().c_str());

		UserProc *psi2;
		if(ppSubHash[i4]){
			psi2=ppSubHash[i4];
			while(1){
				if(psi2->pNextData==0){
					psi2->pNextData=pUserProc;
					break;
				}
				psi2=psi2->pNextData;
			}
		}
		else{
			ppSubHash[i4]=pUserProc;
		}
	}

	//NX
	CClass *pobj_c;
	for(i3=0;i3<iMaxClassCount;i3++){
		//NX
		char szClassName[VN_SIZE];
		lstrcpy(szClassName,buffer+i2);
		i2+=lstrlen(buffer+i2)+1;

		pobj_c=pobj_DBClass->check(szClassName);

		//z֐̐
		pobj_c->vtbl_num=*(long *)(buffer+i2);
		i2+=sizeof(long);

		//ACg
		pobj_c->iAlign=*(long *)(buffer+i2);
		i2+=sizeof(long);

		//o
		pobj_c->iMemberNum=*(long *)(buffer+i2);
		i2+=sizeof(long);
		pobj_c->ppobj_Member=
			(CMember **)HeapAlloc(hHeap,0,pobj_c->iMemberNum*sizeof(CMember *));
		for(i4=0;i4<pobj_c->iMemberNum;i4++){
			pobj_c->ppobj_Member[i4]=new CMember();

			pobj_c->ppobj_Member[i4]->name=(char *)HeapAlloc(hHeap,0,lstrlen(buffer+i2)+1);
			lstrcpy(pobj_c->ppobj_Member[i4]->name,buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			memcpy(pobj_c->ppobj_Member[i4]->SubScripts,buffer+i2,sizeof(int)*MAX_ARRAYDIM);
			i2+=sizeof(int)*MAX_ARRAYDIM;

			//^
			Type type( *(long *)(buffer+i2) );
			i2+=sizeof(long);

			//^̊g
			GetLpIndex_DebugFile(buffer,&i2,type);

			pobj_c->ppobj_Member[i4]->SetType( type.GetBasicType(), type.GetIndex() );

			pobj_c->ppobj_Member[i4]->dwAccess=*(long *)(buffer+i2);
			i2+=sizeof(long);
		}

		//\bh
		int nMethod = *(long *)(buffer+i2);
		i2+=sizeof(long);
		for( i4=0; i4<nMethod; i4++ ){
			CMethod *method = new CMethod();

			method->dwAccess=*(long *)(buffer+i2);
			i2+=sizeof(long);

			char szInherits[VN_SIZE];
			lstrcpy(szInherits,buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			if(szInherits[0])
				method->pobj_InheritsClass=pobj_DBClass->check(szInherits);
			else method->pobj_InheritsClass=0;

			lstrcpy(temp2,buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			CClass *pobj_temp_c;
			pobj_temp_c=method->pobj_InheritsClass;
			if(pobj_temp_c==0) pobj_temp_c=pobj_c;
			i5=hash_default(temp2);
			pUserProc=ppSubHash[i5];
			while(1){
				if( pUserProc->GetName() == temp2 &&pUserProc->GetParentClassPtr()==pobj_temp_c) break;
				pUserProc=pUserProc->pNextData;
			}
			method->pUserProc=pUserProc;

			pobj_c->methods.push_back( method );
		}

		//ÓIo
		int nStaticMember = *(long *)(buffer+i2);
		i2+=sizeof(long);
		for( i4=0; i4<nStaticMember; i4++ ){
			CMember *member=new CMember();

			member->name=(char *)HeapAlloc(hHeap,0,lstrlen(buffer+i2)+1);
			lstrcpy(member->name,buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			memcpy(member->SubScripts,buffer+i2,sizeof(int)*MAX_ARRAYDIM);
			i2+=sizeof(int)*MAX_ARRAYDIM;

			//^
			Type type( *(long *)(buffer+i2) );
			i2+=sizeof(long);

			//^̊g
			GetLpIndex_DebugFile(buffer,&i2,type);

			member->SetType( type.GetBasicType(), type.GetIndex() );

			member->dwAccess=*(long *)(buffer+i2);
			i2+=sizeof(long);

			pobj_c->staticMembers.push_back( member );
		}
	}

	HeapDefaultFree(buffer);
	buffer=0;




	extern UserProc **ppSubHash;
	ppSubHash=this->ppSubHash;
	pSub_DebugSys_EndProc=GetSubHash("_DebugSys_EndProc");


	SingleStepCodeBuffer=MakeSingleStepCode();


	/////////////////////////////
	// u[N|CgKp
	/////////////////////////////

	//CN[h
	extern INCLUDEFILEINFO IncludeFileInfo;
	IncludeFileInfo=this->IncludeFileInfo;

	//R[hƍsԍ̊֌W
	extern int MaxLineInfoNum;
	extern LINEINFO *pLineInfo;
	MaxLineInfoNum=this->MaxLineInfoNum;
	pLineInfo=this->pLineInfo;

	BreakStepCodeBuffer=pobj_DBBreakPoint->update(OpBuffer,SizeOf_CodeSection);

	//vZXɃRs[
	extern HANDLE hDebugProcess;
	SIZE_T accessBytes;
	WriteProcessMemory(hDebugProcess,(void *)(ULONG_PTR)(dwImageBase+dwRVA_CodeSection),
		BreakStepCodeBuffer,
		SizeOf_CodeSection,&accessBytes);


	return 1;
}

BOOL CDebugSection::load(HMODULE hModule){
	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}


	extern HANDLE hDebugProcess;
	SIZE_T accessBytes;
	IMAGE_DOS_HEADER ImageDosHeader;
	ReadProcessMemory(hDebugProcess,hModule,&ImageDosHeader,sizeof(IMAGE_DOS_HEADER),&accessBytes);

	int pe_size;
#ifdef _AMD64_
	IMAGE_NT_HEADERS64 pe_hdr;
	pe_size=sizeof(IMAGE_NT_HEADERS64);
#else
	IMAGE_NT_HEADERS pe_hdr;
	pe_size=sizeof(IMAGE_NT_HEADERS);
#endif
	ReadProcessMemory(hDebugProcess,(void *)(((ULONG_PTR)hModule)+ImageDosHeader.e_lfanew),&pe_hdr,pe_size,&accessBytes);

	IMAGE_SECTION_HEADER *pSectionHdr;
	pSectionHdr=(IMAGE_SECTION_HEADER *)HeapAlloc(hHeap,0,pe_hdr.FileHeader.NumberOfSections*sizeof(IMAGE_SECTION_HEADER));
	ReadProcessMemory(hDebugProcess,
		(void *)(((ULONG_PTR)hModule)+ImageDosHeader.e_lfanew+pe_size),
		pSectionHdr,
		pe_hdr.FileHeader.NumberOfSections*sizeof(IMAGE_SECTION_HEADER),
		&accessBytes);

	int i;
	for(i=0;i<pe_hdr.FileHeader.NumberOfSections;i++){

		//C^uZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".data")==0){
			dwRVA_RWSection=pSectionHdr[i].VirtualAddress;
		}

		//R[hZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".text")==0){
			dwRVA_CodeSection=pSectionHdr[i].VirtualAddress;
			SizeOf_CodeSection=pSectionHdr[i].SizeOfRawData;
		}

		//fobOZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".debug")==0){
			length=pSectionHdr[i].Misc.VirtualSize;
			buffer=(char *)HeapAlloc(hHeap,0,length+1);

			ReadProcessMemory(hDebugProcess,
				(void *)(((ULONG_PTR)hModule)+pSectionHdr[i].VirtualAddress),
				buffer,
				length,
				&accessBytes);
			buffer[length]=0;
		}

	}
	HeapDefaultFree(pSectionHdr);

	if(!buffer) return 0;


	dwImageBase=(DWORD)(ULONG_PTR)hModule;



	if(OpBuffer) HeapDefaultFree(OpBuffer);
	OpBuffer=(char *)HeapAlloc(hHeap,0,SizeOf_CodeSection);

	ReadProcessMemory(hDebugProcess,
		(void *)(ULONG_PTR)(dwImageBase+dwRVA_CodeSection),OpBuffer,
		SizeOf_CodeSection,&accessBytes);


	return __load();
}

void CDebugSection::choice(void){
	//C[Wx[X
	extern DWORD ImageBase;
	ImageBase=this->dwImageBase;

	//C^uZNVRVA
	extern int MemPos_RWSection;
	MemPos_RWSection=this->dwRVA_RWSection;

	//R[hZNVRVAƃTCY
	extern int MemPos_CodeSection;
	extern int FileSize_CodeSection;
	MemPos_CodeSection=this->dwRVA_CodeSection;
	FileSize_CodeSection=this->SizeOf_CodeSection;

	//CN[h
	extern INCLUDEFILEINFO IncludeFileInfo;
	IncludeFileInfo=this->IncludeFileInfo;

	//\[XR[h
	extern char *pBaseBuffer;
	extern char *basbuf;
	pBaseBuffer=this->pBaseBuffer;
	basbuf=this->basbuf;

	//R[hƍsԍ̊֌W
	extern int MaxLineInfoNum;
	extern LINEINFO *pLineInfo;
	MaxLineInfoNum=this->MaxLineInfoNum;
	pLineInfo=this->pLineInfo;

	// NX
	extern CDBClass *pobj_DBClass;
	pobj_DBClass=this->pobj_DBClass;

	//萔擾
	extern CONSTINFO **ppConstHash;
	ppConstHash=this->ppConstHash;

	//O[os̈̃TCY
	extern int GlobalOpBufferSize;
	GlobalOpBufferSize=this->GlobalOpBufferSize;

	//vV[W
	extern char **ppMacroNames;
	ppMacroNames=0;
	extern UserProc **ppSubHash;
	extern int SubNum;
	ppSubHash=this->ppSubHash;
	SubNum=this->SubNum;

	extern UserProc *pSub_DebugSys_EndProc;
	pSub_DebugSys_EndProc=this->pSub_DebugSys_EndProc;

	//lCeBuR[hobt@
	extern char *OpBuffer;
	OpBuffer=this->OpBuffer;
}

void CDebugSection::DeleteDebugInfo(void){
	int i2;

	//CN[h
	for(i2=0;i2<IncludeFileInfo.FilesNum;i2++)
		HeapDefaultFree(IncludeFileInfo.ppFileNames[i2]);
	HeapDefaultFree(IncludeFileInfo.ppFileNames);

	//NXɊւ郁
	delete pobj_DBClass;
	pobj_DBClass=0;

	//Tu[`̃
	DeleteSubInfo(ppSubHash,0,0);

	//萔Ɋւ
	DeleteConstInfo(ppConstHash);

	//\[XR[h
	HeapDefaultFree(pBaseBuffer);

	//R[hƍsԍ̊֌W
	HeapDefaultFree(pLineInfo);

	//R[hobt@
	HeapDefaultFree(OpBuffer);
	OpBuffer=0;

	HeapDefaultFree(SingleStepCodeBuffer);
	SingleStepCodeBuffer=0;

	HeapDefaultFree(BreakStepCodeBuffer);
	BreakStepCodeBuffer=0;
}



CDBDebugSection::CDBDebugSection(){
	ppobj_ds=(CDebugSection **)HeapAlloc(hHeap,0,1);
	num=0;
}
CDBDebugSection::~CDBDebugSection(){
	int i;
	for(i=0;i<num;i++){
		delete ppobj_ds[i];
	}
	HeapDefaultFree(ppobj_ds);
}

BOOL CDBDebugSection::add(HMODULE hModule){
	CDebugSection *pobj_d;
	pobj_d=new CDebugSection();
	if(!pobj_d->load(hModule)){
		//fobO񂪑݂ȂƂ
		delete pobj_d;
		return 0;
	}

	ppobj_ds=(CDebugSection **)HeapReAlloc(hHeap,0,ppobj_ds,(num+1)*sizeof(CDebugSection *));
	ppobj_ds[num]=pobj_d;
	num++;

	return 1;
}

void CDBDebugSection::del(HMODULE hModule){
	int i;
	for(i=0;i<num;i++){
		if((HMODULE)(ULONG_PTR)ppobj_ds[i]->dwImageBase==hModule){
			delete ppobj_ds[i];

			num--;
			for(;i<num;i++){
				ppobj_ds[i]=ppobj_ds[i+1];
			}
			break;
		}
	}
}

void CDBDebugSection::choice(int index){
	pobj_now=ppobj_ds[index];
	pobj_now->choice();
}



CDBDebugSection *pobj_DBDebugSection;
